/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.feature.orm.dialect;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgrePageHepler {
    public static String getCountString(String querySelect) {
        querySelect = PostgrePageHepler.getLineSql(querySelect);
        int orderIndex = PostgrePageHepler.getLastOrderInsertPoint(querySelect);
        int formIndex = PostgrePageHepler.getAfterFormInsertPoint(querySelect);
        String select = querySelect.substring(0, formIndex);
        if (select.toLowerCase().indexOf("select distinct") != -1 || querySelect.toLowerCase().indexOf("group by") != -1) {
            return new StringBuffer(querySelect.length()).append("select count(1) count from (").append(querySelect.substring(0, orderIndex)).append(" ) t").toString();
        }
        return new StringBuffer(querySelect.length()).append("select count(1) count ").append(querySelect.substring(formIndex, orderIndex)).toString();
    }

    private static int getLastOrderInsertPoint(String querySelect) {
        int orderIndex = querySelect.toLowerCase().lastIndexOf("order by");
        if (orderIndex == -1) {
            orderIndex = querySelect.length();
        }
        if (!PostgrePageHepler.isBracketCanPartnership(querySelect.substring(orderIndex, querySelect.length()))) {
            throw new RuntimeException("Postgre \u5206\u9875\u5fc5\u987b\u8981\u6709Order by \u8bed\u53e5!");
        }
        return orderIndex;
    }

    public static String getLimitString(String querySelect, int offset, int limit) {
        querySelect = PostgrePageHepler.getLineSql(querySelect);
        String sql = querySelect + " LIMIT " + limit + " OFFSET " + offset;
        return sql;
    }

    private static String getLineSql(String sql) {
        return sql.replaceAll("[\r\n]", " ").replaceAll("\\s{2,}", " ");
    }

    private static int getAfterFormInsertPoint(String querySelect) {
        String regex = "\\s+FROM\\s+";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(querySelect);
        while (matcher.find()) {
            int fromStartIndex = matcher.start(0);
            String text = querySelect.substring(0, fromStartIndex);
            if (!PostgrePageHepler.isBracketCanPartnership(text)) continue;
            return fromStartIndex;
        }
        return 0;
    }

    private static boolean isBracketCanPartnership(String text) {
        return text != null && PostgrePageHepler.getIndexOfCount(text, '(') == PostgrePageHepler.getIndexOfCount(text, ')');
    }

    private static int getIndexOfCount(String text, char ch) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            count = text.charAt(i) == ch ? count + 1 : count;
        }
        return count;
    }
}

