/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.utils;

import com.chinaunicom.function.bo.ReqInfoBO;
import com.chinaunicom.number.utils.BeanHelper;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationUtils {
    private static Logger log = LoggerFactory.getLogger(ApplicationUtils.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Object[] parameterConversion(HttpServletRequest request, String interfaceType, String method2) {
        log.debug("\u5c06\u524d\u53f0\u7684\u53c2\u6570\u5c01\u88c5\u5f00\u59cb\u3002\u3002\u3002");
        log.debug("interfaceType == " + interfaceType);
        log.debug("method == " + method2);
        Object[] objs = null;
        try {
            Method[] methods;
            Class<?> c = Class.forName(interfaceType);
            for (Method m : methods = c.getMethods()) {
                log.debug("Method.getName = " + m.getName());
                if (!method2.equals(m.getName())) continue;
                Class<?>[] ct = m.getParameterTypes();
                log.debug("ct == " + ct);
                if (ct.length > 0) {
                    objs = new Object[ct.length];
                    int i = 0;
                    for (Class<?> class1 : ct) {
                        log.debug("class1 = " + class1.toString());
                        Object obj = BeanHelper.createBean(ct[i], request.getParameterMap(), null);
                        log.debug("obj:" + obj);
                        objs[i] = obj;
                        ++i;
                    }
                }
                break;
            }
        }
        catch (ClassNotFoundException e) {
            log.error("9998", (Object)"\u63a5\u53e3\u7c7b\u578b\u5b9a\u4e49\u9519\u8bef", (Object)e);
        }
        catch (Exception e) {
            log.error("9999", (Object)"\u5c06\u524d\u53f0\u7684\u53c2\u6570\u5c01\u88c5\u5931\u8d25", (Object)e);
        }
        return objs;
    }

    @Deprecated
    public static Object[] parameterMapConversion(String interfaceType, String method2, Map<String, Object> parameters, int nowPage, int pageSize) {
        log.debug("\u5c06\u524d\u53f0\u7684\u53c2\u6570\u5c01\u88c5\u5f00\u59cb\u3002\u3002\u3002");
        log.debug("nowPage == " + nowPage);
        log.debug("pageSize == " + pageSize);
        log.debug("interfaceType == " + interfaceType);
        log.debug("method == " + method2);
        Object[] objs = null;
        try {
            Method[] methods;
            Class<?> c = Class.forName(interfaceType);
            for (Method m : methods = c.getMethods()) {
                log.debug("Method.getName = " + m.getName());
                if (!method2.equals(m.getName())) continue;
                Class<?>[] ct = m.getParameterTypes();
                log.debug("ct == " + ct);
                if (ct.length > 0) {
                    objs = new Object[ct.length];
                    int i = 0;
                    for (Class<?> class1 : ct) {
                        log.debug("class1 = " + class1.toString());
                        Object o = class1.newInstance();
                        for (Field f : class1.getDeclaredFields()) {
                            Constable a;
                            log.debug("f.getName=" + f.getName());
                            if (!parameters.containsKey(f.getName()) || "".equals(parameters.get(f.getName()))) continue;
                            f.setAccessible(true);
                            if (f.getType() == Long.class || f.getType() == Long.TYPE) {
                                a = Long.parseLong(String.valueOf(parameters.get(f.getName())));
                                f.set(o, a);
                                continue;
                            }
                            if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                                a = Integer.parseInt(String.valueOf(parameters.get(f.getName())));
                                f.set(o, a);
                                continue;
                            }
                            if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                                a = Boolean.valueOf(Boolean.parseBoolean(String.valueOf(parameters.get(f.getName()))));
                                f.set(o, a);
                                continue;
                            }
                            if (f.getType() == Double.class || f.getType() == Double.TYPE) {
                                a = Double.parseDouble(String.valueOf(parameters.get(f.getName())));
                                f.set(o, a);
                                continue;
                            }
                            if (f.getType() == Byte.class || f.getType() == Byte.TYPE) {
                                a = Byte.parseByte(String.valueOf(parameters.get(f.getName())));
                                f.set(o, a);
                                continue;
                            }
                            if (f.getType() == Short.class || f.getType() == Short.TYPE) {
                                a = Short.parseShort(String.valueOf(parameters.get(f.getName())));
                                f.set(o, a);
                                continue;
                            }
                            if (f.getType() == Float.class || f.getType() == Float.TYPE) {
                                a = Float.valueOf(Float.parseFloat(String.valueOf(parameters.get(f.getName()))));
                                f.set(o, a);
                                continue;
                            }
                            if (f.getType() == Date.class) {
                                Date date = sdf.parse(String.valueOf(parameters.get(f.getName())));
                                f.set(o, date);
                                continue;
                            }
                            if (f.getType() == String.class) {
                                f.set(o, parameters.get(f.getName()) == null ? "" : ("null".equals(parameters.get(f.getName())) ? "" : String.valueOf(parameters.get(f.getName()))));
                                continue;
                            }
                            f.set(o, parameters.get(f.getName()));
                        }
                        if (o instanceof ReqInfoBO) {
                            Field field = ReqInfoBO.class.getDeclaredField("pageNo");
                            field.setAccessible(true);
                            field.set(o, nowPage);
                            field = ReqInfoBO.class.getDeclaredField("pageSize");
                            field.setAccessible(true);
                            field.set(o, pageSize);
                        }
                        objs[i] = o;
                        ++i;
                    }
                }
                break;
            }
        }
        catch (ClassNotFoundException e) {
            log.error("9998", (Object)"\u63a5\u53e3\u7c7b\u578b\u5b9a\u4e49\u9519\u8bef", (Object)e);
        }
        catch (Exception e) {
            log.error("9999", (Object)"\u5c06\u524d\u53f0\u7684\u53c2\u6570\u5c01\u88c5\u5931\u8d25", (Object)e);
        }
        return objs;
    }

    public static Object getSessionValue(Object key) {
        log.debug("key==" + key);
        Subject subject = SecurityUtils.getSubject();
        return subject.getSession().getAttribute(key);
    }

    public static void putSessionValue(Object key, Object value) {
        log.debug("key==" + key);
        log.debug("value=" + value);
        Subject subject = SecurityUtils.getSubject();
        subject.getSession().setAttribute(key, value);
    }

    public static ReqInfoBO getUserInfo() {
        ReqInfoBO acct = (ReqInfoBO)SecurityUtils.getSubject().getPrincipal();
        log.debug("==============\u5f53\u524d\u64cd\u4f5c\u4eba\u7684\u4fe1\u606f:" + acct);
        return acct;
    }
}

