/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.utils;

import com.chinaunicom.number.utils.GeneralHelper;
import com.chinaunicom.number.utils.Result;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class BeanHelper {
    public static final Set<Class<?>> SMIPLE_CLASS_SET = new HashSet(18);
    public static final Set<Class<?>> WRAPPER_CLASS_SET = new HashSet(8);
    private static final String STRING_DELIMITERS = " ,;|\t\n\r\f";
    private static final char ATTR_SEP_CHAR = '.';

    public static final boolean isInstanceField(Field field) {
        int flag = field.getModifiers();
        return !Modifier.isStatic(flag);
    }

    public static final boolean isInstanceNotFinalField(Field field) {
        int flag = field.getModifiers();
        return !Modifier.isStatic(flag) && !Modifier.isFinal(flag);
    }

    public static final boolean isPublicInstanceMethod(Method method2) {
        int flag = method2.getModifiers();
        return !Modifier.isStatic(flag) && !Modifier.isAbstract(flag) && Modifier.isPublic(flag);
    }

    public static final boolean isPublicInterface(Class<?> clazz) {
        int flag = clazz.getModifiers();
        return Modifier.isInterface(flag) && Modifier.isPublic(flag);
    }

    public static final boolean isPublicClass(Class<?> clazz) {
        int flag = clazz.getModifiers();
        return !Modifier.isInterface(flag) && Modifier.isPublic(flag);
    }

    public static final boolean isPublicNotAbstractClass(Class<?> clazz) {
        int flag = clazz.getModifiers();
        return !Modifier.isInterface(flag) && !Modifier.isAbstract(flag) && Modifier.isPublic(flag);
    }

    public static final boolean isSimpleType(Class<?> clazz) {
        return SMIPLE_CLASS_SET.contains(clazz);
    }

    public static final boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_CLASS_SET.contains(clazz);
    }

    public static final boolean isWrapperAndPrimitiveMatch(Class<?> wrapperClazz, Class<?> primitiveClass) {
        if (!primitiveClass.isPrimitive()) {
            return false;
        }
        if (!BeanHelper.isWrapperType(wrapperClazz)) {
            return false;
        }
        try {
            Field f = wrapperClazz.getDeclaredField("TYPE");
            return f.get(null) == primitiveClass;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean isCompatibleType(Class<?> srcClazz, Class<?> destClazz) {
        return destClazz.isAssignableFrom(srcClazz) || BeanHelper.isWrapperAndPrimitiveMatch(destClazz, srcClazz) || BeanHelper.isWrapperAndPrimitiveMatch(srcClazz, destClazz);
    }

    public static final boolean isCompatibleArray(Class<?> srcClazz, Class<?> destClazz) {
        if (srcClazz.isArray() && destClazz.isArray()) {
            Class<?> srcComponentType = srcClazz.getComponentType();
            Class<?> destComponentType = destClazz.getComponentType();
            return BeanHelper.isCompatibleType(srcComponentType, destComponentType);
        }
        return false;
    }

    public static final boolean isCascadableProperty(PropertyDescriptor pd) {
        return pd != null && BeanHelper.getPropertyWriteMethod(pd) != null && BeanHelper.isCascadable(pd.getPropertyType());
    }

    public static final boolean isCascadableField(Field f) {
        return f != null && BeanHelper.isInstanceNotFinalField(f) && BeanHelper.isCascadable(f.getType());
    }

    public static final boolean isCascadable(Class<?> clazz) {
        return BeanHelper.isPublicNotAbstractClass(clazz) && !BeanHelper.isSimpleType(clazz) && !clazz.isArray() && !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz);
    }

    public static final <B, T> B createBean(Class<B> clazz, Map<String, T> properties) {
        return BeanHelper.createBean(clazz, properties, null);
    }

    public static final <B, T> B createBean(Class<B> clazz, Map<String, T> valueMap, Map<String, String> keyMap) {
        B bean = null;
        try {
            bean = clazz.newInstance();
            BeanHelper.setPropertiesOrFieldValues(bean, valueMap, keyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bean;
    }

    public static final <B, T> B createBeanByProperties(Class<B> clazz, Map<String, T> properties) {
        return BeanHelper.createBeanByProperties(clazz, properties, null);
    }

    public static final <B, T> B createBeanByProperties(Class<B> clazz, Map<String, T> properties, Map<String, String> keyMap) {
        B bean = null;
        try {
            bean = clazz.newInstance();
            BeanHelper.setProperties(bean, properties, keyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bean;
    }

    public static final <B, T> B createBeanByFieldValues(Class<B> clazz, Map<String, T> values) {
        return BeanHelper.createBeanByFieldValues(clazz, values, null);
    }

    public static final <B, T> B createBeanByFieldValues(Class<B> clazz, Map<String, T> values, Map<String, String> keyMap) {
        B bean = null;
        try {
            bean = clazz.newInstance();
            BeanHelper.setFieldValues(bean, values, keyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bean;
    }

    public static final <T> void setProperties(Object bean, Map<String, T> properties) {
        BeanHelper.setProperties(bean, properties, null);
    }

    public static final <T> void setProperties(Object bean, Map<String, T> properties, Map<String, String> keyMap) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashMap<Object, Map<String, T>> subs = new HashMap<Object, Map<String, T>>();
        Map<String, PropertyDescriptor> pps = BeanHelper.getPropDescMap(bean.getClass());
        Map<String, T> params = BeanHelper.translateKVMap(properties, keyMap);
        BeanHelper.parseCascadeProperties(bean, subs, pps, params, null);
        if (!subs.isEmpty()) {
            Set sset = subs.entrySet();
            for (Map.Entry e : sset) {
                try {
                    PropertyDescriptor key = (PropertyDescriptor)e.getKey();
                    Object o = key.getPropertyType().newInstance();
                    BeanHelper.setProperties(o, (Map)e.getValue());
                    BeanHelper.setProperty(bean, key, o);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static final <T> void setFieldValues(Object bean, Map<String, T> values) {
        BeanHelper.setFieldValues(bean, values, null);
    }

    public static final <T> void setFieldValues(Object bean, Map<String, T> values, Map<String, String> keyMap) {
        if (values == null || values.isEmpty()) {
            return;
        }
        HashMap<Object, Map<String, T>> subs = new HashMap<Object, Map<String, T>>();
        Map<String, Field> fms = BeanHelper.getInstanceFieldMap(bean.getClass());
        Map<String, T> params = BeanHelper.translateKVMap(values, keyMap);
        BeanHelper.parseCascadeFields(bean, subs, fms, params);
        if (!subs.isEmpty()) {
            Set sset = subs.entrySet();
            for (Map.Entry e : sset) {
                try {
                    Field key = (Field)e.getKey();
                    Object o = key.getType().newInstance();
                    BeanHelper.setFieldValues(o, (Map)e.getValue());
                    BeanHelper.setFieldValue(bean, key, o);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static final <T> void setPropertiesOrFieldValues(Object bean, Map<String, T> valueMap) {
        BeanHelper.setPropertiesOrFieldValues(bean, valueMap, null);
    }

    public static final <T> void setPropertiesOrFieldValues(Object bean, Map<String, T> valueMap, Map<String, String> keyMap) {
        if (valueMap == null || valueMap.isEmpty()) {
            return;
        }
        HashMap<Object, Map<String, T>> subs = new HashMap<Object, Map<String, T>>();
        Map<String, PropertyDescriptor> pps = BeanHelper.getPropDescMap(bean.getClass());
        Map<String, T> params = BeanHelper.translateKVMap(valueMap, keyMap);
        HashMap failParams = new HashMap();
        BeanHelper.parseCascadeProperties(bean, subs, pps, params, failParams);
        if (!failParams.isEmpty()) {
            Map<String, Field> fms = BeanHelper.getInstanceFieldMap(bean.getClass());
            BeanHelper.parseCascadeFields(bean, subs, fms, failParams);
        }
        if (!subs.isEmpty()) {
            Set sset = subs.entrySet();
            for (Map.Entry e : sset) {
                Object key = e.getKey();
                Map value = (Map)e.getValue();
                try {
                    Object o;
                    if (key instanceof PropertyDescriptor) {
                        PropertyDescriptor pd = (PropertyDescriptor)key;
                        o = pd.getPropertyType().newInstance();
                        BeanHelper.setPropertiesOrFieldValues(o, value);
                        BeanHelper.setProperty(bean, pd, o);
                        continue;
                    }
                    Field f = (Field)key;
                    o = f.getType().newInstance();
                    BeanHelper.setPropertiesOrFieldValues(o, value);
                    BeanHelper.setFieldValue(bean, f, o);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private static <T> void parseCascadeProperties(Object bean, Map<Object, Map<String, T>> subs, Map<String, PropertyDescriptor> pps, Map<String, T> params, Map<String, T> failParams) {
        Set<Map.Entry<String, T>> set = params.entrySet();
        for (Map.Entry<String, T> e : set) {
            String key = e.getKey();
            T value = e.getValue();
            int index = key.indexOf(46);
            if (index == -1) {
                PropertyDescriptor pd = pps.get(key);
                if (BeanHelper.getPropertyWriteMethod(pd) != null) {
                    BeanHelper.setProperty(bean, pd, value);
                    continue;
                }
                if (failParams == null) continue;
                failParams.put(key, value);
                continue;
            }
            String skey = key.substring(0, index);
            PropertyDescriptor pd = pps.get(skey);
            if (BeanHelper.getPropertyWriteMethod(pd) == null) {
                if (failParams == null) continue;
                failParams.put(key, value);
                continue;
            }
            if (!BeanHelper.isCascadableProperty(pd)) continue;
            if (!subs.containsKey(pd)) {
                subs.put(pd, new HashMap());
            }
            subs.get(pd).put(key.substring(index + 1), value);
        }
    }

    private static <T> void parseCascadeFields(Object bean, Map<Object, Map<String, T>> subs, Map<String, Field> fms, Map<String, T> params) {
        Set<Map.Entry<String, T>> set = params.entrySet();
        for (Map.Entry<String, T> e : set) {
            String key = e.getKey();
            T value = e.getValue();
            int index = key.indexOf(46);
            if (index == -1) {
                Field f = fms.get(key);
                BeanHelper.setFieldValue(bean, f, value);
                continue;
            }
            String skey = key.substring(0, index);
            Field f = fms.get(skey);
            if (!BeanHelper.isCascadableField(f)) continue;
            if (!subs.containsKey(f)) {
                subs.put(f, new HashMap());
            }
            subs.get(f).put(key.substring(index + 1), value);
        }
    }

    private static final <T> Map<String, T> translateKVMap(Map<String, T> valueMap, Map<String, String> keyMap) {
        if (keyMap == null || keyMap.isEmpty()) {
            return valueMap;
        }
        HashMap<String, T> resultMap = new HashMap<String, T>();
        Set<Map.Entry<String, T>> set = valueMap.entrySet();
        for (Map.Entry<String, T> e : set) {
            String key;
            String name = key = e.getKey();
            if (keyMap.containsKey(key)) {
                name = keyMap.get(key);
            }
            resultMap.put(name, e.getValue());
        }
        return resultMap;
    }

    public static final <T> boolean setProperty(Object bean, PropertyDescriptor pd, T value) {
        Method method2;
        if (pd != null && (method2 = BeanHelper.getPropertyWriteMethod(pd)) != null) {
            Result<Boolean, Object> result;
            Type[] types;
            Type genericType = null;
            Class<?> clazz = pd.getPropertyType();
            if (Collection.class.isAssignableFrom(clazz) && value != null && !clazz.isAssignableFrom(value.getClass()) && (types = method2.getGenericParameterTypes()).length > 0) {
                genericType = types[0];
            }
            if ((result = BeanHelper.parseValue(value, clazz, genericType)).getFlag().booleanValue()) {
                BeanHelper.invokeMethod(bean, method2, result.getValue());
                return true;
            }
        }
        return false;
    }

    public static final <T> boolean setFieldValue(Object bean, Field field, T value) {
        Type genericType;
        Class<?> clazz;
        Result<Boolean, Object> result;
        if (field != null && BeanHelper.isInstanceNotFinalField(field) && (result = BeanHelper.parseValue(value, clazz = field.getType(), genericType = field.getGenericType())).getFlag().booleanValue()) {
            BeanHelper.invokeSetFieldValue(bean, field, result.getValue());
            return true;
        }
        return false;
    }

    public static final <T> Result<Boolean, Object> parseValue(T value, Class<?> clazz, Type genericType) {
        Result<Boolean, Object> result = Result.initialBoolean();
        if (value == null) {
            if (clazz.isPrimitive()) {
                result.set(Boolean.TRUE, GeneralHelper.str2Object(clazz, (String)value));
            } else {
                result.set(Boolean.TRUE, value);
            }
        } else if (clazz.isAssignableFrom(value.getClass())) {
            result.set(Boolean.TRUE, value);
        } else if (BeanHelper.isWrapperAndPrimitiveMatch(value.getClass(), clazz)) {
            result.set(Boolean.TRUE, value);
        } else if (BeanHelper.isCompatibleArray(value.getClass(), clazz)) {
            BeanHelper.getArrayValue(value, clazz.getComponentType(), result);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            BeanHelper.getCollectionValue(value, clazz, genericType, result);
        } else {
            BeanHelper.getSimpleValue(value, clazz, result);
        }
        return result;
    }

    private static final <T> void getArrayValue(T value, Class<?> clazz, Result<Boolean, Object> result) {
        int length = Array.getLength(value);
        Object array = Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, Array.get(value, i));
        }
        result.set(Boolean.TRUE, array);
    }

    private static final <T> void getCollectionValue(T value, Class<? extends Collection<?>> colClazz, Type genericType, Result<Boolean, Object> result) {
        if (genericType instanceof ParameterizedType) {
            Class paramClazz = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
            BeanHelper.getCollectionValue(value, colClazz, paramClazz, result);
        }
    }

    private static final <T> void getCollectionValue(T value, Class<? extends Collection<?>> clazz, Class<?> paramClazz, Result<Boolean, Object> result) {
        Class<?> valueType = value.getClass();
        Class<?> valueComType = valueType.getComponentType();
        if (BeanHelper.isSimpleType(paramClazz) && (valueType.equals(String.class) || valueType.isArray() && valueComType.equals(String.class))) {
            Collection<?> col = BeanHelper.parseCollectionParameter(clazz, paramClazz, value);
            result.set(Boolean.TRUE, col);
        }
    }

    private static final <T> void getSimpleValue(T value, Class<?> clazz, Result<Boolean, Object> result) {
        Class<?> valueType = value.getClass();
        Class<?> valueComType = valueType.getComponentType();
        Class<?> clazzComType = clazz.getComponentType();
        if ((valueType.equals(String.class) || valueType.isArray() && valueComType.equals(String.class)) && (BeanHelper.isSimpleType(clazz) || clazz.isArray() && BeanHelper.isSimpleType(clazzComType))) {
            Object param = BeanHelper.parseParameter(clazz, value);
            result.set(Boolean.TRUE, param);
        }
    }

    private static final <T> Collection<?> parseCollectionParameter(Class<? extends Collection<?>> clazz, Class<?> paramClazz, T obj) {
        Collection<Object> col = BeanHelper.getRealCollectionClass(clazz);
        if (col != null) {
            Class<?> valueType = obj.getClass();
            String[] value = null;
            if (valueType.isArray()) {
                value = (String[])obj;
            } else {
                String str = (String)obj;
                StringTokenizer st = new StringTokenizer(str, STRING_DELIMITERS);
                value = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    value[i] = st.nextToken();
                    ++i;
                }
            }
            for (int i = 0; i < value.length; ++i) {
                String v = value[i];
                Object p = GeneralHelper.str2Object(paramClazz, v);
                col.add(p);
            }
        }
        return col;
    }

    private static final Collection<Object> getRealCollectionClass(Class<? extends Collection<?>> clazz) {
        Collection<Object> col = null;
        Class<Collection<Object>> realClazz = null;
        if (BeanHelper.isPublicNotAbstractClass(clazz)) {
            realClazz = clazz;
        } else if (Set.class.isAssignableFrom(clazz)) {
            realClazz = HashSet.class;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            realClazz = ArrayList.class;
        }
        if (realClazz != null) {
            try {
                col = realClazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return col;
    }

    public static final <T> T invokeMethod(Object bean, Method method2, Object ... param) {
        try {
            method2.setAccessible(true);
            return (T)method2.invoke(bean, param);
        }
        catch (Exception e) {
            Exception cause;
            if (e instanceof InvocationTargetException && (cause = (Exception)e.getCause()) != null) {
                e = cause;
            }
            throw new RuntimeException(e);
        }
    }

    public static final <T> Result<Boolean, T> tryInvokeMethod(Object bean, Method method2, Object ... param) {
        Result<Boolean, T> result = Result.initialBoolean();
        try {
            T value = BeanHelper.invokeMethod(bean, method2, param);
            result.set(Boolean.TRUE, value);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static final <T> T invokeGetFieldValue(Object bean, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(bean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final <T> Result<Boolean, T> tryInvokeGetFieldValue(Object bean, Field field) {
        Result<Boolean, T> result = Result.initialBoolean();
        try {
            T value = BeanHelper.invokeGetFieldValue(bean, field);
            result.set(Boolean.TRUE, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static final void invokeSetFieldValue(Object bean, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final boolean tryInvokeSetFieldValue(Object bean, Field field, Object value) {
        boolean isOK = true;
        try {
            BeanHelper.invokeSetFieldValue(bean, field, value);
        }
        catch (Exception e) {
            isOK = false;
        }
        return isOK;
    }

    private static final <T> Object parseParameter(Class<?> clazz, T obj) {
        Object param = null;
        Class<?> valueType = obj.getClass();
        if (clazz.isArray()) {
            int i;
            String[] value = null;
            if (valueType.isArray()) {
                value = (String[])obj;
            } else {
                String str = (String)obj;
                StringTokenizer st = new StringTokenizer(str, STRING_DELIMITERS);
                value = new String[st.countTokens()];
                i = 0;
                while (st.hasMoreTokens()) {
                    value[i] = st.nextToken();
                    ++i;
                }
            }
            int length = value.length;
            Class<?> type = clazz.getComponentType();
            param = Array.newInstance(type, length);
            for (i = 0; i < length; ++i) {
                String v = value[i];
                Object p = GeneralHelper.str2Object(type, v);
                Array.set(param, i, p);
            }
        } else {
            String value = null;
            if (valueType.isArray()) {
                String[] array = (String[])obj;
                if (array.length > 0) {
                    value = array[0];
                }
            } else {
                value = (String)obj;
            }
            param = GeneralHelper.str2Object(clazz, value);
        }
        return param;
    }

    public static final Map<String, PropertyDescriptor> getPropDescMap(Class<?> startClass) {
        return BeanHelper.getPropDescMap(startClass, Object.class);
    }

    public static final Map<String, PropertyDescriptor> getPropDescMap(Class<?> startClass, Class<?> stopClass) {
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(startClass, stopClass);
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                map.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static final Map<String, Object> getProperties(Object bean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, PropertyDescriptor> pps = BeanHelper.getPropDescMap(bean.getClass());
        Set<Map.Entry<String, PropertyDescriptor>> set = pps.entrySet();
        for (Map.Entry<String, PropertyDescriptor> o : set) {
            String key = o.getKey();
            PropertyDescriptor pd = o.getValue();
            Method method2 = BeanHelper.getPropertyReadMethod(pd);
            if (method2 == null) continue;
            Object obj = BeanHelper.invokeMethod(bean, method2, new Object[0]);
            result.put(key, obj);
        }
        return result;
    }

    public static final PropertyDescriptor getPropDescByName(Class<?> startClass, String name) {
        return BeanHelper.getPropDescByName(startClass, Object.class, name);
    }

    public static final PropertyDescriptor getPropDescByName(Class<?> startClass, Class<?> stopClass, String name) {
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(startClass, stopClass);
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                return pd;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static final Method getPropertyReadMethod(Class<?> startClass, String property) {
        return BeanHelper.getPropertyReadMethod(startClass, null, property);
    }

    public static final Method getPropertyReadMethod(Class<?> startClass, Class<?> stopClass, String property) {
        PropertyDescriptor pd = BeanHelper.getPropDescByName(startClass, stopClass, property);
        return BeanHelper.getPropertyReadMethod(pd);
    }

    public static final Method getPropertyReadMethod(PropertyDescriptor pd) {
        return BeanHelper.getPropertyMethod(pd, true);
    }

    public static final Method getPropertyWriteMethod(Class<?> startClass, String property) {
        return BeanHelper.getPropertyWriteMethod(startClass, null, property);
    }

    public static final Method getPropertyWriteMethod(Class<?> startClass, Class<?> stopClass, String property) {
        PropertyDescriptor pd = BeanHelper.getPropDescByName(startClass, stopClass, property);
        return BeanHelper.getPropertyWriteMethod(pd);
    }

    public static final Method getPropertyWriteMethod(PropertyDescriptor pd) {
        return BeanHelper.getPropertyMethod(pd, false);
    }

    public static final Method getPropertyMethod(PropertyDescriptor pd, boolean readOrWrite) {
        if (pd != null) {
            Method method2;
            Method method3 = method2 = readOrWrite ? pd.getReadMethod() : pd.getWriteMethod();
            if (method2 != null && BeanHelper.isPublicInstanceMethod(method2)) {
                return method2;
            }
        }
        return null;
    }

    public static final <T> boolean setProperty(Object bean, String name, T value) {
        PropertyDescriptor pd = BeanHelper.getPropDescByName(bean.getClass(), name);
        return BeanHelper.setProperty(bean, pd, value);
    }

    public static final <T> Result<Boolean, T> getProperty(Object bean, String name) {
        PropertyDescriptor pd = BeanHelper.getPropDescByName(bean.getClass(), name);
        return BeanHelper.getProperty(bean, pd);
    }

    public static final <T> Result<Boolean, T> getProperty(Object bean, PropertyDescriptor pd) {
        Result<Boolean, T> result = Result.initialBoolean();
        Method method2 = BeanHelper.getPropertyReadMethod(pd);
        if (method2 != null) {
            T value = BeanHelper.invokeMethod(bean, method2, new Object[0]);
            result.set(Boolean.TRUE, value);
        }
        return result;
    }

    public static <T> boolean setFieldValue(Object bean, String name, T value) {
        Field field = BeanHelper.getInstanceFiledByName(bean.getClass(), name);
        return BeanHelper.setFieldValue(bean, field, value);
    }

    public static final <T> Result<Boolean, T> getFieldValue(Object bean, String name) {
        Field field = BeanHelper.getInstanceFiledByName(bean.getClass(), name);
        return BeanHelper.getFieldValue(bean, field);
    }

    public static final <T> Result<Boolean, T> getFieldValue(Object bean, Field field) {
        Result<Boolean, T> result = Result.initialBoolean();
        if (field != null && BeanHelper.isInstanceField(field)) {
            T value = BeanHelper.invokeGetFieldValue(bean, field);
            result.set(Boolean.TRUE, value);
        }
        return result;
    }

    public static final <T> boolean setPropertyOrFieldValue(Object bean, String name, T value) {
        return BeanHelper.setProperty(bean, name, value) || BeanHelper.setFieldValue(bean, name, value);
    }

    public static final <T> Result<Boolean, T> getPropertyOrFieldValue(Object bean, String name) {
        Result<Boolean, T> result = BeanHelper.getProperty(bean, name);
        if (!result.getFlag().booleanValue()) {
            result = BeanHelper.getFieldValue(bean, name);
        }
        return result;
    }

    public static final Set<Field> getAllFields(Class<?> clazz) {
        return BeanHelper.getAllFields(clazz, null);
    }

    public static final Set<Field> getAllFields(Class<?> clazz, Class<?> stopClazz) {
        HashSet<Field> fields = new HashSet<Field>();
        while (clazz != null && clazz != stopClazz) {
            Field[] fs = clazz.getDeclaredFields();
            Collections.addAll(fields, fs);
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static final Set<Field> getInstanceFields(Class<?> clazz) {
        return BeanHelper.getInstanceFields(clazz, null);
    }

    public static final Set<Field> getInstanceFields(Class<?> clazz, Class<?> stopClazz) {
        HashSet<Field> fields = new HashSet<Field>();
        while (clazz != null && clazz != stopClazz) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                if (!BeanHelper.isInstanceField(f)) continue;
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static final Map<String, Field> getInstanceFieldMap(Class<?> clazz) {
        return BeanHelper.getInstanceFieldMap(clazz, null);
    }

    public static final Map<String, Field> getInstanceFieldMap(Class<?> clazz, Class<?> stopClazz) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        while (clazz != null && clazz != stopClazz) {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                String name = f.getName();
                if (!BeanHelper.isInstanceField(f) || map.containsKey(name)) continue;
                map.put(name, f);
            }
            clazz = clazz.getSuperclass();
        }
        return map;
    }

    public static final Map<String, Object> getFieldValues(Object bean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Field> fms = BeanHelper.getInstanceFieldMap(bean.getClass());
        Set<Map.Entry<String, Field>> set = fms.entrySet();
        for (Map.Entry<String, Field> o : set) {
            String key = o.getKey();
            Field field = o.getValue();
            if (field == null || !BeanHelper.isInstanceField(field)) continue;
            Object obj = BeanHelper.invokeGetFieldValue(bean, field);
            result.put(key, obj);
        }
        return result;
    }

    public static final Field getFiledByName(Class<?> clazz, String name) {
        return BeanHelper.getFiledByName(clazz, null, name);
    }

    public static final Field getFiledByName(Class<?> clazz, Class<?> stopClazz, String name) {
        Field f = null;
        do {
            try {
                f = clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        } while (f == null && clazz != null && clazz != stopClazz);
        return f;
    }

    public static final Field getInstanceFiledByName(Class<?> clazz, String name) {
        return BeanHelper.getInstanceFiledByName(clazz, null, name);
    }

    public static final Field getInstanceFiledByName(Class<?> clazz, Class<?> stopClazz, String name) {
        Field f = null;
        do {
            try {
                Field f2 = clazz.getDeclaredField(name);
                if (BeanHelper.isInstanceField(f2)) {
                    f = f2;
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        } while (clazz != null && clazz != stopClazz);
        return f;
    }

    public static final Set<Method> getAllMethods(Class<?> clazz) {
        return BeanHelper.getAllMethods(clazz, null);
    }

    public static final Set<Method> getAllMethods(Class<?> clazz, Class<?> stopClazz) {
        HashSet<Method> methods = new HashSet<Method>();
        while (clazz != null && clazz != stopClazz) {
            Method[] m = clazz.getDeclaredMethods();
            Collections.addAll(methods, m);
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    public static final Method getMethodByName(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return BeanHelper.getMethodByName(clazz, null, name, parameterTypes);
    }

    public static final Method getMethodByName(Class<?> clazz, Class<?> stopClazz, String name, Class<?> ... parameterTypes) {
        Method m = null;
        do {
            try {
                m = clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        } while (m == null && clazz != null && clazz != stopClazz);
        return m;
    }

    public static final Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Method m = null;
        try {
            m = clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return m;
    }

    static {
        SMIPLE_CLASS_SET.add(Integer.TYPE);
        SMIPLE_CLASS_SET.add(Long.TYPE);
        SMIPLE_CLASS_SET.add(Float.TYPE);
        SMIPLE_CLASS_SET.add(Double.TYPE);
        SMIPLE_CLASS_SET.add(Byte.TYPE);
        SMIPLE_CLASS_SET.add(Character.TYPE);
        SMIPLE_CLASS_SET.add(Short.TYPE);
        SMIPLE_CLASS_SET.add(Boolean.TYPE);
        SMIPLE_CLASS_SET.add(Integer.class);
        SMIPLE_CLASS_SET.add(Long.class);
        SMIPLE_CLASS_SET.add(Float.class);
        SMIPLE_CLASS_SET.add(Double.class);
        SMIPLE_CLASS_SET.add(Byte.class);
        SMIPLE_CLASS_SET.add(Character.class);
        SMIPLE_CLASS_SET.add(Short.class);
        SMIPLE_CLASS_SET.add(Boolean.class);
        SMIPLE_CLASS_SET.add(String.class);
        SMIPLE_CLASS_SET.add(Date.class);
        WRAPPER_CLASS_SET.add(Integer.class);
        WRAPPER_CLASS_SET.add(Long.class);
        WRAPPER_CLASS_SET.add(Float.class);
        WRAPPER_CLASS_SET.add(Double.class);
        WRAPPER_CLASS_SET.add(Byte.class);
        WRAPPER_CLASS_SET.add(Character.class);
        WRAPPER_CLASS_SET.add(Short.class);
        WRAPPER_CLASS_SET.add(Boolean.class);
    }
}

