/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.utils;

import com.chinaunicom.number.bo.JumpBO;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JumpUtils {
    public static Map<String, JumpBO> jumpMap = new HashMap<String, JumpBO>();
    private static Properties propertyConfigurer;
    private static final ObjectMapper mapper;

    public void setPropertyConfigurer(Properties propertyConfigurer) {
        JumpUtils.propertyConfigurer = propertyConfigurer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws JsonParseException, JsonMappingException, IOException {
        BufferedReader reader = null;
        String laststr = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(JumpUtils.class.getClassLoader().getResource("init.json").getFile());
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr = laststr + tempString;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        StringBuilder argBuffer = new StringBuilder();
        JumpUtils.jsonFormat(mapper.readTree(laststr), argBuffer, 0, false);
        List object = (List)mapper.readValue(argBuffer.toString(), List.class);
        List lst = (List)mapper.readValue(mapper.writeValueAsString((Object)object), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, JumpBO.class));
        for (JumpBO jumpBO : lst) {
            String serviceVersion = propertyConfigurer.getProperty(jumpBO.getServiceVersion(), null);
            String groupName = propertyConfigurer.getProperty(jumpBO.getGroupName(), null);
            jumpBO.setGroupName(groupName);
            jumpBO.setServiceVersion(serviceVersion);
            jumpMap.put(jumpBO.getService(), jumpBO);
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    private static void jsonFormat(JsonNode node, StringBuilder json, int deep, boolean underScore) {
        JsonNodeType nt = node.getNodeType();
        if (nt == JsonNodeType.ARRAY) {
            ArrayNode an = (ArrayNode)node;
            json.append("[");
            Iterator elements = an.elements();
            ++deep;
            while (elements.hasNext()) {
                JumpUtils.jsonFormat((JsonNode)elements.next(), json, deep, underScore);
                if (!elements.hasNext()) continue;
                json.append(",");
            }
            --deep;
            json.append("]");
        } else if (nt == JsonNodeType.OBJECT) {
            ObjectNode on = (ObjectNode)node;
            Iterator fields = on.fields();
            json.append("{");
            ++deep;
            while (fields.hasNext()) {
                json.append("\n");
                for (int i = 0; i < deep; ++i) {
                    json.append("        ");
                }
                Map.Entry field = (Map.Entry)fields.next();
                json.append("\"").append(underScore ? JumpUtils.underscoreName((String)field.getKey()) : JumpUtils.camelCaseName((String)field.getKey())).append("\":");
                JumpUtils.jsonFormat((JsonNode)field.getValue(), json, deep, underScore);
                if (!fields.hasNext()) continue;
                json.append(",");
            }
            --deep;
            json.append("\n");
            for (int i = 0; i < deep; ++i) {
                json.append("        ");
            }
            json.append("}");
        } else if (nt == JsonNodeType.STRING) {
            json.append("\"").append(node.asText()).append("\"");
        } else if (nt == JsonNodeType.NULL) {
            json.append(node.asText());
        } else if (nt == JsonNodeType.BOOLEAN) {
            json.append(node.asText());
        } else if (nt == JsonNodeType.NUMBER) {
            json.append(node.asText());
        }
    }

    public static String camelCaseName(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); ++i) {
                char ch = underscoreName.charAt(i);
                if ("_".charAt(0) == ch) {
                    flag = true;
                    continue;
                }
                if (flag) {
                    result.append(Character.toUpperCase(ch));
                    flag = false;
                    continue;
                }
                result.append(Character.toLowerCase(ch));
            }
        }
        return result.toString();
    }

    public static String underscoreName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        int len = camelCaseName.length();
        if (camelCaseName != null && len > 0) {
            result.append(camelCaseName.substring(0, 1).toUpperCase());
            for (int i = 1; i < len; ++i) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(ch);
                    continue;
                }
                result.append(Character.toUpperCase(ch));
            }
        }
        return result.toString();
    }

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        JumpUtils.init();
    }

    static {
        mapper = new ObjectMapper();
    }
}

