/*
 * Decompiled with CFR 0.152.
 */
package com.chinaunicom.number.utils;

import java.util.Date;

public class Result<F, V> {
    private F flag;
    private V value;

    public static final <V> Result<Boolean, V> initialBoolean() {
        return new Result<Boolean, V>(Boolean.FALSE);
    }

    public static final <V> Result<Byte, V> initialByte() {
        return new Result<Integer, V>(0);
    }

    public static final <V> Result<Character, V> initialChar() {
        return new Result<Integer, V>(0);
    }

    public static final <V> Result<Short, V> initialShort() {
        return new Result<Integer, V>(0);
    }

    public static final <V> Result<Integer, V> initialInt() {
        return new Result<Integer, V>(0);
    }

    public static final <V> Result<Long, V> initialLong() {
        return new Result<Long, V>(0L);
    }

    public static final <V> Result<Float, V> initialFloat() {
        return new Result<Float, V>(Float.valueOf(Float.NaN));
    }

    public static final <V> Result<Double, V> initialDouble() {
        return new Result<Double, V>(Double.NaN);
    }

    public static final <V> Result<String, V> initialString() {
        return new Result<String, V>("");
    }

    public static final <V> Result<Date, V> initialDate() {
        return new Result<Date, V>(new Date(0L));
    }

    public Result() {
    }

    public Result(F flag) {
        this.set(flag, null);
    }

    public Result(F flag, V value) {
        this.set(flag, value);
    }

    public Result(Result<F, V> other) {
        this.set(other.flag, other.value);
    }

    public F getFlag() {
        return this.flag;
    }

    public void setFlag(F flag) {
        this.flag = flag;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void set(F flag, V value) {
        this.flag = flag;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Result) {
            Result other = (Result)obj;
            if (this.flag == other.flag && this.value == other.value) {
                return true;
            }
            if (this.flag != null && !this.flag.equals(other.flag)) {
                return false;
            }
            if (this.flag == null && other.flag != null) {
                return false;
            }
            if (this.value != null && !this.value.equals(other.value)) {
                return false;
            }
            return this.value != null || other.value == null;
        }
        return false;
    }

    public int hashCode() {
        return (this.flag != null ? this.flag.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
    }

    public String toString() {
        return String.format("{%s, %s}", this.flag, this.value);
    }
}

