/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.api;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.script.ScriptJob;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.event.JobEventBus;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.exception.JobConfigurationException;
import com.dangdang.ddframe.job.exception.JobSystemException;
import com.dangdang.ddframe.job.executor.JobExecutorFactory;
import com.dangdang.ddframe.job.executor.JobFacade;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.executor.JobExecutor;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.lite.internal.schedule.LiteJobFacade;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Properties;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.plugins.management.ShutdownHookPlugin;
import org.quartz.simpl.SimpleThreadPool;

public class JobScheduler {
    public static final String ELASTIC_JOB_DATA_MAP_KEY = "elasticJob";
    private static final String JOB_FACADE_DATA_MAP_KEY = "jobFacade";
    private final String jobName;
    private final JobExecutor jobExecutor;
    private final JobFacade jobFacade;
    private final JobRegistry jobRegistry;

    public JobScheduler(CoordinatorRegistryCenter regCenter, LiteJobConfiguration liteJobConfig, ElasticJobListener ... elasticJobListeners) {
        this(regCenter, liteJobConfig, new JobEventBus(), elasticJobListeners);
    }

    public JobScheduler(CoordinatorRegistryCenter regCenter, LiteJobConfiguration liteJobConfig, JobEventConfiguration jobEventConfig, ElasticJobListener ... elasticJobListeners) {
        this(regCenter, liteJobConfig, new JobEventBus(jobEventConfig), elasticJobListeners);
    }

    private JobScheduler(CoordinatorRegistryCenter regCenter, LiteJobConfiguration liteJobConfig, JobEventBus jobEventBus, ElasticJobListener ... elasticJobListeners) {
        this.jobName = liteJobConfig.getJobName();
        this.jobExecutor = new JobExecutor(regCenter, liteJobConfig, elasticJobListeners);
        this.jobFacade = new LiteJobFacade(regCenter, this.jobName, Arrays.asList(elasticJobListeners), jobEventBus);
        this.jobRegistry = JobRegistry.getInstance();
    }

    public void init() {
        this.jobExecutor.init();
        JobTypeConfiguration jobTypeConfig = this.jobExecutor.getSchedulerFacade().loadJobConfiguration().getTypeConfig();
        JobScheduleController jobScheduleController = new JobScheduleController(this.createScheduler(jobTypeConfig.getCoreConfig().isMisfire()), this.createJobDetail(jobTypeConfig.getJobClass()), this.jobExecutor.getSchedulerFacade(), this.jobName);
        jobScheduleController.scheduleJob(jobTypeConfig.getCoreConfig().getCron());
        this.jobRegistry.addJobScheduleController(this.jobName, jobScheduleController);
    }

    private JobDetail createJobDetail(String jobClass) {
        JobDetail result = JobBuilder.newJob(LiteJob.class).withIdentity(this.jobName).build();
        result.getJobDataMap().put(JOB_FACADE_DATA_MAP_KEY, (Object)this.jobFacade);
        Optional<ElasticJob> elasticJobInstance = this.createElasticJobInstance();
        if (elasticJobInstance.isPresent()) {
            result.getJobDataMap().put(ELASTIC_JOB_DATA_MAP_KEY, elasticJobInstance.get());
        } else if (!jobClass.equals(ScriptJob.class.getCanonicalName())) {
            try {
                result.getJobDataMap().put(ELASTIC_JOB_DATA_MAP_KEY, Class.forName(jobClass).newInstance());
            }
            catch (ReflectiveOperationException ex) {
                throw new JobConfigurationException("Elastic-Job: Job class '%s' can not initialize.", new Object[]{jobClass});
            }
        }
        return result;
    }

    protected Optional<ElasticJob> createElasticJobInstance() {
        return Optional.absent();
    }

    private Scheduler createScheduler(boolean isMisfire) {
        Scheduler result;
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            factory.initialize(this.getBaseQuartzProperties(isMisfire));
            result = factory.getScheduler();
            result.getListenerManager().addTriggerListener((TriggerListener)this.jobExecutor.getSchedulerFacade().newJobTriggerListener());
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
        return result;
    }

    private Properties getBaseQuartzProperties(boolean isMisfire) {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", this.jobName);
        if (!isMisfire) {
            result.put("org.quartz.jobStore.misfireThreshold", "1");
        }
        result.put("org.quartz.plugin.shutdownhook.class", ShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        return result;
    }

    public void shutdown() {
        this.jobRegistry.getJobScheduleController(this.jobName).shutdown();
    }

    public static final class LiteJob
    implements Job {
        private ElasticJob elasticJob;
        private JobFacade jobFacade;

        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobExecutorFactory.getJobExecutor((ElasticJob)this.elasticJob, (JobFacade)this.jobFacade).execute();
        }

        public void setElasticJob(ElasticJob elasticJob) {
            this.elasticJob = elasticJob;
        }

        public void setJobFacade(JobFacade jobFacade) {
            this.jobFacade = jobFacade;
        }
    }
}

