/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.config;

import com.dangdang.ddframe.job.config.JobRootConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;

public class LiteJobConfiguration
implements JobRootConfiguration {
    private final JobTypeConfiguration typeConfig;
    private final boolean monitorExecution;
    private final int maxTimeDiffSeconds;
    private final int monitorPort;
    private final String jobShardingStrategyClass;
    private final boolean disabled;
    private final boolean overwrite;
    private final int reconcileIntervalMinutes;

    public String getJobName() {
        return this.typeConfig.getCoreConfig().getJobName();
    }

    public boolean isFailover() {
        return this.monitorExecution && this.typeConfig.getCoreConfig().isFailover();
    }

    public static Builder newBuilder(JobTypeConfiguration jobConfig) {
        return new Builder(jobConfig);
    }

    public JobTypeConfiguration getTypeConfig() {
        return this.typeConfig;
    }

    public boolean isMonitorExecution() {
        return this.monitorExecution;
    }

    public int getMaxTimeDiffSeconds() {
        return this.maxTimeDiffSeconds;
    }

    public int getMonitorPort() {
        return this.monitorPort;
    }

    public String getJobShardingStrategyClass() {
        return this.jobShardingStrategyClass;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public int getReconcileIntervalMinutes() {
        return this.reconcileIntervalMinutes;
    }

    private LiteJobConfiguration(JobTypeConfiguration typeConfig, boolean monitorExecution, int maxTimeDiffSeconds, int monitorPort, String jobShardingStrategyClass, boolean disabled, boolean overwrite, int reconcileIntervalMinutes) {
        this.typeConfig = typeConfig;
        this.monitorExecution = monitorExecution;
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
        this.monitorPort = monitorPort;
        this.jobShardingStrategyClass = jobShardingStrategyClass;
        this.disabled = disabled;
        this.overwrite = overwrite;
        this.reconcileIntervalMinutes = reconcileIntervalMinutes;
    }

    public static class Builder {
        private final JobTypeConfiguration jobConfig;
        private boolean monitorExecution = true;
        private int maxTimeDiffSeconds = -1;
        private int monitorPort = -1;
        private String jobShardingStrategyClass = "";
        private boolean disabled;
        private boolean overwrite;
        private int reconcileIntervalMinutes = -1;

        public Builder monitorExecution(boolean monitorExecution) {
            this.monitorExecution = monitorExecution;
            return this;
        }

        public Builder maxTimeDiffSeconds(int maxTimeDiffSeconds) {
            this.maxTimeDiffSeconds = maxTimeDiffSeconds;
            return this;
        }

        public Builder monitorPort(int monitorPort) {
            this.monitorPort = monitorPort;
            return this;
        }

        public Builder jobShardingStrategyClass(String jobShardingStrategyClass) {
            if (null != jobShardingStrategyClass) {
                this.jobShardingStrategyClass = jobShardingStrategyClass;
            }
            return this;
        }

        public Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Builder reconcileIntervalMinutes(int reconcileIntervalMinutes) {
            this.reconcileIntervalMinutes = reconcileIntervalMinutes;
            return this;
        }

        public final LiteJobConfiguration build() {
            return new LiteJobConfiguration(this.jobConfig, this.monitorExecution, this.maxTimeDiffSeconds, this.monitorPort, this.jobShardingStrategyClass, this.disabled, this.overwrite, this.reconcileIntervalMinutes);
        }

        private Builder(JobTypeConfiguration jobConfig) {
            this.jobConfig = jobConfig;
        }
    }
}

