/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.config;

import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.util.json.AbstractJobConfigurationGsonTypeAdapter;
import com.dangdang.ddframe.job.util.json.GsonFactory;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class LiteJobConfigurationGsonFactory {
    public static String toJson(LiteJobConfiguration liteJobConfig) {
        return GsonFactory.getGson().toJson((Object)liteJobConfig);
    }

    public static String toJsonForObject(Object liteJobConfig) {
        return GsonFactory.getGson().toJson(liteJobConfig);
    }

    public static LiteJobConfiguration fromJson(String liteJobConfigJson) {
        return (LiteJobConfiguration)GsonFactory.getGson().fromJson(liteJobConfigJson, LiteJobConfiguration.class);
    }

    private LiteJobConfigurationGsonFactory() {
    }

    static {
        GsonFactory.registerTypeAdapter(LiteJobConfiguration.class, (TypeAdapter)new LiteJobConfigurationGsonTypeAdapter());
    }

    static final class LiteJobConfigurationGsonTypeAdapter
    extends AbstractJobConfigurationGsonTypeAdapter<LiteJobConfiguration> {
        LiteJobConfigurationGsonTypeAdapter() {
        }

        protected void addToCustomizedValueMap(String jsonName, JsonReader in, Map<String, Object> customizedValueMap) throws IOException {
            switch (jsonName) {
                case "monitorExecution": {
                    customizedValueMap.put("monitorExecution", in.nextBoolean());
                    break;
                }
                case "maxTimeDiffSeconds": {
                    customizedValueMap.put("maxTimeDiffSeconds", in.nextInt());
                    break;
                }
                case "monitorPort": {
                    customizedValueMap.put("monitorPort", in.nextInt());
                    break;
                }
                case "jobShardingStrategyClass": {
                    customizedValueMap.put("jobShardingStrategyClass", in.nextString());
                    break;
                }
                case "disabled": {
                    customizedValueMap.put("disabled", in.nextBoolean());
                    break;
                }
                case "overwrite": {
                    customizedValueMap.put("overwrite", in.nextBoolean());
                    break;
                }
                case "reconcileIntervalMinutes": {
                    customizedValueMap.put("reconcileIntervalMinutes", in.nextInt());
                    break;
                }
                default: {
                    in.skipValue();
                }
            }
        }

        protected LiteJobConfiguration getJobRootConfiguration(JobTypeConfiguration typeConfig, Map<String, Object> customizedValueMap) {
            LiteJobConfiguration.Builder builder = LiteJobConfiguration.newBuilder(typeConfig);
            if (customizedValueMap.containsKey("monitorExecution")) {
                builder.monitorExecution((Boolean)customizedValueMap.get("monitorExecution"));
            }
            if (customizedValueMap.containsKey("maxTimeDiffSeconds")) {
                builder.maxTimeDiffSeconds((Integer)customizedValueMap.get("maxTimeDiffSeconds"));
            }
            if (customizedValueMap.containsKey("monitorPort")) {
                builder.monitorPort((Integer)customizedValueMap.get("monitorPort"));
            }
            if (customizedValueMap.containsKey("jobShardingStrategyClass")) {
                builder.jobShardingStrategyClass((String)customizedValueMap.get("jobShardingStrategyClass"));
            }
            if (customizedValueMap.containsKey("disabled")) {
                builder.disabled((Boolean)customizedValueMap.get("disabled"));
            }
            if (customizedValueMap.containsKey("overwrite")) {
                builder.overwrite((Boolean)customizedValueMap.get("overwrite"));
            }
            if (customizedValueMap.containsKey("reconcileIntervalMinutes")) {
                builder.reconcileIntervalMinutes((Integer)customizedValueMap.get("reconcileIntervalMinutes"));
            }
            return builder.build();
        }

        protected void writeCustomized(JsonWriter out, LiteJobConfiguration value) throws IOException {
            out.name("monitorExecution").value(value.isMonitorExecution());
            out.name("maxTimeDiffSeconds").value((long)value.getMaxTimeDiffSeconds());
            out.name("monitorPort").value((long)value.getMonitorPort());
            out.name("jobShardingStrategyClass").value(value.getJobShardingStrategyClass());
            out.name("disabled").value(value.isDisabled());
            out.name("overwrite").value(value.isOverwrite());
            out.name("reconcileIntervalMinutes").value((long)value.getReconcileIntervalMinutes());
        }
    }
}

