/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.executor;

import com.dangdang.ddframe.job.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.guarantee.GuaranteeService;
import com.dangdang.ddframe.job.lite.internal.schedule.SchedulerFacade;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(JobExecutor.class);
    private final LiteJobConfiguration liteJobConfig;
    private final CoordinatorRegistryCenter regCenter;
    private final SchedulerFacade schedulerFacade;

    public JobExecutor(CoordinatorRegistryCenter regCenter, LiteJobConfiguration liteJobConfig, ElasticJobListener ... elasticJobListeners) {
        this.liteJobConfig = liteJobConfig;
        this.regCenter = regCenter;
        List<ElasticJobListener> elasticJobListenerList = Arrays.asList(elasticJobListeners);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, elasticJobListenerList);
        this.schedulerFacade = new SchedulerFacade(regCenter, liteJobConfig.getJobName(), elasticJobListenerList);
    }

    private void setGuaranteeServiceForElasticJobListeners(CoordinatorRegistryCenter regCenter, List<ElasticJobListener> elasticJobListeners) {
        GuaranteeService guaranteeService = new GuaranteeService(regCenter, this.liteJobConfig.getJobName());
        for (ElasticJobListener each : elasticJobListeners) {
            if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
            ((AbstractDistributeOnceElasticJobListener)each).setGuaranteeService(guaranteeService);
        }
    }

    public void init() {
        log.debug("Job '{}' controller init.", (Object)this.liteJobConfig.getJobName());
        this.schedulerFacade.clearPreviousServerStatus();
        this.regCenter.addCacheData("/" + this.liteJobConfig.getJobName());
        this.schedulerFacade.registerStartUpInfo(this.liteJobConfig);
    }

    public SchedulerFacade getSchedulerFacade() {
        return this.schedulerFacade;
    }
}

