/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.schedule;

import com.dangdang.ddframe.job.config.dataflow.DataflowJobConfiguration;
import com.dangdang.ddframe.job.context.TaskContext;
import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.event.JobEventBus;
import com.dangdang.ddframe.job.event.type.JobExecutionEvent;
import com.dangdang.ddframe.job.event.type.JobStatusTraceEvent;
import com.dangdang.ddframe.job.exception.JobExecutionEnvironmentException;
import com.dangdang.ddframe.job.executor.JobFacade;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionContextService;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverService;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteJobFacade
implements JobFacade {
    private static final Logger log = LoggerFactory.getLogger(LiteJobFacade.class);
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final ServerService serverService;
    private final ExecutionContextService executionContextService;
    private final ExecutionService executionService;
    private final FailoverService failoverService;
    private final List<ElasticJobListener> elasticJobListeners;
    private final JobEventBus jobEventBus;

    public LiteJobFacade(CoordinatorRegistryCenter regCenter, String jobName, List<ElasticJobListener> elasticJobListeners, JobEventBus jobEventBus) {
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.executionContextService = new ExecutionContextService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.elasticJobListeners = elasticJobListeners;
        this.jobEventBus = jobEventBus;
    }

    public LiteJobConfiguration loadJobRootConfiguration(boolean fromCache) {
        return this.configService.load(fromCache);
    }

    public void checkJobExecutionEnvironment() throws JobExecutionEnvironmentException {
        this.configService.checkMaxTimeDiffSecondsTolerable();
    }

    public void failoverIfNecessary() {
        if (this.configService.load(true).isFailover() && !this.serverService.isJobPausedManually()) {
            this.failoverService.failoverIfNecessary();
        }
    }

    public void registerJobBegin(ShardingContexts shardingContexts) {
        this.executionService.registerJobBegin(shardingContexts);
    }

    public void registerJobCompleted(ShardingContexts shardingContexts) {
        this.executionService.registerJobCompleted(shardingContexts);
        if (this.configService.load(true).isFailover()) {
            this.failoverService.updateFailoverComplete(shardingContexts.getShardingItemParameters().keySet());
        }
    }

    public ShardingContexts getShardingContexts() {
        List<Integer> failoverShardingItems;
        boolean isFailover = this.configService.load(true).isFailover();
        if (isFailover && !(failoverShardingItems = this.failoverService.getLocalHostFailoverItems()).isEmpty()) {
            return this.executionContextService.getJobShardingContext(failoverShardingItems);
        }
        this.shardingService.shardingIfNecessary();
        List<Integer> shardingItems = this.shardingService.getLocalHostShardingItems();
        if (isFailover) {
            shardingItems.removeAll(this.failoverService.getLocalHostTakeOffItems());
        }
        return this.executionContextService.getJobShardingContext(shardingItems);
    }

    public boolean misfireIfNecessary(Collection<Integer> shardingItems) {
        return this.executionService.misfireIfNecessary(shardingItems);
    }

    public void clearMisfire(Collection<Integer> shardingItems) {
        this.executionService.clearMisfire(shardingItems);
    }

    public boolean isExecuteMisfired(Collection<Integer> shardingItems) {
        return this.isEligibleForJobRunning() && this.configService.load(true).getTypeConfig().getCoreConfig().isMisfire() && !this.executionService.getMisfiredJobItems(shardingItems).isEmpty();
    }

    public boolean isEligibleForJobRunning() {
        LiteJobConfiguration liteJobConfig = this.configService.load(true);
        if (liteJobConfig.getTypeConfig() instanceof DataflowJobConfiguration) {
            return !this.serverService.isJobPausedManually() && !this.shardingService.isNeedSharding() && ((DataflowJobConfiguration)liteJobConfig.getTypeConfig()).isStreamingProcess();
        }
        return !this.serverService.isJobPausedManually() && !this.shardingService.isNeedSharding();
    }

    public boolean isNeedSharding() {
        return this.shardingService.isNeedSharding();
    }

    public void cleanPreviousExecutionInfo() {
        this.executionService.cleanPreviousExecutionInfo();
    }

    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.beforeJobExecuted(shardingContexts);
        }
    }

    public void afterJobExecuted(ShardingContexts shardingContexts) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.afterJobExecuted(shardingContexts);
        }
    }

    public void postJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        this.jobEventBus.post((JobEvent)jobExecutionEvent);
    }

    public void postJobStatusTraceEvent(String taskId, JobStatusTraceEvent.State state, String message) {
        TaskContext taskContext = TaskContext.from((String)taskId);
        this.jobEventBus.post((JobEvent)new JobStatusTraceEvent(taskContext.getMetaInfo().getJobName(), taskContext.getId(), taskContext.getSlaveId(), JobStatusTraceEvent.Source.LITE_EXECUTOR, taskContext.getType(), taskContext.getMetaInfo().getShardingItems().toString(), state, message));
        if (!Strings.isNullOrEmpty((String)message)) {
            log.trace(message);
        }
    }
}

