/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.server;

import com.dangdang.ddframe.job.lite.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.lite.internal.server.ServerNode;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;

public class JobOperationListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ServerNode serverNode;
    private final ServerService serverService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;

    public JobOperationListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.serverNode = new ServerNode(jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addConnectionStateListener(new ConnectionLostListener());
        this.addDataListener(new JobTriggerStatusJobListener());
        this.addDataListener(new JobPausedStatusJobListener());
        this.addDataListener(new JobShutdownStatusJobListener());
    }

    class JobShutdownStatusJobListener
    extends AbstractJobListener {
        JobShutdownStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (!JobOperationListenerManager.this.serverNode.isLocalJobShutdownPath(path)) {
                return;
            }
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (null != jobScheduleController && TreeCacheEvent.Type.NODE_ADDED == event.getType()) {
                jobScheduleController.shutdown();
                JobOperationListenerManager.this.serverService.processServerShutdown();
            }
        }
    }

    class JobPausedStatusJobListener
    extends AbstractJobListener {
        JobPausedStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (!JobOperationListenerManager.this.serverNode.isLocalJobPausedPath(path)) {
                return;
            }
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (null == jobScheduleController) {
                return;
            }
            if (TreeCacheEvent.Type.NODE_ADDED == event.getType()) {
                jobScheduleController.pauseJob();
            }
            if (TreeCacheEvent.Type.NODE_REMOVED == event.getType()) {
                jobScheduleController.resumeJob();
                JobOperationListenerManager.this.serverService.clearJobPausedStatus();
            }
        }
    }

    class JobTriggerStatusJobListener
    extends AbstractJobListener {
        JobTriggerStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (TreeCacheEvent.Type.NODE_ADDED != event.getType() || !JobOperationListenerManager.this.serverNode.isLocalJobTriggerPath(path)) {
                return;
            }
            JobOperationListenerManager.this.serverService.clearJobTriggerStatus();
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (null == jobScheduleController) {
                return;
            }
            if (JobOperationListenerManager.this.serverService.isLocalhostServerReady()) {
                jobScheduleController.triggerJob();
            }
        }
    }

    class ConnectionLostListener
    implements ConnectionStateListener {
        ConnectionLostListener() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (ConnectionState.LOST == newState) {
                jobScheduleController.pauseJob();
            } else if (ConnectionState.RECONNECTED == newState) {
                JobOperationListenerManager.this.serverService.persistServerOnline(JobOperationListenerManager.this.serverService.isLocalhostServerEnabled());
                JobOperationListenerManager.this.executionService.clearRunningInfo(JobOperationListenerManager.this.shardingService.getLocalHostShardingItems());
                if (!JobOperationListenerManager.this.serverService.isJobPausedManually()) {
                    jobScheduleController.resumeJob();
                }
            }
        }
    }
}

