/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.server;

import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.util.env.LocalHostService;

public class ServerNode {
    public static final String ROOT = "servers";
    static final String HOST_NAME = "servers/%s/hostName";
    static final String STATUS_APPENDIX = "status";
    static final String STATUS = "servers/%s/status";
    static final String TRIGGER_APPENDIX = "trigger";
    static final String TRIGGER = "servers/%s/trigger";
    static final String DISABLED_APPENDIX = "disabled";
    static final String DISABLED = "servers/%s/disabled";
    static final String PAUSED = "servers/%s/paused";
    static final String SHUTDOWN_APPENDIX = "shutdown";
    static final String SHUTDOWN = "servers/%s/shutdown";
    private final LocalHostService localHostService = new LocalHostService();
    private final JobNodePath jobNodePath;

    public ServerNode(String jobName) {
        this.jobNodePath = new JobNodePath(jobName);
    }

    static String getHostNameNode(String ip) {
        return String.format(HOST_NAME, ip);
    }

    static String getStatusNode(String ip) {
        return String.format(STATUS, ip);
    }

    static String getTriggerNode(String ip) {
        return String.format(TRIGGER, ip);
    }

    static String getDisabledNode(String ip) {
        return String.format(DISABLED, ip);
    }

    static String getPausedNode(String ip) {
        return String.format(PAUSED, ip);
    }

    static String getShutdownNode(String ip) {
        return String.format(SHUTDOWN, ip);
    }

    public boolean isLocalJobTriggerPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(String.format(TRIGGER, this.localHostService.getIp())));
    }

    public boolean isLocalJobPausedPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(String.format(PAUSED, this.localHostService.getIp())));
    }

    public boolean isLocalJobShutdownPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(String.format(SHUTDOWN, this.localHostService.getIp())));
    }

    public boolean isLocalServerDisabledPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(String.format(DISABLED, this.localHostService.getIp())));
    }

    public boolean isServerStatusPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(STATUS_APPENDIX);
    }

    public boolean isServerDisabledPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(DISABLED_APPENDIX);
    }

    public boolean isServerShutdownPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(SHUTDOWN_APPENDIX);
    }
}

