/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.storage;

import java.beans.ConstructorProperties;

public final class JobNodePath {
    public static final String TRIGGER_NODE = "trigger";
    public static final String PAUSED_NODE = "paused";
    public static final String DISABLED_NODE = "disabled";
    public static final String SHUTDOWN_NODE = "shutdown";
    public static final String STATUS_NODE = "status";
    private static final String LEADER_HOST_NODE = "leader/election/host";
    private static final String CONFIG_NODE = "config";
    private static final String SERVERS_NODE = "servers";
    private static final String EXECUTION_NODE = "execution";
    private final String jobName;

    public String getFullPath(String node) {
        return String.format("/%s/%s", this.jobName, node);
    }

    public String getConfigNodePath() {
        return String.format("/%s/%s", this.jobName, CONFIG_NODE);
    }

    public String getLeaderHostNodePath() {
        return String.format("/%s/%s", this.jobName, LEADER_HOST_NODE);
    }

    public String getServerNodePath() {
        return String.format("/%s/%s", this.jobName, SERVERS_NODE);
    }

    public String getServerNodePath(String serverIp) {
        return String.format("%s/%s", this.getServerNodePath(), serverIp);
    }

    public String getServerNodePath(String serverIp, String nodeName) {
        return String.format("%s/%s", this.getServerNodePath(serverIp), nodeName);
    }

    public String getExecutionNodePath() {
        return String.format("/%s/%s", this.jobName, EXECUTION_NODE);
    }

    public String getExecutionNodePath(String item, String nodeName) {
        return String.format("%s/%s/%s", this.getExecutionNodePath(), item, nodeName);
    }

    @ConstructorProperties(value={"jobName"})
    public JobNodePath(String jobName) {
        this.jobName = jobName;
    }
}

