/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.tools.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byte2File(byte[] buf, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static final InputStream byte2Input(byte[] buf) {
        return new ByteArrayInputStream(buf);
    }

    public static final String InputStream2String(InputStream inputStream) throws IOException {
        byte[] bytes = FileUtils.input2byte(inputStream);
        return new String(bytes);
    }

    public static final byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    public static String getDateFmtFilePath() {
        String filePath = "";
        Calendar cal = Calendar.getInstance();
        int monthTemp = cal.get(2) + 1;
        String year = String.valueOf(cal.get(1));
        String month = String.valueOf(monthTemp > 9 ? Integer.valueOf(monthTemp) : "0" + monthTemp);
        String day = String.valueOf(cal.get(5) > 9 ? Integer.valueOf(cal.get(5)) : "0" + cal.get(5));
        filePath = "/" + year + "/" + month + "/" + day;
        return filePath;
    }

    public static String getExtension(String filename) {
        return FileUtils.getExtension(filename, "");
    }

    public static String getExtension(String filename, String defExt) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > -1 && i < filename.length() - 1) {
            return filename.substring(i + 1);
        }
        return defExt;
    }

    public static String getBaseName(String filename) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > -1 && i < filename.length() - 1) {
            return filename.substring(0, i);
        }
        return "";
    }
}

