/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.tools.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.StringTokenizer;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpTools {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private FTPClient ftpClient = null;
    private String ip;
    private String username;
    private String password;
    private int port;

    public FtpTools() {
    }

    public FtpTools(String ip, String username, String password, int port) {
        this.ip = ip;
        this.username = username;
        this.password = password;
        this.port = port;
    }

    public boolean loginFtp() {
        boolean flag = true;
        if (this.ftpClient == null) {
            this.ftpClient = new FTPClient();
            this.ftpClient.setControlEncoding("UTF-8");
        }
        try {
            this.ftpClient.connect(this.ip, this.port);
            this.ftpClient.login(this.username, this.password);
            if (!FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode())) {
                flag = false;
                this.logger.debug("\u672a\u8fde\u63a5\u5230FTP\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!!!");
                System.err.println("\u672a\u8fde\u63a5\u5230FTP\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!!!");
            } else {
                this.logger.debug("FTP\u8fde\u63a5\u6210\u529f!");
                System.err.println("FTP\u8fde\u63a5\u6210\u529f!");
            }
            this.ftpClient.setDataTimeout(120000);
        }
        catch (SocketException e) {
            flag = false;
            e.printStackTrace();
            System.err.println("\u767b\u5f55ftp\u670d\u52a1\u5668\u5931\u8d25,\u8fde\u63a5\u8d85\u65f6\uff01");
            this.logger.debug("\u767b\u5f55ftp\u670d\u52a1\u5668\u5931\u8d25");
        }
        catch (IOException e) {
            flag = false;
            e.printStackTrace();
            System.err.println("\u767b\u5f55ftp\u670d\u52a1\u5668\u5931\u8d25\uff0cFTP\u670d\u52a1\u5668\u65e0\u6cd5\u6253\u5f00\uff01");
            this.logger.debug("\u767b\u5f55ftp\u670d\u52a1\u5668\u5931\u8d25");
        }
        return flag;
    }

    public boolean logoutFtp() throws IOException {
        try {
            if (this.ftpClient != null) {
                this.ftpClient.logout();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient != null && this.ftpClient.isConnected()) {
                this.ftpClient.disconnect();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(InputStream inStream, String fileName, String path) throws Exception {
        boolean flag = false;
        try {
            this.loginFtp();
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileTransferMode(10);
            path = path.replace('\\', '/');
            this.createDir(path);
            this.changerToPath(path);
            flag = this.ftpClient.storeFile(fileName, inStream);
            this.logger.debug("\u6587\u4ef6:" + fileName + "\u4e0a\u4f20" + (flag ? "\u6210\u529f" : "\u5931\u8d25"));
            this.ftpClient.changeWorkingDirectory("~");
            inStream.close();
            this.ftpClient.logout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient.isConnected()) {
                this.ftpClient.disconnect();
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(File file, String path) throws Exception {
        boolean flag = true;
        try {
            this.loginFtp();
            if (file.exists()) {
                this.ftpClient.setFileType(2);
                this.ftpClient.enterLocalPassiveMode();
                this.ftpClient.setFileTransferMode(10);
                FileInputStream bis = new FileInputStream(file);
                path = path.replace('\\', '/');
                this.createDir(path);
                this.changerToPath(path);
                flag = this.ftpClient.storeFile(file.getName(), (InputStream)bis);
                this.ftpClient.changeWorkingDirectory("~");
                this.logger.debug("\u6587\u4ef6:" + file.getName() + "\u4e0a\u4f20" + (flag ? "\u6210\u529f" : "\u5931\u8d25"));
                bis.close();
            }
            this.ftpClient.logout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient.isConnected()) {
                this.ftpClient.disconnect();
            }
        }
        return flag;
    }

    private boolean changerToPath(String path) {
        boolean isOK = false;
        path = path.replace('\\', '/');
        StringTokenizer s = new StringTokenizer(path, "/");
        s.countTokens();
        String pathName = "";
        while (s.hasMoreElements()) {
            pathName = (String)s.nextElement();
            try {
                isOK = this.ftpClient.changeWorkingDirectory(pathName);
            }
            catch (Exception e2) {
                Object e2 = null;
                isOK = false;
            }
        }
        return isOK;
    }

    public static void main(String[] args) throws Exception {
        FtpTools packer = new FtpTools("10.10.20.204", "wen", "wen1", 21);
        File file = new File("E:/test.txt");
        FileInputStream in = new FileInputStream(file);
        packer.uploadFile(in, "test1.xml.bak", "/img/");
    }

    private void createDir(String dir) throws Exception {
        dir = dir.replace('\\', '/');
        StringTokenizer s = new StringTokenizer(dir, "/");
        s.countTokens();
        String pathName = "";
        while (s.hasMoreElements()) {
            pathName = (String)s.nextElement();
            try {
                this.ftpClient.makeDirectory(pathName);
                this.ftpClient.changeWorkingDirectory(pathName);
            }
            catch (Exception e2) {
                Object e2 = null;
            }
        }
        this.ftpClient.changeWorkingDirectory("~");
    }

    private boolean isDirExist(String dir) {
        boolean isDirExist = false;
        try {
            isDirExist = this.ftpClient.changeWorkingDirectory(dir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isDirExist;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

