/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.tools.ftp;

import com.dragon.tools.ftp.Num62;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class UploadUtils {
    public static final DateFormat MONTH_FORMAT = new SimpleDateFormat("/yyyyMM/ddHHmmss");
    public static final DateFormat YEAR_MONTH_FORMAT = new SimpleDateFormat("yyyyMM");
    public static final DateFormat YEAR_MONTH_DAY_FORMAT = new SimpleDateFormat("yy/MM/dd");
    public static final DateFormat SHORT_FORMAT = new SimpleDateFormat("ddHHmmss");
    protected static final Pattern ILLEGAL_CURRENT_FOLDER_PATTERN = Pattern.compile("^[^/]|[^/]$|/\\.{1,2}|\\\\|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}");

    public static String generateMonthname() {
        return YEAR_MONTH_FORMAT.format(new Date());
    }

    public static String generateFilename(String path, String ext) {
        return path + MONTH_FORMAT.format(new Date()) + RandomStringUtils.random((int)4, (char[])Num62.N36_CHARS) + "." + ext;
    }

    public static String generateInvoiceFileName(String path, String fileName, String ext) {
        return path + YEAR_MONTH_DAY_FORMAT.format(new Date()) + "/" + fileName + "." + ext;
    }

    public static String generateByFilename(String path, String fileName, String ext) {
        return path + fileName + "." + ext;
    }

    public static String sanitizeFileName(String filename) {
        if (StringUtils.isBlank((String)filename)) {
            return filename;
        }
        String name = UploadUtils.forceSingleExtension(filename);
        return name.replaceAll("\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static String sanitizeFolderName(String folderName) {
        if (StringUtils.isBlank((String)folderName)) {
            return folderName;
        }
        return folderName.replaceAll("\\.|\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static boolean isValidPath(String path) {
        if (StringUtils.isBlank((String)path)) {
            return false;
        }
        return !ILLEGAL_CURRENT_FOLDER_PATTERN.matcher(path).find();
    }

    public static String forceSingleExtension(String filename) {
        return filename.replaceAll("\\.(?![^.]+$)", "_");
    }

    public static boolean isSingleExtension(String filename) {
        return filename.matches("[^\\.]+\\.[^\\.]+");
    }

    public static void checkDirAndCreate(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static File getUniqueFile(File file) {
        if (!file.exists()) {
            return file;
        }
        File tmpFile = new File(file.getAbsolutePath());
        File parentDir = tmpFile.getParentFile();
        int count = 1;
        String extension = FilenameUtils.getExtension((String)tmpFile.getName());
        String baseName = FilenameUtils.getBaseName((String)tmpFile.getName());
        while ((tmpFile = new File(parentDir, baseName + "(" + count++ + ")." + extension)).exists()) {
        }
        return tmpFile;
    }

    public static String getExtension(String filename) {
        return UploadUtils.getExtension(filename, "");
    }

    public static String getExtension(String filename, String defExt) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > -1 && i < filename.length() - 1) {
            return filename.substring(i + 1);
        }
        return defExt;
    }

    public static void main(String[] args) {
        System.out.println(UploadUtils.generateFilename("/base", "gif"));
    }
}

