/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.tools.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebUtils {
    private static final String[] AGENT_INDEX = new String[]{"MSIE", "Firefox", "Chrome", "Opera", "Safari"};
    private static final Map<String, Pattern> AGENT_PATTERNS = new HashMap<String, Pattern>(AGENT_INDEX.length);

    public static HttpSession getSession(HttpServletRequest request) {
        return request.getSession();
    }

    public static String getBasePath(HttpServletRequest request) {
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        return basePath;
    }

    public static byte[] InputStreamToByte(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = is.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] imgdata = bytestream.toByteArray();
        bytestream.close();
        return imgdata;
    }

    public static InputStream ByteToInputStream(byte[] data) {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        return is;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ips = request.getHeader("x-forwarded-for");
        if (ips == null || ips.length() == 0 || "unknown".equalsIgnoreCase(ips)) {
            ips = request.getHeader("Proxy-Client-IP");
        }
        if (ips == null || ips.length() == 0 || "unknown".equalsIgnoreCase(ips)) {
            ips = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ips == null || ips.length() == 0 || "unknown".equalsIgnoreCase(ips)) {
            ips = request.getRemoteAddr();
        }
        String[] ipArray = ips.split(",");
        String clientIP = null;
        for (String ip : ipArray) {
            if ("unknown".equalsIgnoreCase(ip)) continue;
            clientIP = ip;
            break;
        }
        return clientIP;
    }

    public static Cookie findCookie(HttpServletRequest request, String name) {
        Cookie[] cookies;
        if (request != null && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String findCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = WebUtils.findCookie(request, name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge) {
        WebUtils.addCookie(request, response, name, value, null, maxAge);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String domain, int maxAge) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            contextPath = "/";
        }
        WebUtils.addCookie(request, response, name, value, domain, contextPath, maxAge);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String domain, String contextPath, int maxAge) {
        if (request != null && response != null) {
            Cookie cookie = new Cookie(name, value);
            cookie.setMaxAge(maxAge);
            cookie.setSecure(request.isSecure());
            if (contextPath == null || contextPath.isEmpty()) {
                cookie.setPath("/");
            } else {
                cookie.setPath(contextPath);
            }
            if (domain != null && !domain.isEmpty()) {
                cookie.setDomain(domain);
            }
            response.addCookie(cookie);
        }
    }

    public static void failureCookie(HttpServletRequest request, HttpServletResponse response, String name, String domain, String contextPath) {
        if (request != null && response != null) {
            WebUtils.addCookie(request, response, name, null, domain, contextPath, 0);
        }
    }

    public static void failureCookie(HttpServletRequest request, HttpServletResponse response, String name, String domain) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            contextPath = "/";
        }
        WebUtils.failureCookie(request, response, name, domain, contextPath);
    }

    public static void failureCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        WebUtils.failureCookie(request, response, name, null);
    }

    public static String completeTheRequestAddress(HttpServletRequest request) {
        StringBuilder buff = new StringBuilder(request.getRequestURL().toString());
        String queryString = request.getQueryString();
        if (queryString != null) {
            buff.append("?").append(queryString);
        }
        return buff.toString();
    }

    public static String enterToHtmlWrap(String source) {
        if (source == null || source.trim().isEmpty()) {
            return source;
        }
        return source.replaceAll("\r\n", "<br />");
    }

    public static void redirect(HttpServletResponse response, String url, boolean movePermanently) throws IOException {
        if (!movePermanently) {
            response.sendRedirect(url);
        } else {
            response.setStatus(301);
            response.setHeader("Location", url);
        }
    }

    static {
        AGENT_PATTERNS.put(AGENT_INDEX[0], Pattern.compile("MSIE ([\\d.]+)"));
        AGENT_PATTERNS.put(AGENT_INDEX[1], Pattern.compile("Firefox/(\\d.+)"));
        AGENT_PATTERNS.put(AGENT_INDEX[2], Pattern.compile("Chrome/([\\d.]+)"));
        AGENT_PATTERNS.put(AGENT_INDEX[3], Pattern.compile("Opera[/\\s]([\\d.]+)"));
        AGENT_PATTERNS.put(AGENT_INDEX[4], Pattern.compile("Version/([\\d.]+)"));
    }
}

