/*
 * Decompiled with CFR 0.152.
 */
package com.message.schema.ct.common.v1_1.xsd;

import com.message.schema.ct.common.v1_1.xsd.RequestSOAPHeader;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.HTTPConstants;

public class DecodeSoapHeader {
    private MessageContext context = null;
    private SOAPEnvelope requestEnvelope = null;
    private SOAPEnvelope responseEnvelope = null;
    private String namespace = "http://v1_1.common.ct.schema.message.com";

    public DecodeSoapHeader(MessageContext context) {
        try {
            this.context = context;
            this.requestEnvelope = context.getRequestMessage().getSOAPEnvelope();
            this.responseEnvelope = context.getResponseMessage().getSOAPEnvelope();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DecodeSoapHeader() {
    }

    public DecodeSoapHeader(Call call) {
        try {
            Message msg = call.getResponseMessage();
            this.requestEnvelope = msg.getSOAPEnvelope();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RequestSOAPHeader DecodeDownSoapHeader() {
        RequestSOAPHeader soapHeader = new RequestSOAPHeader();
        try {
            SOAPHeaderElement requestSequenceIdHeader = this.requestEnvelope.getHeaderByName("http://message.com/schema/ct/common/v1_1", "RequestSOAPHeader", true);
            Iterator iterator = requestSequenceIdHeader.getChildElements();
            while (iterator.hasNext()) {
                SOAPElement element = (SOAPElement)iterator.next();
                String elementName = element.getElementName().getLocalName();
                if (elementName.equals("spId")) {
                    soapHeader.setSpId(element.getValue());
                    continue;
                }
                if (elementName.equals("spPassword")) {
                    soapHeader.setSpPassword(element.getValue());
                    continue;
                }
                if (elementName.equals("serviceId")) {
                    soapHeader.setServiceId(element.getValue());
                    continue;
                }
                if (elementName.equals("timeStamp")) {
                    soapHeader.setTimeStamp(element.getValue());
                    continue;
                }
                if (elementName.equals("SAN")) {
                    soapHeader.setSAN(element.getValue());
                    continue;
                }
                if (elementName.equals("FA")) {
                    soapHeader.setFA(element.getValue());
                    continue;
                }
                if (elementName.equals("linkId")) {
                    soapHeader.setLinkId(element.getValue());
                    continue;
                }
                if (elementName.equals("OA")) {
                    soapHeader.setOA(element.getValue());
                    continue;
                }
                if (elementName.equals("transactionId")) {
                    soapHeader.setTransactionId(element.getValue());
                    continue;
                }
                if (!elementName.equals("multicastMessaging")) continue;
                soapHeader.setMulticastMessaging(Boolean.valueOf(element.getValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return soapHeader;
    }

    public SOAPHeaderElement EncodeUpSoapHeader(RequestSOAPHeader rh) {
        SOAPHeaderElement SoapHeader = new SOAPHeaderElement("http://message.com/schema/ct/common/v1_1", "RequestSOAPHeader");
        try {
            if (rh.getSpId() != null) {
                SoapHeader.addChildElement("spId").addTextNode(rh.getSpId());
            }
            if (rh.getSpPassword() != null) {
                SoapHeader.addChildElement("spPassword").addTextNode(rh.getSpPassword());
            }
            if (rh.getTimeStamp() != null) {
                SoapHeader.addChildElement("timeStamp").addTextNode(rh.getTimeStamp());
            }
            if (rh.getServiceId() != null) {
                SoapHeader.addChildElement("serviceId").addTextNode(rh.getServiceId());
            }
            if (rh.getSAN() != null) {
                SoapHeader.addChildElement("SAN").addTextNode(rh.getSAN());
            }
            if (rh.getTransactionId() != null) {
                SoapHeader.addChildElement("transactionId").addTextNode(rh.getTransactionId());
            }
            if (rh.getSpPassword() != null) {
                SoapHeader.addChildElement("linkId").addTextNode(rh.getLinkId());
            }
            if (rh.getOA() != null) {
                SoapHeader.addChildElement("OA").addTextNode(rh.getOA());
            }
            if (rh.getFA() != null) {
                SoapHeader.addChildElement("FA").addTextNode(rh.getFA());
            }
            if (rh.getMulticastMessaging() != null) {
                SoapHeader.addChildElement("multicastMessaging").addTextNode(rh.getMulticastMessaging().toString());
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return SoapHeader;
    }

    public String getIP() {
        HttpServletRequest request = (HttpServletRequest)this.context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String ip = request.getRemoteAddr();
        return ip;
    }
}

