/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow;

import java.io.PrintStream;
import java.io.PrintWriter;

public class WorkflowException
extends Exception {
    private Throwable rootCause;

    public WorkflowException() {
    }

    public WorkflowException(String s) {
        super(s);
    }

    public WorkflowException(String s, Throwable rootCause) {
        super(s);
        this.rootCause = rootCause;
    }

    public WorkflowException(Throwable rootCause) {
        this.rootCause = rootCause;
    }

    @Override
    public Throwable getCause() {
        return this.rootCause;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        String msg = super.getMessage();
        if (msg != null) {
            sb.append(msg);
            if (this.rootCause != null) {
                sb.append(": ");
            }
        }
        if (this.rootCause != null) {
            sb.append("root cause: " + (this.rootCause.getMessage() == null ? this.rootCause.toString() : this.rootCause.getMessage()));
        }
        return sb.toString();
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.rootCause != null) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println("\nRoot cause:");
                this.rootCause.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.rootCause != null) {
            PrintStream printStream = s;
            synchronized (printStream) {
                s.println("\nRoot cause:");
                this.rootCause.printStackTrace(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.rootCause != null) {
            PrintWriter printWriter = s;
            synchronized (printWriter) {
                s.println("\nRoot cause:");
                this.rootCause.printStackTrace(s);
            }
        }
    }
}

