/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class JoinDescriptor
extends AbstractDescriptor
implements Validatable {
    protected List conditions = new ArrayList();
    protected ResultDescriptor result;

    JoinDescriptor() {
    }

    JoinDescriptor(Element join) {
        this.init(join);
    }

    public List getConditions() {
        return this.conditions;
    }

    public void setResult(ResultDescriptor result) {
        this.result = result;
    }

    public ResultDescriptor getResult() {
        return this.result;
    }

    @Override
    public void validate() throws InvalidWorkflowDescriptorException {
        ValidationHelper.validate(this.conditions);
        if (this.result == null) {
            throw new InvalidWorkflowDescriptorException("Join has no result");
        }
        this.result.validate();
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        XMLUtil.printIndent(out, indent++);
        out.println("<join id=\"" + this.getId() + "\">");
        if (this.conditions.size() > 0) {
            int i = 0;
            while (i < this.conditions.size()) {
                ConditionsDescriptor condition = (ConditionsDescriptor)this.conditions.get(i);
                condition.writeXML(out, indent);
                ++i;
            }
        }
        if (this.result != null) {
            this.result.writeXML(out, indent);
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</join>");
    }

    protected void init(Element join) {
        try {
            this.setId(Integer.parseInt(join.getAttribute("id")));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid join id value " + join.getAttribute("id"));
        }
        List conditionNodes = XMLUtil.getChildElements(join, "conditions");
        int length = conditionNodes.size();
        int i = 0;
        while (i < length) {
            Element condition = (Element)conditionNodes.get(i);
            ConditionsDescriptor conditionDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor(condition);
            conditionDescriptor.setParent(this);
            this.conditions.add(conditionDescriptor);
            ++i;
        }
        Element resultElement = XMLUtil.getChildElement(join, "unconditional-result");
        if (resultElement != null) {
            this.result = new ResultDescriptor(resultElement);
            this.result.setParent(this);
        }
    }
}

