/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class RestrictionDescriptor
extends AbstractDescriptor
implements Validatable {
    protected List conditions = new ArrayList();

    public RestrictionDescriptor() {
    }

    public RestrictionDescriptor(Element restriction) {
        this.init(restriction);
    }

    public List getConditions() {
        return this.conditions;
    }

    public void setConditionsDescriptor(ConditionsDescriptor descriptor) {
        if (this.conditions.size() == 1) {
            this.conditions.set(0, descriptor);
        } else {
            this.conditions.add(descriptor);
        }
    }

    public ConditionsDescriptor getConditionsDescriptor() {
        if (this.conditions.size() == 0) {
            return null;
        }
        return (ConditionsDescriptor)this.conditions.get(0);
    }

    @Override
    public void validate() throws InvalidWorkflowDescriptorException {
        if (this.conditions.size() > 1) {
            throw new InvalidWorkflowDescriptorException("A restrict-to element can only have one conditions child element");
        }
        ValidationHelper.validate(this.conditions);
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        ConditionsDescriptor conditions = this.getConditionsDescriptor();
        List list = conditions.getConditions();
        if (list.size() == 0) {
            return;
        }
        XMLUtil.printIndent(out, indent++);
        out.println("<restrict-to>");
        conditions.writeXML(out, indent);
        XMLUtil.printIndent(out, --indent);
        out.println("</restrict-to>");
    }

    protected void init(Element restriction) {
        List conditionNodes = XMLUtil.getChildElements(restriction, "conditions");
        int length = conditionNodes.size();
        int i = 0;
        while (i < length) {
            Element condition = (Element)conditionNodes.get(i);
            ConditionsDescriptor conditionDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor(condition);
            conditionDescriptor.setParent(this);
            this.conditions.add(conditionDescriptor);
            ++i;
        }
    }
}

