/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class SplitDescriptor
extends AbstractDescriptor
implements Validatable {
    protected List results = new ArrayList();

    SplitDescriptor() {
    }

    SplitDescriptor(Element split) {
        this.init(split);
    }

    public List getResults() {
        return this.results;
    }

    @Override
    public void validate() throws InvalidWorkflowDescriptorException {
        ValidationHelper.validate(this.results);
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        XMLUtil.printIndent(out, indent++);
        out.println("<split id=\"" + this.getId() + "\">");
        int i = 0;
        while (i < this.results.size()) {
            ResultDescriptor result = (ResultDescriptor)this.results.get(i);
            result.writeXML(out, indent);
            ++i;
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</split>");
    }

    private void init(Element split) {
        try {
            this.setId(Integer.parseInt(split.getAttribute("id")));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid split id value " + split.getAttribute("id"));
        }
        List uResults = XMLUtil.getChildElements(split, "unconditional-result");
        int i = 0;
        while (i < uResults.size()) {
            Element result = (Element)uResults.get(i);
            ResultDescriptor resultDescriptor = new ResultDescriptor(result);
            resultDescriptor.setParent(this);
            this.results.add(resultDescriptor);
            ++i;
        }
    }
}

