/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DTDEntityResolver;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.JoinDescriptor;
import com.opensymphony.workflow.loader.RegisterDescriptor;
import com.opensymphony.workflow.loader.SplitDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.WorkflowLoader;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WorkflowDescriptor
extends AbstractDescriptor
implements Validatable {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String DOCTYPE_DECL = "<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">";
    protected ConditionsDescriptor globalConditions = null;
    protected List commonActionsList = new ArrayList();
    protected List globalActions = new ArrayList();
    protected List initialActions = new ArrayList();
    protected List joins = new ArrayList();
    protected List registers = new ArrayList();
    protected List splits = new ArrayList();
    protected List steps = new ArrayList();
    protected Map commonActions = new HashMap();
    protected Map metaAttributes = new HashMap();
    protected Map timerFunctions = new HashMap();
    protected String workflowName = null;

    public WorkflowDescriptor() {
    }

    public WorkflowDescriptor(Element root) {
        this.init(root);
    }

    public ActionDescriptor getAction(int id) {
        for (ActionDescriptor actionDescriptor : this.globalActions) {
            if (actionDescriptor.getId() != id) continue;
            return actionDescriptor;
        }
        for (StepDescriptor stepDescriptor : this.steps) {
            ActionDescriptor actionDescriptor = stepDescriptor.getAction(id);
            if (actionDescriptor == null) continue;
            return actionDescriptor;
        }
        for (ActionDescriptor actionDescriptor : this.initialActions) {
            if (actionDescriptor.getId() != id) continue;
            return actionDescriptor;
        }
        return null;
    }

    public Map getCommonActions() {
        return this.commonActions;
    }

    public List getGlobalActions() {
        return this.globalActions;
    }

    public ConditionsDescriptor getGlobalConditions() {
        return this.globalConditions;
    }

    public ActionDescriptor getInitialAction(int id) {
        for (ActionDescriptor actionDescriptor : this.initialActions) {
            if (actionDescriptor.getId() != id) continue;
            return actionDescriptor;
        }
        return null;
    }

    public List getInitialActions() {
        return this.initialActions;
    }

    public JoinDescriptor getJoin(int id) {
        for (JoinDescriptor joinDescriptor : this.joins) {
            if (joinDescriptor.getId() != id) continue;
            return joinDescriptor;
        }
        return null;
    }

    public List getJoins() {
        return this.joins;
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public void setName(String name) {
        this.workflowName = name;
    }

    public String getName() {
        return this.workflowName;
    }

    public List getRegisters() {
        return this.registers;
    }

    public SplitDescriptor getSplit(int id) {
        for (SplitDescriptor splitDescriptor : this.splits) {
            if (splitDescriptor.getId() != id) continue;
            return splitDescriptor;
        }
        return null;
    }

    public List getSplits() {
        return this.splits;
    }

    public StepDescriptor getStep(int id) {
        for (StepDescriptor step : this.steps) {
            if (step.getId() != id) continue;
            return step;
        }
        return null;
    }

    public List getSteps() {
        return this.steps;
    }

    public FunctionDescriptor setTriggerFunction(int id, FunctionDescriptor descriptor) {
        return this.timerFunctions.put(new Integer(id), descriptor);
    }

    public FunctionDescriptor getTriggerFunction(int id) {
        return (FunctionDescriptor)this.timerFunctions.get(new Integer(id));
    }

    public Map getTriggerFunctions() {
        return this.timerFunctions;
    }

    public void addCommonAction(ActionDescriptor descriptor) {
        descriptor.setCommon(true);
        this.addAction(this.commonActions, descriptor);
        this.addAction(this.commonActionsList, descriptor);
    }

    public void addGlobalAction(ActionDescriptor descriptor) {
        this.addAction(this.globalActions, descriptor);
    }

    public void addInitialAction(ActionDescriptor descriptor) {
        this.addAction(this.initialActions, descriptor);
    }

    public void addJoin(JoinDescriptor descriptor) {
        if (this.getJoin(descriptor.getId()) != null) {
            throw new IllegalArgumentException("Join with id " + descriptor.getId() + " already exists");
        }
        this.joins.add(descriptor);
    }

    public void addSplit(SplitDescriptor descriptor) {
        if (this.getSplit(descriptor.getId()) != null) {
            throw new IllegalArgumentException("Split with id " + descriptor.getId() + " already exists");
        }
        this.splits.add(descriptor);
    }

    public void addStep(StepDescriptor descriptor) {
        if (this.getStep(descriptor.getId()) != null) {
            throw new IllegalArgumentException("Step with id " + descriptor.getId() + " already exists");
        }
        this.steps.add(descriptor);
    }

    public boolean removeAction(ActionDescriptor actionToRemove) {
        for (ActionDescriptor actionDescriptor : this.getGlobalActions()) {
            if (actionDescriptor.getId() != actionToRemove.getId()) continue;
            this.getGlobalActions().remove(actionDescriptor);
            return true;
        }
        for (StepDescriptor stepDescriptor : this.getSteps()) {
            ActionDescriptor actionDescriptor = stepDescriptor.getAction(actionToRemove.getId());
            if (actionDescriptor == null) continue;
            stepDescriptor.getActions().remove(actionDescriptor);
            return true;
        }
        return false;
    }

    @Override
    public void validate() throws InvalidWorkflowDescriptorException {
        ValidationHelper.validate(this.getRegisters());
        ValidationHelper.validate(this.getTriggerFunctions().values());
        ValidationHelper.validate(this.getGlobalActions());
        ValidationHelper.validate(this.getInitialActions());
        ValidationHelper.validate(this.getCommonActions().values());
        ValidationHelper.validate(this.getSteps());
        ValidationHelper.validate(this.getSplits());
        ValidationHelper.validate(this.getJoins());
        HashSet<Integer> actions = new HashSet<Integer>();
        for (Serializable action : this.globalActions) {
            actions.add(new Integer(((AbstractDescriptor)action).getId()));
        }
        for (StepDescriptor step : this.getSteps()) {
            for (ActionDescriptor action : step.getActions()) {
                if (action.isCommon() || actions.add(new Integer(action.getId()))) continue;
                throw new InvalidWorkflowDescriptorException("Duplicate occurance of action ID " + action.getId() + " found in step " + step.getId());
            }
        }
        for (Serializable action : this.commonActions.keySet()) {
            if (!actions.contains(action)) continue;
            throw new InvalidWorkflowDescriptorException("common-action ID " + action + " is duplicated in a step action");
        }
        for (Serializable action : this.initialActions) {
            if (!actions.contains(new Integer(((AbstractDescriptor)action).getId()))) continue;
            throw new InvalidWorkflowDescriptorException("initial-action ID " + action + " is duplicated in a step action");
        }
        this.validateDTD();
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        ActionDescriptor action2;
        XMLUtil.printIndent(out, indent++);
        out.println("<workflow>");
        for (Map.Entry entry : this.metaAttributes.entrySet()) {
            XMLUtil.printIndent(out, indent);
            out.print("<meta name=\"");
            out.print(XMLUtil.encode(entry.getKey()));
            out.print("\">");
            out.print(XMLUtil.encode(entry.getValue()));
            out.println("</meta>");
        }
        if (this.registers.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<registers>");
            int i = 0;
            while (i < this.registers.size()) {
                RegisterDescriptor register = (RegisterDescriptor)this.registers.get(i);
                register.writeXML(out, indent);
                ++i;
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</registers>");
        }
        if (this.timerFunctions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<trigger-functions>");
            Iterator iterator = this.timerFunctions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                XMLUtil.printIndent(out, indent++);
                out.println("<trigger-function id=\"" + entry.getKey() + "\">");
                FunctionDescriptor trigger = (FunctionDescriptor)entry.getValue();
                trigger.writeXML(out, indent);
                XMLUtil.printIndent(out, --indent);
                out.println("</trigger-function>");
            }
            while (iterator.hasNext()) {
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</trigger-functions>");
        }
        if (this.getGlobalConditions() != null) {
            XMLUtil.printIndent(out, indent++);
            out.println("<global-conditions>");
            this.getGlobalConditions().writeXML(out, indent);
            out.println("</global-conditions>");
        }
        XMLUtil.printIndent(out, indent++);
        out.println("<initial-actions>");
        int i = 0;
        while (i < this.initialActions.size()) {
            action2 = (ActionDescriptor)this.initialActions.get(i);
            action2.writeXML(out, indent);
            ++i;
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</initial-actions>");
        if (this.globalActions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<global-actions>");
            i = 0;
            while (i < this.globalActions.size()) {
                action2 = (ActionDescriptor)this.globalActions.get(i);
                action2.writeXML(out, indent);
                ++i;
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</global-actions>");
        }
        if (this.commonActions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<common-actions>");
            for (ActionDescriptor action2 : this.getCommonActions().values()) {
                action2.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</common-actions>");
        }
        XMLUtil.printIndent(out, indent++);
        out.println("<steps>");
        i = 0;
        while (i < this.steps.size()) {
            StepDescriptor step = (StepDescriptor)this.steps.get(i);
            step.writeXML(out, indent);
            ++i;
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</steps>");
        if (this.splits.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<splits>");
            i = 0;
            while (i < this.splits.size()) {
                SplitDescriptor split = (SplitDescriptor)this.splits.get(i);
                split.writeXML(out, indent);
                ++i;
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</splits>");
        }
        if (this.joins.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<joins>");
            i = 0;
            while (i < this.joins.size()) {
                JoinDescriptor join = (JoinDescriptor)this.joins.get(i);
                join.writeXML(out, indent);
                ++i;
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</joins>");
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</workflow>");
    }

    protected void init(Element root) {
        Element joinsElement;
        Element timerFunctionsElement;
        Element commonActionsElement;
        Element globalConditionsElement;
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("meta")) {
                Element meta = (Element)child;
                String value = XMLUtil.getText(meta);
                this.metaAttributes.put(meta.getAttribute("name"), value);
            }
            ++i;
        }
        Element r = XMLUtil.getChildElement(root, "registers");
        if (r != null) {
            List registers = XMLUtil.getChildElements(r, "register");
            int i2 = 0;
            while (i2 < registers.size()) {
                Element register = (Element)registers.get(i2);
                RegisterDescriptor registerDescriptor = DescriptorFactory.getFactory().createRegisterDescriptor(register);
                registerDescriptor.setParent(this);
                this.registers.add(registerDescriptor);
                ++i2;
            }
        }
        if ((globalConditionsElement = XMLUtil.getChildElement(root, "global-conditions")) != null) {
            Element globalConditions = XMLUtil.getChildElement(globalConditionsElement, "conditions");
            ConditionsDescriptor conditionsDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor(globalConditions);
            conditionsDescriptor.setParent(this);
            this.globalConditions = conditionsDescriptor;
        }
        Element intialActionsElement = XMLUtil.getChildElement(root, "initial-actions");
        List initialActions = XMLUtil.getChildElements(intialActionsElement, "action");
        int i3 = 0;
        while (i3 < initialActions.size()) {
            Element initialAction = (Element)initialActions.get(i3);
            ActionDescriptor actionDescriptor = DescriptorFactory.getFactory().createActionDescriptor(initialAction);
            actionDescriptor.setParent(this);
            this.initialActions.add(actionDescriptor);
            ++i3;
        }
        Element globalActionsElement = XMLUtil.getChildElement(root, "global-actions");
        if (globalActionsElement != null) {
            List globalActions = XMLUtil.getChildElements(globalActionsElement, "action");
            int i4 = 0;
            while (i4 < globalActions.size()) {
                Element globalAction = (Element)globalActions.get(i4);
                ActionDescriptor actionDescriptor = DescriptorFactory.getFactory().createActionDescriptor(globalAction);
                actionDescriptor.setParent(this);
                this.globalActions.add(actionDescriptor);
                ++i4;
            }
        }
        if ((commonActionsElement = XMLUtil.getChildElement(root, "common-actions")) != null) {
            List commonActions = XMLUtil.getChildElements(commonActionsElement, "action");
            int i5 = 0;
            while (i5 < commonActions.size()) {
                Element commonAction = (Element)commonActions.get(i5);
                ActionDescriptor actionDescriptor = DescriptorFactory.getFactory().createActionDescriptor(commonAction);
                actionDescriptor.setParent(this);
                this.addCommonAction(actionDescriptor);
                ++i5;
            }
        }
        if ((timerFunctionsElement = XMLUtil.getChildElement(root, "trigger-functions")) != null) {
            List timerFunctions = XMLUtil.getChildElements(timerFunctionsElement, "trigger-function");
            int i6 = 0;
            while (i6 < timerFunctions.size()) {
                Element timerFunction = (Element)timerFunctions.get(i6);
                Integer id = new Integer(timerFunction.getAttribute("id"));
                FunctionDescriptor function = DescriptorFactory.getFactory().createFunctionDescriptor(XMLUtil.getChildElement(timerFunction, "function"));
                function.setParent(this);
                this.timerFunctions.put(id, function);
                ++i6;
            }
        }
        Element stepsElement = XMLUtil.getChildElement(root, "steps");
        List steps = XMLUtil.getChildElements(stepsElement, "step");
        int i7 = 0;
        while (i7 < steps.size()) {
            Element step = (Element)steps.get(i7);
            StepDescriptor stepDescriptor = DescriptorFactory.getFactory().createStepDescriptor(step, this);
            this.steps.add(stepDescriptor);
            ++i7;
        }
        Element splitsElement = XMLUtil.getChildElement(root, "splits");
        if (splitsElement != null) {
            List split = XMLUtil.getChildElements(splitsElement, "split");
            int i8 = 0;
            while (i8 < split.size()) {
                Element s = (Element)split.get(i8);
                SplitDescriptor splitDescriptor = DescriptorFactory.getFactory().createSplitDescriptor(s);
                splitDescriptor.setParent(this);
                this.splits.add(splitDescriptor);
                ++i8;
            }
        }
        if ((joinsElement = XMLUtil.getChildElement(root, "joins")) != null) {
            List join = XMLUtil.getChildElements(joinsElement, "join");
            int i9 = 0;
            while (i9 < join.size()) {
                Element s = (Element)join.get(i9);
                JoinDescriptor joinDescriptor = DescriptorFactory.getFactory().createJoinDescriptor(s);
                joinDescriptor.setParent(this);
                this.joins.add(joinDescriptor);
                ++i9;
            }
        }
    }

    private void addAction(Object actionsCollectionOrMap, ActionDescriptor descriptor) {
        if (this.getAction(descriptor.getId()) != null) {
            throw new IllegalArgumentException("action with id " + descriptor.getId() + " already exists for this step.");
        }
        if (actionsCollectionOrMap instanceof Map) {
            ((Map)actionsCollectionOrMap).put(new Integer(descriptor.getId()), descriptor);
        } else {
            ((Collection)actionsCollectionOrMap).add(descriptor);
        }
    }

    private void validateDTD() throws InvalidWorkflowDescriptorException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        writer.println(XML_HEADER);
        writer.println(DOCTYPE_DECL);
        this.writeXML(writer, 0);
        WorkflowLoader.AllExceptionsErrorHandler errorHandler = new WorkflowLoader.AllExceptionsErrorHandler();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new DTDEntityResolver());
            db.setErrorHandler(errorHandler);
            db.parse(new InputSource(new StringReader(sw.toString())));
            if (errorHandler.getExceptions().size() > 0) {
                throw new InvalidWorkflowDescriptorException(errorHandler.getExceptions().toString());
            }
        }
        catch (InvalidWorkflowDescriptorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidWorkflowDescriptorException(e.toString());
        }
    }
}

