/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static Element getChildElement(Element parent, String childName) {
        NodeList children = parent.getChildNodes();
        int size = children.getLength();
        int i = 0;
        while (i < size) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && childName.equals((element = (Element)node).getNodeName())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static List getChildElements(Element parent, String childName) {
        NodeList children = parent.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        int size = children.getLength();
        int i = 0;
        while (i < size) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && childName.equals((element = (Element)node).getNodeName())) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    public static String getChildText(Element parent, String childName) {
        Element child = XMLUtil.getChildElement(parent, childName);
        if (child == null) {
            return null;
        }
        return XMLUtil.getText(child);
    }

    public static String getText(Element node) {
        StringBuffer sb = new StringBuffer();
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    sb.append(child.getNodeValue());
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String encode(Object string) {
        if (string == null) {
            return "";
        }
        char[] chars = string.toString().toCharArray();
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                default: {
                    out.append(chars[i]);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static void printIndent(PrintWriter out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print("  ");
            ++i;
        }
    }
}

