/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.hibernate3;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.QueryNotSupportedException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.FieldExpression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.spi.hibernate.HibernateCurrentStep;
import com.opensymphony.workflow.spi.hibernate.HibernateHistoryStep;
import com.opensymphony.workflow.spi.hibernate.HibernateStep;
import com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry;
import com.opensymphony.workflow.util.PropertySetDelegate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractHibernateWorkflowStore
implements WorkflowStore {
    private PropertySetDelegate propertySetDelegate;
    private String cacheRegion = null;
    private boolean cacheable = false;

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public void setEntryState(long entryId, int state) throws StoreException {
        this.loadEntry(entryId).setState(state);
    }

    @Override
    public PropertySet getPropertySet(long entryId) throws StoreException {
        if (this.getPropertySetDelegate() == null) {
            throw new StoreException("PropertySetDelegate is not properly configured");
        }
        return this.getPropertySetDelegate().getPropertySet(entryId);
    }

    public void setPropertySetDelegate(PropertySetDelegate propertySetDelegate) {
        this.propertySetDelegate = propertySetDelegate;
    }

    public PropertySetDelegate getPropertySetDelegate() {
        return this.propertySetDelegate;
    }

    @Override
    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        HibernateWorkflowEntry entry = this.loadEntry(entryId);
        HibernateCurrentStep step = new HibernateCurrentStep();
        step.setStepId(stepId);
        step.setOwner(owner);
        step.setStartDate(startDate);
        step.setDueDate(dueDate);
        step.setStatus(status);
        ArrayList<Step> previousSteps = new ArrayList<Step>(previousIds.length);
        int i = 0;
        while (i < previousIds.length) {
            HibernateCurrentStep previousStep = new HibernateCurrentStep();
            previousSteps.add(previousStep);
            ++i;
        }
        step.setPreviousSteps(previousSteps);
        entry.addCurrentSteps(step);
        this.save(step);
        return step;
    }

    @Override
    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        HibernateWorkflowEntry entry = new HibernateWorkflowEntry();
        entry.setState(0);
        entry.setWorkflowName(workflowName);
        this.save(entry);
        return entry;
    }

    @Override
    public List<Step> findCurrentSteps(long entryId) throws StoreException {
        return new ArrayList<Step>(this.loadEntry(entryId).getCurrentSteps());
    }

    @Override
    public WorkflowEntry findEntry(long entryId) throws StoreException {
        return this.loadEntry(entryId);
    }

    @Override
    public List<Step> findHistorySteps(long entryId) throws StoreException {
        return new ArrayList<Step>(this.loadEntry(entryId).getHistorySteps());
    }

    @Override
    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        HibernateCurrentStep currentStep = (HibernateCurrentStep)step;
        currentStep.setActionId(actionId);
        currentStep.setFinishDate(finishDate);
        currentStep.setStatus(status);
        currentStep.setCaller(caller);
        return currentStep;
    }

    @Override
    public void moveToHistory(Step step) throws StoreException {
        HibernateCurrentStep currentStep = (HibernateCurrentStep)step;
        HibernateWorkflowEntry entry = currentStep.getEntry();
        HibernateHistoryStep hStep = new HibernateHistoryStep(currentStep);
        entry.removeCurrentSteps(currentStep);
        this.delete(currentStep);
        entry.addHistorySteps(hStep);
        this.save(hStep);
    }

    @Override
    public List<Long> query(final WorkflowExpressionQuery query) throws StoreException {
        return (List)this.execute(new InternalCallback(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                Expression expression = query.getExpression();
                Class entityClass = AbstractHibernateWorkflowStore.this.getQueryClass(expression, null);
                Criterion expr = expression.isNested() ? AbstractHibernateWorkflowStore.this.buildNested((NestedExpression)expression) : AbstractHibernateWorkflowStore.this.queryComparison((FieldExpression)expression);
                Criteria criteria = session.createCriteria(entityClass);
                criteria.setCacheable(AbstractHibernateWorkflowStore.this.isCacheable());
                if (AbstractHibernateWorkflowStore.this.isCacheable()) {
                    criteria.setCacheRegion(AbstractHibernateWorkflowStore.this.getCacheRegion());
                }
                criteria.add(expr);
                HashSet<Long> results = new HashSet<Long>();
                for (Object next : criteria.list()) {
                    Long item;
                    if (next instanceof HibernateStep) {
                        HibernateStep step = (HibernateStep)next;
                        item = new Long(step.getEntryId());
                    } else {
                        WorkflowEntry entry = (WorkflowEntry)next;
                        item = new Long(entry.getId());
                    }
                    results.add(item);
                }
                return new ArrayList(results);
            }
        });
    }

    protected abstract Object execute(InternalCallback var1) throws StoreException;

    protected String getCacheRegion() {
        return this.cacheRegion;
    }

    protected boolean isCacheable() {
        return this.cacheable;
    }

    protected void delete(final Object entry) throws StoreException {
        this.execute(new InternalCallback(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.delete(entry);
                return null;
            }
        });
    }

    protected HibernateWorkflowEntry loadEntry(final long entryId) throws StoreException {
        return (HibernateWorkflowEntry)this.execute(new InternalCallback(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                return session.load(HibernateWorkflowEntry.class, (Serializable)new Long(entryId));
            }
        });
    }

    protected void save(final Object entry) throws StoreException {
        this.execute(new InternalCallback(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                session.save(entry);
                return null;
            }
        });
    }

    private String getFieldName(int field) {
        switch (field) {
            case 4: {
                return "actionId";
            }
            case 6: {
                return "caller";
            }
            case 3: {
                return "finishDate";
            }
            case 1: {
                return "owner";
            }
            case 2: {
                return "startDate";
            }
            case 5: {
                return "stepId";
            }
            case 7: {
                return "status";
            }
            case 9: {
                return "state";
            }
            case 8: {
                return "workflowName";
            }
            case 10: {
                return "dueDate";
            }
        }
        return "1";
    }

    private Class getQueryClass(Expression expr, Collection classesCache) {
        block11: {
            block10: {
                if (classesCache == null) {
                    classesCache = new HashSet<Class>();
                }
                if (!(expr instanceof FieldExpression)) break block10;
                FieldExpression fieldExpression = (FieldExpression)expr;
                switch (fieldExpression.getContext()) {
                    case 2: {
                        classesCache.add(HibernateCurrentStep.class);
                        break block11;
                    }
                    case 1: {
                        classesCache.add(HibernateHistoryStep.class);
                        break block11;
                    }
                    case 3: {
                        classesCache.add(HibernateWorkflowEntry.class);
                        break block11;
                    }
                    default: {
                        throw new QueryNotSupportedException("Query for unsupported context " + fieldExpression.getContext());
                    }
                }
            }
            NestedExpression nestedExpression = (NestedExpression)expr;
            int i = 0;
            while (i < nestedExpression.getExpressionCount()) {
                Expression expression = nestedExpression.getExpression(i);
                if (expression.isNested()) {
                    classesCache.add(this.getQueryClass(nestedExpression.getExpression(i), classesCache));
                } else {
                    classesCache.add(this.getQueryClass(expression, classesCache));
                }
                ++i;
            }
        }
        if (classesCache.size() > 1) {
            throw new QueryNotSupportedException("Store does not support nested queries of different types (types found:" + classesCache + ")");
        }
        return (Class)classesCache.iterator().next();
    }

    private Criterion buildNested(NestedExpression nestedExpression) {
        Criterion full = null;
        int i = 0;
        while (i < nestedExpression.getExpressionCount()) {
            Criterion expr;
            Expression expression = nestedExpression.getExpression(i);
            if (expression.isNested()) {
                expr = this.buildNested((NestedExpression)nestedExpression.getExpression(i));
            } else {
                FieldExpression sub = (FieldExpression)nestedExpression.getExpression(i);
                expr = this.queryComparison(sub);
                if (sub.isNegate()) {
                    expr = Restrictions.not((Criterion)expr);
                }
            }
            if (full == null) {
                full = expr;
            } else {
                switch (nestedExpression.getExpressionOperator()) {
                    case 6: {
                        full = Restrictions.and((Criterion)full, (Criterion)expr);
                        break;
                    }
                    case 7: {
                        full = Restrictions.or((Criterion)full, (Criterion)expr);
                    }
                }
            }
            ++i;
        }
        return full;
    }

    private Criterion queryComparison(FieldExpression expression) {
        int operator = expression.getOperator();
        switch (operator) {
            case 1: {
                return Restrictions.eq((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
            case 5: {
                return Restrictions.not((Criterion)Restrictions.like((String)this.getFieldName(expression.getField()), (Object)expression.getValue()));
            }
            case 3: {
                return Restrictions.gt((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
            case 2: {
                return Restrictions.lt((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
        }
        return Restrictions.eq((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
    }

    protected static interface InternalCallback {
        public Object doInHibernate(Session var1) throws HibernateException, StoreException;
    }
}

