/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.util.WorkflowListener;
import com.opensymphony.workflow.util.WorkflowLocalListener;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBInvoker
implements FunctionProvider {
    private static final Log log = LogFactory.getLog(EJBInvoker.class);

    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) {
        Class<?> homeClass = null;
        Object home = null;
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        Hashtable env = new Hashtable(args);
        try {
            InitialContext ic = new InitialContext(env);
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing with properties=" + args));
            }
            if (args.containsKey("ejb-home")) {
                homeClass = Class.forName((String)args.get("ejb-home"));
            } else if (args.containsKey("ejb-local-home")) {
                homeClass = Class.forName((String)args.get("ejb-local-home"));
            }
            home = PortableRemoteObject.narrow((Object)ic.lookup((String)args.get("ejb-jndi-location")), homeClass);
            Method method = homeClass.getMethod("create", new Class[0]);
            if (Remote.class.isAssignableFrom(homeClass)) {
                WorkflowListener listener = (WorkflowListener)method.invoke(home, new Object[0]);
                listener.stateChanged(entry);
            } else {
                WorkflowLocalListener listener = (WorkflowLocalListener)method.invoke(home, new Object[0]);
                listener.stateChanged(entry);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error invoking EJB homeClass=" + homeClass), (Throwable)e);
        }
    }
}

