/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.timer.LocalWorkflowJob;
import com.opensymphony.workflow.timer.WorkflowJob;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class ScheduleJob
implements FunctionProvider {
    private static final Log log = LogFactory.getLog(ScheduleJob.class);

    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) {
        try {
            block26: {
                CronTrigger trigger;
                String jobClassArg;
                WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
                WorkflowContext context = (WorkflowContext)transientVars.get("context");
                log.info((Object)("Starting to schdule job for WF #" + entry.getId()));
                int triggerId = TextUtils.parseInt((String)((String)args.get("triggerId")));
                String jobName = (String)args.get("jobName");
                String triggerName = (String)args.get("triggerName");
                String groupName = (String)args.get("groupName");
                String username = (String)args.get("username");
                String password = (String)args.get("password");
                boolean txHack = TextUtils.parseBoolean((String)((String)args.get("txHack")));
                if (username == null) {
                    username = context.getCaller();
                }
                String cronExpression = (String)args.get("cronExpression");
                jobName = String.valueOf(jobName) + ":" + entry.getId();
                triggerName = String.valueOf(triggerName) + ":" + entry.getId();
                groupName = String.valueOf(groupName) + ":" + entry.getId();
                String schedulerName = (String)args.get("schedulerName");
                StdSchedulerFactory factory = new StdSchedulerFactory();
                Scheduler s = schedulerName == null || "".equals(schedulerName.trim()) ? factory.getScheduler() : factory.getScheduler(schedulerName);
                if (TextUtils.parseBoolean((String)((String)args.get("schedulerStart")))) {
                    log.info((Object)"Starting Quartz Job Scheduler");
                    s.start();
                }
                Class<Object> jobClass = (jobClassArg = (String)args.get("jobClass")) != null ? Class.forName(jobClassArg) : (TextUtils.parseBoolean((String)((String)args.get("local"))) ? LocalWorkflowJob.class : WorkflowJob.class);
                JobDetail jobDetail = new JobDetail(jobName, groupName, jobClass);
                if (cronExpression == null) {
                    long now = System.currentTimeMillis();
                    Date startDate = null;
                    try {
                        String start = (String)args.get("startOffset");
                        if (s != null) {
                            startDate = new Date(now + Long.parseLong(start));
                        }
                    }
                    catch (NumberFormatException start) {
                        // empty catch block
                    }
                    if (startDate == null) {
                        startDate = new Date(now);
                    }
                    Date endDate = null;
                    try {
                        String end = (String)args.get("endOffset");
                        if (s != null) {
                            startDate = new Date(now + Long.parseLong(end));
                        }
                    }
                    catch (NumberFormatException end) {
                        // empty catch block
                    }
                    int repeat = 0;
                    try {
                        String r = (String)args.get("repeat");
                        if (r != null) {
                            repeat = r.equalsIgnoreCase("REPEAT_INDEFINITELY") ? SimpleTrigger.REPEAT_INDEFINITELY : TextUtils.parseInt((String)r);
                        }
                    }
                    catch (NumberFormatException r) {
                        // empty catch block
                    }
                    long delay = 0L;
                    try {
                        String rd = (String)args.get("repeatDelay");
                        if (rd != null) {
                            delay = Long.parseLong(rd);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    trigger = new SimpleTrigger(triggerName, groupName, jobName, groupName, startDate, endDate, repeat, delay);
                } else {
                    trigger = new CronTrigger(triggerName, groupName, jobName, groupName, cronExpression);
                }
                JobDataMap dataMap = new JobDataMap();
                dataMap.put("triggerId", triggerId);
                dataMap.put("entryId", entry.getId());
                dataMap.put("username", username);
                dataMap.put("password", password);
                if (TextUtils.parseBoolean((String)((String)args.get("local")))) {
                    dataMap.put((Object)"configuration", transientVars.get("configuration"));
                }
                jobDetail.setJobDataMap(dataMap);
                jobDetail.setDurability(true);
                trigger.setJobName(jobDetail.getName());
                trigger.setJobGroup(jobDetail.getGroup());
                if (txHack && !s.isPaused() && !s.isShutdown()) {
                    s.pause();
                    try {
                        s.addJob(jobDetail, true);
                        s.scheduleJob((Trigger)trigger);
                        break block26;
                    }
                    finally {
                        s.start();
                    }
                }
                s.addJob(jobDetail, true);
                s.scheduleJob((Trigger)trigger);
            }
            log.info((Object)"Job scheduled");
        }
        catch (Exception e) {
            log.error((Object)"Error scheduling job", (Throwable)e);
        }
    }
}

