/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.bitmap;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.SubTable;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.EblcTable;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat1;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat2;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat3;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat4;
import cfca.sadk.com.google.typography.font.sfntly.table.bitmap.IndexSubTableFormat5;
import java.util.Iterator;

public abstract class IndexSubTable
extends SubTable {
    private static final boolean DEBUG = false;
    private final int firstGlyphIndex;
    private final int lastGlyphIndex;
    private final int indexFormat;
    private final int imageFormat;
    private final int imageDataOffset;

    protected static IndexSubTable createIndexSubTable(ReadableFontData data, int offsetToIndexSubTableArray, int arrayIndex) {
        Builder<IndexSubTable> builder = Builder.createBuilder(data, offsetToIndexSubTableArray, arrayIndex);
        if (builder == null) {
            return null;
        }
        return (IndexSubTable)builder.build();
    }

    protected IndexSubTable(ReadableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
        super(data);
        this.firstGlyphIndex = firstGlyphIndex;
        this.lastGlyphIndex = lastGlyphIndex;
        this.indexFormat = this.data.readUShort(EblcTable.Offset.indexSubHeader_indexFormat.offset);
        this.imageFormat = this.data.readUShort(EblcTable.Offset.indexSubHeader_imageFormat.offset);
        this.imageDataOffset = this.data.readULongAsInt(EblcTable.Offset.indexSubHeader_imageDataOffset.offset);
    }

    public int indexFormat() {
        return this.indexFormat;
    }

    public int firstGlyphIndex() {
        return this.firstGlyphIndex;
    }

    public int lastGlyphIndex() {
        return this.lastGlyphIndex;
    }

    public int imageFormat() {
        return this.imageFormat;
    }

    public int imageDataOffset() {
        return this.imageDataOffset;
    }

    public BitmapGlyphInfo glyphInfo(int glyphId) {
        int loca = this.checkGlyphRange(glyphId);
        if (loca == -1) {
            return null;
        }
        if (this.glyphStartOffset(glyphId) == -1) {
            return null;
        }
        return new BitmapGlyphInfo(glyphId, this.imageDataOffset(), this.glyphStartOffset(glyphId), this.glyphLength(glyphId), this.imageFormat());
    }

    public final int glyphOffset(int glyphId) {
        int glyphStartOffset = this.glyphStartOffset(glyphId);
        if (glyphStartOffset == -1) {
            return -1;
        }
        return this.imageDataOffset() + glyphStartOffset;
    }

    public abstract int glyphStartOffset(int var1);

    public abstract int glyphLength(int var1);

    public abstract int numGlyphs();

    protected static int checkGlyphRange(int glyphId, int firstGlyphId, int lastGlyphId) {
        if (glyphId < firstGlyphId || glyphId > lastGlyphId) {
            throw new IndexOutOfBoundsException("Glyph ID is outside of the allowed range.");
        }
        return glyphId - firstGlyphId;
    }

    protected int checkGlyphRange(int glyphId) {
        return IndexSubTable.checkGlyphRange(glyphId, this.firstGlyphIndex(), this.lastGlyphIndex());
    }

    @Override
    public String toString() {
        String s = "IndexSubTable: [0x" + Integer.toHexString(this.firstGlyphIndex()) + " : Ox" + Integer.toHexString(this.lastGlyphIndex()) + "], format = " + this.indexFormat + ", image format = " + this.imageFormat() + ", imageOff = " + Integer.toHexString(this.imageDataOffset()) + "\n";
        return s;
    }

    public static abstract class Builder<T extends IndexSubTable>
    extends SubTable.Builder<T> {
        private int firstGlyphIndex;
        private int lastGlyphIndex;
        private int indexFormat;
        private int imageFormat;
        private int imageDataOffset;

        public static Builder<? extends IndexSubTable> createBuilder(int indexFormat) {
            switch (indexFormat) {
                case 1: {
                    return IndexSubTableFormat1.Builder.createBuilder();
                }
                case 2: {
                    return IndexSubTableFormat2.Builder.createBuilder();
                }
                case 3: {
                    return IndexSubTableFormat3.Builder.createBuilder();
                }
                case 4: {
                    return IndexSubTableFormat4.Builder.createBuilder();
                }
                case 5: {
                    return IndexSubTableFormat5.Builder.createBuilder();
                }
            }
            throw new IllegalArgumentException(String.format("Invalid Index SubTable Format %d%n", indexFormat));
        }

        static Builder<? extends IndexSubTable> createBuilder(ReadableFontData data, int offsetToIndexSubTableArray, int arrayIndex) {
            int indexSubTableEntryOffset = offsetToIndexSubTableArray + arrayIndex * EblcTable.Offset.indexSubTableEntryLength.offset;
            int firstGlyphIndex = data.readUShort(indexSubTableEntryOffset + EblcTable.Offset.indexSubTableEntry_firstGlyphIndex.offset);
            int lastGlyphIndex = data.readUShort(indexSubTableEntryOffset + EblcTable.Offset.indexSubTableEntry_lastGlyphIndex.offset);
            int additionOffsetToIndexSubtable = data.readULongAsInt(indexSubTableEntryOffset + EblcTable.Offset.indexSubTableEntry_additionalOffsetToIndexSubtable.offset);
            int indexSubTableOffset = offsetToIndexSubTableArray + additionOffsetToIndexSubtable;
            int indexFormat = data.readUShort(indexSubTableOffset);
            switch (indexFormat) {
                case 1: {
                    return IndexSubTableFormat1.Builder.createBuilder(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
                }
                case 2: {
                    return IndexSubTableFormat2.Builder.createBuilder(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
                }
                case 3: {
                    return IndexSubTableFormat3.Builder.createBuilder(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
                }
                case 4: {
                    return IndexSubTableFormat4.Builder.createBuilder(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
                }
                case 5: {
                    return IndexSubTableFormat5.Builder.createBuilder(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid Index SubTable Foramt %d%n", indexFormat));
        }

        protected Builder(int dataSize, int indexFormat) {
            super(dataSize);
            this.indexFormat = indexFormat;
        }

        protected Builder(int indexFormat, int imageFormat, int imageDataOffset, int dataSize) {
            this(dataSize, indexFormat);
            this.imageFormat = imageFormat;
            this.imageDataOffset = imageDataOffset;
        }

        protected Builder(WritableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
            super(data);
            this.firstGlyphIndex = firstGlyphIndex;
            this.lastGlyphIndex = lastGlyphIndex;
            this.initialize(data);
        }

        protected Builder(ReadableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
            super(data);
            this.firstGlyphIndex = firstGlyphIndex;
            this.lastGlyphIndex = lastGlyphIndex;
            this.initialize(data);
        }

        private void initialize(ReadableFontData data) {
            this.indexFormat = data.readUShort(EblcTable.Offset.indexSubHeader_indexFormat.offset);
            this.imageFormat = data.readUShort(EblcTable.Offset.indexSubHeader_imageFormat.offset);
            this.imageDataOffset = data.readULongAsInt(EblcTable.Offset.indexSubHeader_imageDataOffset.offset);
        }

        protected void revert() {
            this.setModelChanged(false);
            this.initialize(this.internalReadData());
        }

        public int indexFormat() {
            return this.indexFormat;
        }

        public int firstGlyphIndex() {
            return this.firstGlyphIndex;
        }

        public void setFirstGlyphIndex(int firstGlyphIndex) {
            this.firstGlyphIndex = firstGlyphIndex;
        }

        public int lastGlyphIndex() {
            return this.lastGlyphIndex;
        }

        public void setLastGlyphIndex(int lastGlyphIndex) {
            this.lastGlyphIndex = lastGlyphIndex;
        }

        public int imageFormat() {
            return this.imageFormat;
        }

        public void setImageFormat(int imageFormat) {
            this.imageFormat = imageFormat;
        }

        public int imageDataOffset() {
            return this.imageDataOffset;
        }

        public void setImageDataOffset(int offset) {
            this.imageDataOffset = offset;
        }

        public abstract int numGlyphs();

        public BitmapGlyphInfo glyphInfo(int glyphId) {
            return new BitmapGlyphInfo(glyphId, this.imageDataOffset(), this.glyphStartOffset(glyphId), this.glyphLength(glyphId), this.imageFormat());
        }

        public final int glyphOffset(int glyphId) {
            return this.imageDataOffset() + this.glyphStartOffset(glyphId);
        }

        public abstract int glyphStartOffset(int var1);

        public abstract int glyphLength(int var1);

        protected int checkGlyphRange(int glyphId) {
            return IndexSubTable.checkGlyphRange(glyphId, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        protected int serializeIndexSubHeader(WritableFontData data) {
            int size = data.writeUShort(EblcTable.Offset.indexSubHeader_indexFormat.offset, this.indexFormat);
            size += data.writeUShort(EblcTable.Offset.indexSubHeader_imageFormat.offset, this.imageFormat);
            return size += data.writeULong(EblcTable.Offset.indexSubHeader_imageDataOffset.offset, this.imageDataOffset);
        }

        abstract Iterator<BitmapGlyphInfo> iterator();

        @Override
        protected T subBuildTable(ReadableFontData data) {
            return null;
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return 0;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return false;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            return 0;
        }

        public String toString() {
            String s = "IndexSubTable: [0x" + Integer.toHexString(this.firstGlyphIndex()) + " : Ox" + Integer.toHexString(this.lastGlyphIndex()) + "], format = " + this.indexFormat + ", image format = " + this.imageFormat() + ", imageOff = 0x" + Integer.toHexString(this.imageDataOffset()) + "\n";
            return s;
        }
    }

    public static final class Format {
        public static final int FORMAT_1 = 1;
        public static final int FORMAT_2 = 2;
        public static final int FORMAT_3 = 3;
        public static final int FORMAT_4 = 4;
        public static final int FORMAT_5 = 5;
    }
}

