/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.opentype.component;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.SubTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;
import java.util.HashMap;
import java.util.Map;

public abstract class HeaderTable
extends SubTable {
    protected static final int FIELD_SIZE = 2;
    protected boolean dataIsCanonical = false;
    protected int base = 0;

    protected HeaderTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data);
        this.base = base;
        this.dataIsCanonical = dataIsCanonical;
    }

    public int getField(int index) {
        return this.data.readUShort(this.base + index * 2);
    }

    public int headerSize() {
        return 2 * this.fieldCount();
    }

    public abstract int fieldCount();

    public static abstract class Builder<T extends HeaderTable>
    extends VisibleSubTable.Builder<T> {
        private Map<Integer, Integer> map = new HashMap<Integer, Integer>();
        protected boolean dataIsCanonical = false;

        protected Builder() {
            this.initFields();
        }

        protected Builder(ReadableFontData data) {
            super(data);
            this.initFields();
        }

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data);
            this.dataIsCanonical = dataIsCanonical;
            this.initFields();
        }

        protected Builder(T table) {
            this.initFields();
            for (int i = 0; i < ((HeaderTable)table).fieldCount(); ++i) {
                this.map.put(i, ((HeaderTable)table).getField(i));
            }
        }

        protected int setField(int index, int value) {
            return this.map.put(index, value);
        }

        protected int getField(int index) {
            return this.map.get(index);
        }

        protected abstract void initFields();

        protected abstract int fieldCount();

        public int headerSize() {
            return 2 * this.fieldCount();
        }

        @Override
        public int subDataSizeToSerialize() {
            return this.headerSize();
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
                newData.writeUShort(entry.getKey() * 2, entry.getValue());
            }
            return this.headerSize();
        }

        @Override
        public void subDataSet() {
            this.map = new HashMap<Integer, Integer>();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }
    }
}

