/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel;

import java.lang.reflect.Method;

public final class Version {
    private static String AGPL = " ";
    private static Version version = null;
    private static String iText = "iText\u00ae";
    private static String release = "7.5.6";
    private static String cfca = "iText\u00ae";
    private String iTextVersion = cfca + " " + release + " \u00a92016-2019";
    private String key = null;
    private boolean expired;
    private static final String TRIAL = "trial";
    private static final String EXPIRED = "expired";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Version getInstance() {
        if (version != null) return version;
        Class<Version> clazz = Version.class;
        synchronized (Version.class) {
            Version temp = version;
            if (temp != null) return version;
            version = temp = new Version();
            try {
                String licenseeInfoMethodName = "getLicenseeInfo";
                Class<?> klass = Version.getLicenseKeyClass();
                if (klass != null) {
                    Method m = klass.getMethod(licenseeInfoMethodName, new Class[0]);
                    String[] info = (String[])m.invoke(klass.newInstance(), null);
                    if (info[3] != null && info[3].trim().length() > 0) {
                        Version.version.key = info[3];
                    } else {
                        Version.version.key = "Trial version ";
                        Version.version.key = info[5] == null ? Version.version.key + "unauthorised" : Version.version.key + info[5];
                    }
                    if (info.length > 6 && info[6] != null && info[6].trim().length() > 0 && !release.startsWith(info[6])) {
                        throw new IllegalArgumentException("Your license key version doesn't match the iText version.");
                    }
                    if (info[4] != null && info[4].trim().length() > 0) {
                        Version.version.iTextVersion = info[4];
                    } else if (info[2] != null && info[2].trim().length() > 0) {
                        version.addLicensedPostfix(info[2]);
                    } else if (info[0] != null && info[0].trim().length() > 0) {
                        version.addLicensedPostfix(info[0]);
                    } else {
                        version.addAGPLPostfix(null);
                    }
                } else {
                    version.addAGPLPostfix(null);
                }
            }
            catch (IllegalArgumentException iae) {
                version.addAGPLPostfix(iae.getCause());
            }
            catch (Exception e) {
                version.addAGPLPostfix(e.getCause());
            }
            return version;
        }
    }

    public static boolean isAGPLVersion() {
        return Version.getInstance().getVersion().indexOf(AGPL) > 0;
    }

    public static boolean isExpired() {
        return Version.getInstance().expired;
    }

    public String getProduct() {
        return iText;
    }

    public String getRelease() {
        return release;
    }

    public String getVersion() {
        return this.iTextVersion;
    }

    public String getKey() {
        return this.key;
    }

    private void addLicensedPostfix(String ownerName) {
        this.iTextVersion = this.iTextVersion + " (" + ownerName;
        this.iTextVersion = !this.key.toLowerCase().startsWith(TRIAL) ? this.iTextVersion + "; licensed version)" : this.iTextVersion + "; " + this.key + ")";
    }

    private void addAGPLPostfix(Throwable cause) {
        this.iTextVersion = this.iTextVersion + AGPL;
        if (cause != null && cause.getMessage() != null && cause.getMessage().contains(EXPIRED)) {
            this.expired = true;
        }
    }

    private static Class<?> getLicenseKeyClass() throws ClassNotFoundException {
        String licenseKeyClassFullName = "cfca.sadk.com.itextpdf.licensekey.LicenseKey";
        return Class.forName(licenseKeyClassFullName);
    }
}

