/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.font;

import cfca.sadk.com.itextpdf.io.font.CidFont;
import cfca.sadk.com.itextpdf.io.font.FontProgram;
import cfca.sadk.com.itextpdf.io.font.FontProgramFactory;
import cfca.sadk.com.itextpdf.io.font.TrueTypeFont;
import cfca.sadk.com.itextpdf.io.font.Type1Font;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.font.PdfTrueTypeFont;
import cfca.sadk.com.itextpdf.kernel.font.PdfType0Font;
import cfca.sadk.com.itextpdf.kernel.font.PdfType1Font;
import cfca.sadk.com.itextpdf.kernel.font.PdfType3Font;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import java.io.IOException;
import java.util.Set;

public final class PdfFontFactory {
    private static String DEFAULT_ENCODING = "";
    private static boolean DEFAULT_EMBEDDING = false;
    private static boolean DEFAULT_CACHED = false;

    public static PdfFont createFont() throws IOException {
        return PdfFontFactory.createFont("Helvetica", DEFAULT_ENCODING);
    }

    public static PdfFont createFont(PdfDictionary fontDictionary) {
        PdfFont font = null;
        if (null == font) {
            if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type1, false)) {
                font = new PdfType1Font(fontDictionary);
            } else if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type0, false)) {
                font = new PdfType0Font(fontDictionary);
            } else if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.TrueType, false)) {
                font = new PdfTrueTypeFont(fontDictionary);
            } else if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type3, false)) {
                font = new PdfType3Font(fontDictionary);
            } else {
                throw new PdfException("Dictionary doesn't have supported font data.");
            }
        }
        return font;
    }

    public static PdfFont createFont(String fontProgram) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING);
    }

    public static PdfFont createFont(String fontProgram, String encoding) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createTtcFont(byte[] ttc, int ttcIndex, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont(ttc, ttcIndex, cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createTtcFont(String ttc, int ttcIndex, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont(ttc, ttcIndex, cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createFont(String fontProgram, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING, embedded);
    }

    public static PdfFont createFont(String fontProgram, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, embedded, DEFAULT_CACHED);
    }

    public static PdfFont createFont(String fontProgram, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fp = FontProgramFactory.createFont(fontProgram, cached);
        return PdfFontFactory.createFont(fp, encoding, embedded);
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding, boolean embedded) throws IOException {
        if (fontProgram == null) {
            return null;
        }
        if (fontProgram instanceof Type1Font) {
            return new PdfType1Font((Type1Font)fontProgram, encoding, embedded);
        }
        if (fontProgram instanceof TrueTypeFont) {
            if ("Identity-H".equals(encoding) || "Identity-V".equals(encoding)) {
                return new PdfType0Font((TrueTypeFont)fontProgram, encoding);
            }
            return new PdfTrueTypeFont((TrueTypeFont)fontProgram, encoding, embedded);
        }
        if (fontProgram instanceof CidFont) {
            if (((CidFont)fontProgram).compatibleWith(encoding)) {
                return new PdfType0Font((CidFont)fontProgram, encoding);
            }
            return null;
        }
        return null;
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(FontProgram fontProgram) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING);
    }

    public static PdfFont createFont(byte[] fontProgram, String encoding) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(byte[] fontProgram, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, null, embedded);
    }

    public static PdfFont createFont(byte[] fontProgram, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, embedded, DEFAULT_CACHED);
    }

    public static PdfFont createFont(byte[] fontProgram, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fp = FontProgramFactory.createFont(fontProgram, cached);
        return PdfFontFactory.createFont(fp, encoding, embedded);
    }

    public static PdfType3Font createType3Font(PdfDocument document, boolean colorized) throws IOException {
        return new PdfType3Font(document, colorized);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded, int style, boolean cached) throws IOException {
        FontProgram fp = FontProgramFactory.createRegisteredFont(fontName, style, cached);
        return PdfFontFactory.createFont(fp, encoding, embedded);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded, boolean cached) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, embedded, -1, cached);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, embedded, -1);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding, boolean embedded, int style) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, embedded, style, DEFAULT_CACHED);
    }

    public static PdfFont createRegisteredFont(String fontName, String encoding) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, encoding, false, -1);
    }

    public static PdfFont createRegisteredFont(String fontName) throws IOException {
        return PdfFontFactory.createRegisteredFont(fontName, null, false, -1);
    }

    public static void registerFamily(String familyName, String fullName, String path) {
        FontProgramFactory.registerFontFamily(familyName, fullName, path);
    }

    public static void register(String path) {
        PdfFontFactory.register(path, null);
    }

    public static void register(String path, String alias) {
        FontProgramFactory.registerFont(path, alias);
    }

    public static int registerDirectory(String dirPath) {
        return FontProgramFactory.registerFontDirectory(dirPath);
    }

    public static int registerSystemDirectories() {
        return FontProgramFactory.registerSystemFontDirectories();
    }

    public static Set<String> getRegisteredFonts() {
        return FontProgramFactory.getRegisteredFonts();
    }

    public static Set<String> getRegisteredFamilies() {
        return FontProgramFactory.getRegisteredFontFamilies();
    }

    public static boolean isRegistered(String fontName) {
        return FontProgramFactory.isRegisteredFont(fontName);
    }

    @Deprecated
    protected static boolean checkFontDictionary(PdfDictionary fontDic, PdfName fontType, boolean isException) {
        if (fontDic == null || fontDic.get(PdfName.Subtype) == null || !fontDic.get(PdfName.Subtype).equals(fontType)) {
            if (isException) {
                throw new PdfException("Dictionary doesn't have {0} font data.").setMessageParams(fontType.getValue());
            }
            return false;
        }
        return true;
    }
}

