/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.filters;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.ASCII85DecodeFilter;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.ASCIIHexDecodeFilter;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.CCITTFaxDecodeFilter;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.DoNothingFilter;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.FlateDecodeFilter;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.IFilterHandler;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.LZWDecodeFilter;
import cfca.sadk.com.itextpdf.kernel.pdf.filters.RunLengthDecodeFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class FilterHandlers {
    private static final Map<PdfName, IFilterHandler> defaults;

    public static Map<PdfName, IFilterHandler> getDefaultFilterHandlers() {
        return defaults;
    }

    static {
        HashMap<PdfName, IFilterHandler> map = new HashMap<PdfName, IFilterHandler>();
        map.put(PdfName.FlateDecode, new FlateDecodeFilter());
        map.put(PdfName.Fl, new FlateDecodeFilter());
        map.put(PdfName.ASCIIHexDecode, new ASCIIHexDecodeFilter());
        map.put(PdfName.AHx, new ASCIIHexDecodeFilter());
        map.put(PdfName.ASCII85Decode, new ASCII85DecodeFilter());
        map.put(PdfName.A85, new ASCII85DecodeFilter());
        map.put(PdfName.LZWDecode, new LZWDecodeFilter());
        map.put(PdfName.CCITTFaxDecode, new CCITTFaxDecodeFilter());
        map.put(PdfName.Crypt, new DoNothingFilter());
        map.put(PdfName.RunLengthDecode, new RunLengthDecodeFilter());
        defaults = Collections.unmodifiableMap(map);
    }
}

