/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.border;

import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.geom.Point;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.layout.border.Border;

public class RoundDotsBorder
extends Border {
    private static final float GAP_MODIFIER = 2.5f;

    public RoundDotsBorder(float width) {
        super(width);
    }

    public RoundDotsBorder(Color color, float width) {
        super(color, width);
    }

    public RoundDotsBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap);
        float widthHalf = this.width / 2.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                y1 += widthHalf;
                y2 += widthHalf;
                break;
            }
            case RIGHT: {
                x1 += widthHalf;
                x2 += widthHalf;
                break;
            }
            case BOTTOM: {
                y1 -= widthHalf;
                y2 -= widthHalf;
                break;
            }
            case LEFT: {
                x1 -= widthHalf;
                x2 -= widthHalf;
            }
        }
        canvas.saveState().setStrokeColor(this.transparentColor.getColor()).setLineWidth(this.width).setLineCapStyle(1);
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f).moveTo(x1, y1).lineTo(x2, y2).stroke().restoreState();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap);
        boolean isHorizontal = false;
        if (Math.abs(y2 - y1) < 5.0E-4f) {
            isHorizontal = true;
        }
        if (isHorizontal) {
            x2 -= this.width;
        }
        canvas.setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width);
        canvas.setLineCapStyle(1);
        canvas.setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f).moveTo(x1, y1).lineTo(x2, y2).stroke();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float outerRadius, Border.Side side, float borderWidthBefore, float borderWidthAfter) {
        float curv = 0.447f;
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap);
        float x0 = x1;
        float y0 = y1;
        float x3 = x2;
        float y3 = y2;
        float innerRadiusBefore = Math.max(0.0f, outerRadius - borderWidthBefore);
        float innerRadius = Math.max(0.0f, outerRadius - this.width);
        float innerRadiusAfter = Math.max(0.0f, outerRadius - borderWidthAfter);
        float widthHalf = this.width / 2.0f;
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width).setLineCapStyle(1).setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f);
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2, side);
        switch (borderSide) {
            case TOP: {
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 - borderWidthBefore, y1 + this.width), new Point(x1, y1), new Point(x0 -= borderWidthBefore / 2.0f, y0 -= innerRadius), new Point(x0 + 10.0f, y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 + borderWidthAfter, y2 + this.width), new Point(x2, y2), new Point(x3 += borderWidthAfter / 2.0f, y3 -= innerRadius), new Point(x3 - 10.0f, y3));
                if (clipPoint1.x > clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 - borderWidthBefore, y1 + this.width), clipPoint1, clipPoint2, new Point(x2 + borderWidthAfter, y2 + this.width));
                    canvas.moveTo(x1 - borderWidthBefore, y1 + this.width).lineTo(clipPoint.x, clipPoint.y).lineTo(x2 + borderWidthAfter, y2 + this.width).lineTo(x1 - borderWidthBefore, y1 + this.width);
                } else {
                    canvas.moveTo(x1 - borderWidthBefore, y1 + this.width).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo(x2 + borderWidthAfter, y2 + this.width).lineTo(x1 - borderWidthBefore, y1 + this.width);
                }
                canvas.clip().newPath();
                canvas.moveTo(x0, y0).curveTo(x0, y0 + innerRadius * curv, (x1 += innerRadiusBefore) - innerRadiusBefore * curv, y1 += widthHalf, x1, y1).lineTo(x2 -= innerRadiusAfter, y2 += widthHalf).curveTo(x2 + innerRadiusAfter * curv, y2, x3, y3 + innerRadius * curv, x3, y3);
                break;
            }
            case RIGHT: {
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 + this.width, y1 + borderWidthBefore), new Point(x1, y1), new Point(x0 -= innerRadius, y0 += borderWidthBefore / 2.0f), new Point(x0, y0 - 10.0f));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 + this.width, y2 - borderWidthAfter), new Point(x2, y2), new Point(x3 -= innerRadius, y3 -= borderWidthAfter), new Point(x3, y3 - 10.0f));
                if (clipPoint1.y < clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 + this.width, y1 + borderWidthBefore), clipPoint1, clipPoint2, new Point(x2 + this.width, y2 - borderWidthAfter));
                    canvas.moveTo(x1 + this.width, y1 + borderWidthBefore).lineTo(clipPoint.x, clipPoint.y).lineTo(x2 + this.width, y2 - borderWidthAfter).lineTo(x1 + this.width, y1 + borderWidthBefore).clip().newPath();
                } else {
                    canvas.moveTo(x1 + this.width, y1 + borderWidthBefore).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo(x2 + this.width, y2 - borderWidthAfter).lineTo(x1 + this.width, y1 + borderWidthBefore).clip().newPath();
                }
                canvas.clip().newPath();
                canvas.moveTo(x0, y0).curveTo(x0 + innerRadius * curv, y0, x1 += widthHalf, (y1 -= innerRadiusBefore) + innerRadiusBefore * curv, x1, y1).lineTo(x2 += widthHalf, y2 += innerRadiusAfter).curveTo(x2, y2 - innerRadiusAfter * curv, x3 + innerRadius * curv, y3, x3, y3);
                break;
            }
            case BOTTOM: {
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 + borderWidthBefore, y1 - this.width), new Point(x1, y1), new Point(x0 += borderWidthBefore / 2.0f, y0 += innerRadius), new Point(x0 - 10.0f, y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 - borderWidthAfter, y2 - this.width), new Point(x2, y2), new Point(x3 -= borderWidthAfter / 2.0f, y3 += innerRadius), new Point(x3 + 10.0f, y3));
                if (clipPoint1.x < clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 + borderWidthBefore, y1 - this.width), clipPoint1, clipPoint2, new Point(x2 - borderWidthAfter, y2 - this.width));
                    canvas.moveTo(x1 + borderWidthBefore, y1 - this.width).lineTo(clipPoint.x, clipPoint.y).lineTo(x2 - borderWidthAfter, y2 - this.width).lineTo(x1 + borderWidthBefore, y1 - this.width);
                } else {
                    canvas.moveTo(x1 + borderWidthBefore, y1 - this.width).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo(x2 - borderWidthAfter, y2 - this.width).lineTo(x1 + borderWidthBefore, y1 - this.width);
                }
                canvas.clip().newPath();
                canvas.moveTo(x0, y0).curveTo(x0, y0 - innerRadius * curv, (x1 -= innerRadiusBefore) + innerRadiusBefore * curv, y1 -= widthHalf, x1, y1).lineTo(x2 += innerRadiusAfter, y2 -= widthHalf).curveTo(x2 - innerRadiusAfter * curv, y2, x3, y3 - innerRadius * curv, x3, y3);
                break;
            }
            case LEFT: {
                Point clipPoint1 = this.getIntersectionPoint(new Point(x1 - this.width, y1 - borderWidthBefore), new Point(x1, y1), new Point(x0 += innerRadius, y0 -= borderWidthBefore / 2.0f), new Point(x0, y0 + 10.0f));
                Point clipPoint2 = this.getIntersectionPoint(new Point(x2 - this.width, y2 + borderWidthAfter), new Point(x2, y2), new Point(x3 += innerRadius, y3 += borderWidthAfter), new Point(x3, y3 + 10.0f));
                if (clipPoint1.y > clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point(x1 - this.width, y1 - borderWidthBefore), clipPoint1, clipPoint2, new Point(x2 - this.width, y2 + borderWidthAfter));
                    canvas.moveTo(x1 - this.width, y1 - borderWidthBefore).lineTo(clipPoint.x, clipPoint.y).lineTo(x2 - this.width, y2 + borderWidthAfter).lineTo(x1 - this.width, y1 - borderWidthBefore);
                } else {
                    canvas.moveTo(x1 - this.width, y1 - borderWidthBefore).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo(x2 - this.width, y2 + borderWidthAfter).lineTo(x1 - this.width, y1 - borderWidthBefore);
                }
                canvas.clip().newPath();
                canvas.moveTo(x0, y0).curveTo(x0 - innerRadius * curv, y0, x1 -= widthHalf, (y1 += innerRadiusBefore) - innerRadiusBefore * curv, x1, y1).lineTo(x2 -= widthHalf, y2 -= innerRadiusAfter).curveTo(x2, y2 + innerRadiusAfter * curv, x3 - innerRadius * curv, y3, x3, y3);
            }
        }
        canvas.stroke().restoreState();
    }

    protected float getDotsGap(double distance, float initialGap) {
        double gapsNum = Math.ceil(distance / (double)initialGap);
        if (gapsNum == 0.0) {
            return initialGap;
        }
        return (float)(distance / gapsNum);
    }
}

