/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.PdfSigFieldLockDictionary;
import cfca.sadk.com.itextpdf.forms.fields.PdfButtonFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfSignatureFormField;
import cfca.sadk.com.itextpdf.io.source.ByteBuffer;
import cfca.sadk.com.itextpdf.io.source.IRandomAccessSource;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.io.source.RandomAccessSourceFactory;
import cfca.sadk.com.itextpdf.io.util.DateTimeUtil;
import cfca.sadk.com.itextpdf.io.util.FileUtil;
import cfca.sadk.com.itextpdf.io.util.StreamUtil;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDate;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfLiteral;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfOutputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfVersion;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.WriterProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.action.PdfAction;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import cfca.sadk.com.itextpdf.signatures.DigestAlgorithms;
import cfca.sadk.com.itextpdf.signatures.ICrlClient;
import cfca.sadk.com.itextpdf.signatures.IExternalDigest;
import cfca.sadk.com.itextpdf.signatures.IExternalSignature;
import cfca.sadk.com.itextpdf.signatures.IExternalSignatureContainer;
import cfca.sadk.com.itextpdf.signatures.IOcspClient;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.com.itextpdf.signatures.PdfPKCS7;
import cfca.sadk.com.itextpdf.signatures.PdfSignature;
import cfca.sadk.com.itextpdf.signatures.PdfSignatureAppearance;
import cfca.sadk.com.itextpdf.signatures.SignUtils;
import cfca.sadk.com.itextpdf.signatures.SignaturePolicyInfo;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.org.bouncycastle.asn1.esf.SignaturePolicyIdentifier;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.Constants;
import cfca.sadk.seal.base.util.CoordinateUtil;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.system.Mechanisms;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PdfSigner {
    private static Logger businessLog = LoggerFactory.getLogger(PdfSigner.class);
    private static final String PRE_SEAL_SADK_VERSION = "5.5";
    public static final int NOT_CERTIFIED = 0;
    public static final int CERTIFIED_NO_CHANGES_ALLOWED = 1;
    public static final int CERTIFIED_FORM_FILLING = 2;
    public static final int CERTIFIED_FORM_FILLING_AND_ANNOTATIONS = 3;
    protected int certificationLevel = 0;
    protected String fieldName;
    protected RandomAccessFile raf;
    protected byte[] bout;
    protected long[] range;
    protected PdfDocument document;
    protected PdfSignature cryptoDictionary;
    protected ISignatureEvent signatureEvent;
    protected OutputStream originalOS;
    protected ByteArrayOutputStream temporaryOS;
    protected File tempFile;
    protected Map<PdfName, PdfLiteral> exclusionLocations;
    protected boolean preClosed = false;
    protected PdfSigFieldLockDictionary fieldLock;
    protected PdfSignatureAppearance appearance;
    protected Calendar signDate;
    protected boolean closed;
    private String javaScript;
    private int signatureVersion;
    private String encryptionAlgorithm;
    private boolean signatureOnce = false;
    private HashSet<String> sigOnceFieldNames = new HashSet();
    private PdfAcroForm acroForm;

    public PdfSigner(PdfReader reader, OutputStream outputStream, boolean append, boolean partailParse) throws IOException {
        this(reader, outputStream, null, append, partailParse);
    }

    public PdfSigner(PdfReader reader, OutputStream outputStream, String path, boolean append, boolean partialParse) throws IOException {
        StampingProperties properties = new StampingProperties().preserveEncryption();
        if (append) {
            properties.useAppendMode();
        }
        if (path == null || reader.isUseMemery()) {
            this.temporaryOS = new ByteArrayOutputStream();
            this.document = new PdfDocument(reader, new PdfWriter(this.temporaryOS), properties, partialParse);
        } else {
            this.tempFile = FileUtil.createTempFile(path);
            this.document = new PdfDocument(reader, new PdfWriter(FileUtil.getFileOutputStream(this.tempFile)), properties, partialParse);
        }
        this.acroForm = PdfAcroForm.getAcroForm(this.document, true);
        this.originalOS = outputStream;
        this.signDate = DateTimeUtil.getCurrentTimeCalendar();
        this.fieldName = this.getNewSigFieldName();
        this.closed = false;
    }

    public PdfSigner(PdfReader reader, OutputStream outputStream, WriterProperties writerProperties, String path, boolean append, boolean partialParse) throws IOException {
        StampingProperties properties = new StampingProperties().preserveEncryption();
        if (append) {
            properties.useAppendMode();
        }
        if (path == null) {
            this.temporaryOS = new ByteArrayOutputStream();
            this.document = new PdfDocument(reader, new PdfWriter(this.temporaryOS, writerProperties), properties, partialParse);
        } else {
            this.tempFile = FileUtil.createTempFile(path);
            this.document = new PdfDocument(reader, new PdfWriter(FileUtil.getFileOutputStream(this.tempFile), writerProperties), properties, partialParse);
        }
        this.acroForm = PdfAcroForm.getAcroForm(this.document, true);
        this.originalOS = outputStream;
        this.signDate = DateTimeUtil.getCurrentTimeCalendar();
        this.fieldName = this.getNewSigFieldName();
        this.closed = false;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
        this.appearance.setSignDate(signDate);
    }

    public PdfSignatureAppearance getSignatureAppearance() {
        return this.appearance;
    }

    public int getCertificationLevel() {
        return this.certificationLevel;
    }

    public void setCertificationLevel(int certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PdfSignature getSignatureDictionary() {
        return this.cryptoDictionary;
    }

    public ISignatureEvent getSignatureEvent() {
        return this.signatureEvent;
    }

    public void setSignatureEvent(ISignatureEvent signatureEvent) {
        this.signatureEvent = signatureEvent;
    }

    public String getNewSigFieldName() {
        PdfAcroForm acroForm = PdfAcroForm.getAcroForm(this.document, true);
        String name = "Signature";
        int step = 1;
        while (acroForm.getField(name + step) != null) {
            ++step;
        }
        return name + step;
    }

    public void setFieldName(String fieldName) {
        if (fieldName != null) {
            if (fieldName.indexOf(46) >= 0) {
                throw new IllegalArgumentException("Field names cannot contain a dot.");
            }
            PdfAcroForm acroForm = PdfAcroForm.getAcroForm(this.document, true);
            if (acroForm.getField(fieldName) != null) {
                PdfFormField field = acroForm.getField(fieldName);
                if (!PdfName.Sig.equals(field.getFormType())) {
                    throw new IllegalArgumentException("Field type is not a signature field type.");
                }
                if (field.getValue() != null && !field.getValue().toString().contains(PRE_SEAL_SADK_VERSION)) {
                    throw new IllegalArgumentException("Field has been already signed.");
                }
                this.appearance.setFieldName(fieldName);
                List<PdfWidgetAnnotation> widgets = field.getWidgets();
                if (widgets.size() > 0) {
                    PdfWidgetAnnotation widget = widgets.get(0);
                    Rectangle tmpRect = this.getWidgetRectangle(widget);
                    PdfPage page = widget.getPage();
                    tmpRect = CoordinateUtil.rectangleToUntransformedCoordinate(page, tmpRect);
                    this.appearance.setPageRect(tmpRect);
                    this.appearance.setPageNumber(this.getWidgetPageNumber(widget));
                }
            }
            this.fieldName = fieldName;
        }
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    protected void setDocument(PdfDocument document) {
        this.document = document;
    }

    public void setOriginalOutputStream(OutputStream originalOS) {
        this.originalOS = originalOS;
    }

    public PdfSigFieldLockDictionary getFieldLockDict() {
        return this.fieldLock;
    }

    public void setFieldLockDict(PdfSigFieldLockDictionary fieldLock) {
        this.fieldLock = fieldLock;
    }

    public void signDetached(IExternalDigest externalDigest, IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype) throws IOException, GeneralSecurityException {
        this.signDetached(externalDigest, externalSignature, chain, crlList, ocspClient, tsaClient, estimatedSize, sigtype, (SignaturePolicyIdentifier)null);
    }

    public void signDetached(IExternalDigest externalDigest, IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, SignaturePolicyInfo signaturePolicy) throws IOException, GeneralSecurityException {
        this.signDetached(externalDigest, externalSignature, chain, crlList, ocspClient, tsaClient, estimatedSize, sigtype, signaturePolicy.toSignaturePolicyIdentifier());
    }

    public void signDetached(IExternalDigest externalDigest, IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, SignaturePolicyIdentifier signaturePolicy) throws IOException, GeneralSecurityException {
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        Collection<byte[]> crlBytes = null;
        int i = 0;
        while (crlBytes == null && i < chain.length) {
            crlBytes = this.processCrl(chain[i++], crlList);
        }
        if (estimatedSize == 0) {
            estimatedSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    estimatedSize += element.length + 10;
                }
            }
            if (ocspClient != null) {
                estimatedSize += 4192;
            }
            if (tsaClient != null) {
                estimatedSize += 4192;
            }
        }
        PdfSignatureAppearance appearance = this.getSignatureAppearance();
        appearance.setCertificate(chain[0]);
        if (sigtype == CryptoStandard.CADES) {
            this.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        PdfSignature dic = new PdfSignature(PdfName.Adobe_PPKLite, sigtype == CryptoStandard.CADES ? PdfName.ETSI_CAdES_DETACHED : PdfName.Adbe_pkcs7_detached);
        dic.setReason(appearance.getReason());
        dic.setLocation(appearance.getLocation());
        dic.setSignatureCreator(appearance.getSignatureCreator());
        dic.setContact(appearance.getContact());
        dic.setDate(new PdfDate(this.getSignDate()));
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, estimatedSize * 2 + 2);
        this.preClose(exc);
        String hashAlgorithm = externalSignature.getHashAlgorithm();
        PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
        if (signaturePolicy != null) {
            sgn.setSignaturePolicy(signaturePolicy);
        }
        InputStream data = this.getRangeStream();
        byte[] hash = DigestAlgorithms.digest(data, SignUtils.getMessageDigest(hashAlgorithm, externalDigest));
        byte[] ocsp = null;
        if (chain.length >= 2 && ocspClient != null) {
            ocsp = ocspClient.getEncoded((X509Certificate)chain[0], (X509Certificate)chain[1], null);
        }
        byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, ocsp, crlBytes, sigtype);
        byte[] extSignature = externalSignature.sign(sh);
        sgn.setExternalDigest(extSignature, null, externalSignature.getEncryptionAlgorithm());
        byte[] encodedSig = sgn.getEncodedPKCS7(hash, tsaClient, ocsp, crlBytes, sigtype);
        if (estimatedSize < encodedSig.length) {
            businessLog.error("Not enough space estimatedSize=" + estimatedSize + ",acturalSize=" + encodedSig.length);
            businessLog.error("encodedSig estimatedSize is wrong:" + Hex.toHexString((byte[])encodedSig));
            throw new IOException("Not enough space estimatedSize=" + estimatedSize + ",acturalSize=" + encodedSig.length);
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public void signExternalContainer(IExternalSignatureContainer externalSignatureContainer, int estimatedSize) throws GeneralSecurityException, IOException {
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        PdfSignature dic = new PdfSignature();
        PdfSignatureAppearance appearance = this.getSignatureAppearance();
        dic.setReason(appearance.getReason());
        dic.setLocation(appearance.getLocation());
        dic.setSignatureCreator(appearance.getSignatureCreator());
        dic.setContact(appearance.getContact());
        dic.setDate(new PdfDate(this.getSignDate()));
        if (externalSignatureContainer instanceof AbstractExternalP7Signer) {
            AbstractExternalP7Signer abstractExternalP7Signer = (AbstractExternalP7Signer)externalSignatureContainer;
            abstractExternalP7Signer.setSigningTime(this.getSignDate());
        }
        externalSignatureContainer.modifySigningDictionary((PdfDictionary)dic.getPdfObject());
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, estimatedSize * 2 + 2);
        String graphicmethod = MethodCostTimeUtil.recordStartTime("PdfSigner-preClose()");
        this.preClose(exc);
        MethodCostTimeUtil.recordEndTime(graphicmethod);
        PdfDictionary dic2 = new PdfDictionary();
        InputStream data = this.getRangeStream();
        try {
            byte[] encodedSig = externalSignatureContainer.sign(data);
            if (estimatedSize < encodedSig.length) {
                businessLog.error("Not enough space estimatedSize=" + estimatedSize + ",acturalSize=" + encodedSig.length);
                businessLog.error("encodedSig estimatedSize is wrong:" + Hex.toHexString((byte[])encodedSig));
                throw new IOException("Not enough space estimatedSize=" + estimatedSize + ",acturalSize=" + encodedSig.length);
            }
            byte[] paddedSig = new byte[estimatedSize];
            System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
            dic2.put(PdfName.Contents, new PdfString(paddedSig).setHexWriting(true));
        }
        catch (IOException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
        finally {
            this.close(dic2);
        }
        this.closed = true;
    }

    public void signExternalContainer(Mechanism mechanism, PdfDictionary sig, PdfStream normal) throws GeneralSecurityException, IOException {
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        PdfSignature dic = new PdfSignature();
        PdfSignatureAppearance appearance = this.getSignatureAppearance();
        dic.setReason(appearance.getReason());
        dic.setLocation(appearance.getLocation());
        dic.setSignatureCreator(appearance.getSignatureCreator());
        dic.setContact(appearance.getContact());
        dic.setDate(new PdfDate(this.getSignDate()));
        PdfDictionary signDic = (PdfDictionary)dic.getPdfObject();
        signDic.put(PdfName.Filter, PdfName.Adobe_PPKLite);
        if (Mechanisms.isSM2WithSM3((Mechanism)mechanism)) {
            signDic.put(PdfName.SubFilter, Constants.CFCA_SM2_FILTER);
        } else {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_detached);
        }
        this.cryptoDictionary = dic;
        String graphicmethod = MethodCostTimeUtil.recordStartTime("PdfSigner-preClose()");
        this.preClose(sig, normal);
        MethodCostTimeUtil.recordEndTime(graphicmethod);
        if (this.originalOS != null) {
            this.bout = this.temporaryOS.toByteArray();
            this.originalOS.write(this.bout, 0, this.bout.length);
            this.originalOS.close();
        }
        this.closed = true;
    }

    public void timestamp(ITSAClient tsa, String signatureName) throws IOException, GeneralSecurityException {
        byte[] tsToken;
        int n;
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        int contentEstimated = tsa.getTokenSizeEstimate();
        this.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL5);
        this.setFieldName(signatureName);
        PdfSignature dic = new PdfSignature(PdfName.Adobe_PPKLite, PdfName.ETSI_RFC3161);
        dic.put(PdfName.Type, PdfName.DocTimeStamp);
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, contentEstimated * 2 + 2);
        this.preClose(exc);
        InputStream data = this.getRangeStream();
        MessageDigest messageDigest = tsa.getMessageDigest();
        byte[] buf = new byte[4096];
        while ((n = data.read(buf)) > 0) {
            messageDigest.update(buf, 0, n);
        }
        byte[] tsImprint = messageDigest.digest();
        try {
            tsToken = tsa.getTimeStampToken(tsImprint);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        if (contentEstimated + 2 < tsToken.length) {
            businessLog.error("Not enough space estimatedSize=" + contentEstimated + 2 + ",acturalSize=" + tsToken.length);
            businessLog.error("TimeStampToken estimatedSize is wrong: " + Hex.toHexString((byte[])tsToken));
            throw new IOException("Not enough space estimatedSize=" + (contentEstimated + 2) + ",acturalSize=" + tsToken.length);
        }
        byte[] paddedSig = new byte[contentEstimated];
        System.arraycopy(tsToken, 0, paddedSig, 0, tsToken.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public static void signDeferred(PdfDocument document, String fieldName, OutputStream outs, IExternalSignatureContainer externalSignatureContainer) throws IOException, GeneralSecurityException {
        SignatureUtil signatureUtil = new SignatureUtil(document);
        PdfSignature signature = signatureUtil.getSignature(fieldName);
        if (signature == null) {
            throw new PdfException("There is no field in the document with such name: {0}.").setMessageParams(fieldName);
        }
        if (!signatureUtil.signatureCoversWholeDocument(fieldName)) {
            throw new PdfException("Signature with name {0} is not the last. It doesn't cover the whole document.").setMessageParams(fieldName);
        }
        PdfArray b = signature.getByteRange();
        long[] gaps = SignatureUtil.asLongArray(b);
        if (b.size() != 4 || gaps[0] != 0L) {
            throw new IllegalArgumentException("Single exclusion space supported");
        }
        IRandomAccessSource readerSource = document.getReader().getSafeFile().createSourceView();
        RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(readerSource, gaps));
        byte[] signedContent = externalSignatureContainer.sign(rg);
        int spaceAvailable = (int)(gaps[2] - gaps[1]) - 2;
        if ((spaceAvailable & 1) != 0) {
            throw new IllegalArgumentException("Gap is not a multiple of 2");
        }
        if ((spaceAvailable /= 2) < signedContent.length) {
            businessLog.error("spaceAvailable=" + spaceAvailable + ",signedContent length=" + signedContent.length);
            throw new PdfException("Available space is not enough for signature.");
        }
        StreamUtil.copyBytes(readerSource, 0L, gaps[1] + 1L, outs);
        ByteBuffer bb = new ByteBuffer(spaceAvailable * 2);
        for (byte bi : signedContent) {
            bb.appendHex(bi);
        }
        int remain = (spaceAvailable - signedContent.length) * 2;
        for (int k = 0; k < remain; ++k) {
            bb.append((byte)48);
        }
        byte[] bbArr = bb.toByteArray();
        outs.write(bbArr);
        StreamUtil.copyBytes(readerSource, gaps[2] - 1L, gaps[3] + 1L, outs);
    }

    protected Collection<byte[]> processCrl(Certificate cert, Collection<ICrlClient> crlList) {
        if (crlList == null) {
            return null;
        }
        ArrayList<byte[]> crlBytes = new ArrayList<byte[]>();
        for (ICrlClient cc : crlList) {
            Collection<byte[]> b;
            if (cc == null || (b = cc.getEncoded((X509Certificate)cert, null)) == null) continue;
            crlBytes.addAll(b);
        }
        if (crlBytes.size() == 0) {
            return null;
        }
        return crlBytes;
    }

    protected void addDeveloperExtension(PdfDeveloperExtension extension) {
        this.document.getCatalog().addDeveloperExtension(extension);
    }

    protected boolean isPreClosed() {
        return this.preClosed;
    }

    protected void preClose(Map<PdfName, Integer> exclusionSizes) throws IOException {
        boolean isSpecialSM2;
        if (this.preClosed) {
            throw new PdfException("Document has been already pre closed.");
        }
        this.appearance.setSignDate(this.signDate);
        this.preClosed = true;
        String name = this.getFieldName();
        SignatureUtil sgnUtil = new SignatureUtil(this.document);
        boolean fieldExist = sgnUtil.doesSignatureFieldExist(name);
        this.acroForm.setSignatureFlags(3);
        PdfSigFieldLockDictionary fieldLock = null;
        if (this.cryptoDictionary == null) {
            throw new PdfException("No crypto dictionary defined.");
        }
        ((PdfDictionary)this.cryptoDictionary.getPdfObject()).makeIndirect(this.document, null);
        boolean isSM2 = "SM2".equals(this.encryptionAlgorithm);
        this.appearance.setSM2(isSM2);
        boolean bl = isSpecialSM2 = 1 == this.signatureVersion && "SM2".equals(this.encryptionAlgorithm);
        if (fieldExist) {
            int n;
            PdfSignatureFormField sigField = (PdfSignatureFormField)this.acroForm.getField(this.fieldName);
            sigField.put(PdfName.V, (PdfObject)this.cryptoDictionary.getPdfObject());
            fieldLock = sigField.getSigFieldLockDictionary();
            if (fieldLock == null && this.fieldLock != null) {
                ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
                sigField.put(PdfName.Lock, (PdfObject)this.fieldLock.getPdfObject());
                fieldLock = this.fieldLock;
            }
            sigField.put(PdfName.P, (PdfObject)this.document.getPage(this.appearance.getPageNumber()).getPdfObject());
            if (isSpecialSM2) {
                sigField.put(PdfName.FT, PdfName.Btn);
                sigField.put(PdfName.Ff, new PdfNumber(PdfButtonFormField.FF_PUSH_BUTTON));
                PdfAction action = PdfAction.createJavaScript(this.javaScript);
                sigField.setAction(action);
                PdfWidgetAnnotation pdfWidgetAnnotation = sigField.getWidgets().get(0);
                PdfDictionary dictMk = ((PdfDictionary)pdfWidgetAnnotation.getPdfObject()).getAsDictionary(PdfName.MK);
                if (null != dictMk) {
                    dictMk.put(new PdfName("TP"), new PdfNumber(2));
                    dictMk.put(new PdfName("IF"), new PdfDictionary());
                    dictMk.put(PdfName.I, (PdfObject)this.appearance.getLayer2().getPdfObject());
                    sigField.put(PdfName.MK, dictMk);
                }
            }
            PdfObject obj = ((PdfDictionary)sigField.getPdfObject()).get(PdfName.F);
            boolean bl2 = false;
            if (obj != null && obj.isNumber()) {
                n = ((PdfNumber)obj).intValue();
            }
            int n2 = n | 0x80;
            sigField.put(PdfName.F, new PdfNumber(n2));
            PdfDictionary ap = new PdfDictionary();
            ap.put(PdfName.N, (PdfObject)this.appearance.getAppearance().getPdfObject());
            sigField.put(PdfName.AP, ap);
            sigField.setModified();
        } else if (!this.signatureOnce) {
            PdfPage pdfPage = this.document.getPage(this.appearance.getPageNumber());
            Rectangle pageRect0 = this.appearance.getPageRect();
            Rectangle rectangle = CoordinateUtil.rectangleToTransformedCoordinate(pdfPage, pageRect0);
            PdfWidgetAnnotation widget = new PdfWidgetAnnotation(rectangle);
            widget.setFlags(132);
            if (isSpecialSM2) {
                PdfButtonFormField btnField = PdfFormField.createPushButton(this.document, rectangle, name, name);
                PdfWidgetAnnotation pdfWidgetAnnot = btnField.getWidgets().get(0);
                PdfDictionary dictMk = ((PdfDictionary)pdfWidgetAnnot.getPdfObject()).getAsDictionary(PdfName.MK);
                dictMk.put(new PdfName("TP"), new PdfNumber(2));
                dictMk.put(new PdfName("IF"), new PdfDictionary());
                dictMk.put(PdfName.I, (PdfObject)this.appearance.getLayer2().getPdfObject());
                btnField.put(PdfName.MK, dictMk);
                btnField.put(PdfName.V, (PdfObject)this.cryptoDictionary.getPdfObject());
                PdfAction action = PdfAction.createJavaScript(this.javaScript);
                btnField.setAction(action);
                if (this.fieldLock != null) {
                    ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
                    btnField.put(PdfName.Lock, (PdfObject)this.fieldLock.getPdfObject());
                    fieldLock = this.fieldLock;
                }
                int pagen = this.appearance.getPageNumber();
                widget.setPage(this.document.getPage(pagen));
                PdfDictionary ap = widget.getAppearanceDictionary();
                if (ap == null) {
                    ap = new PdfDictionary();
                    widget.put(PdfName.AP, ap);
                }
                btnField.put(PdfName.F, new PdfNumber(132));
                btnField.put(PdfName.AP, widget.getAppearanceDictionary());
                ap.put(PdfName.N, (PdfObject)this.appearance.getAppearance().getPdfObject());
                this.acroForm.addField(btnField, this.document.getPage(pagen));
            } else {
                PdfSignatureFormField sigField = PdfFormField.createSignature(this.document);
                sigField.setFieldName(name);
                sigField.put(PdfName.V, (PdfObject)this.cryptoDictionary.getPdfObject());
                sigField.addKid(widget);
                if (this.fieldLock != null) {
                    ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
                    sigField.put(PdfName.Lock, (PdfObject)this.fieldLock.getPdfObject());
                    fieldLock = this.fieldLock;
                }
                int pagen = this.appearance.getPageNumber();
                widget.setPage(this.document.getPage(pagen));
                PdfDictionary ap = widget.getAppearanceDictionary();
                if (ap == null) {
                    ap = new PdfDictionary();
                    widget.put(PdfName.AP, ap);
                }
                ap.put(PdfName.N, (PdfObject)this.appearance.getAppearance().getPdfObject());
                sigField.put(PdfName.Type, PdfName.Annot);
                this.acroForm.addField(sigField, this.document.getPage(pagen));
            }
        }
        this.exclusionLocations = new HashMap<PdfName, PdfLiteral>();
        PdfLiteral lit = new PdfLiteral(80);
        this.exclusionLocations.put(PdfName.ByteRange, lit);
        this.cryptoDictionary.put(PdfName.ByteRange, lit);
        for (Map.Entry entry : exclusionSizes.entrySet()) {
            PdfName key = (PdfName)entry.getKey();
            lit = new PdfLiteral((Integer)entry.getValue());
            this.exclusionLocations.put(key, lit);
            this.cryptoDictionary.put(key, lit);
        }
        if (this.certificationLevel > 0) {
            this.addDocMDP(this.cryptoDictionary);
        }
        if (fieldLock != null) {
            this.addFieldMDP(this.cryptoDictionary, fieldLock);
        }
        if (this.signatureEvent != null) {
            this.signatureEvent.getSignatureDictionary(this.cryptoDictionary);
        }
        this.setSameSignatrue();
        if (this.certificationLevel > 0) {
            PdfDictionary docmdp = new PdfDictionary();
            docmdp.put(PdfName.DocMDP, (PdfObject)this.cryptoDictionary.getPdfObject());
            this.document.getCatalog().put(PdfName.Perms, docmdp);
            this.document.getCatalog().setModified();
        }
        if (((PdfDictionary)this.acroForm.getPdfObject()).isIndirect()) {
            this.acroForm.setModified();
        } else {
            this.document.getCatalog().setModified();
        }
        ((PdfDictionary)this.cryptoDictionary.getPdfObject()).flush(false);
        this.document.close();
        this.range = new long[this.exclusionLocations.size() * 2];
        long byteRangePosition = this.exclusionLocations.get(PdfName.ByteRange).getPosition();
        this.exclusionLocations.remove(PdfName.ByteRange);
        int idx = 1;
        for (PdfLiteral lit1 : this.exclusionLocations.values()) {
            long n = lit1.getPosition();
            this.range[idx++] = n;
            this.range[idx++] = (long)lit1.getBytesCount() + n;
        }
        Arrays.sort(this.range, 1, this.range.length - 1);
        for (int k = 3; k < this.range.length - 2; k += 2) {
            int n = k;
            this.range[n] = this.range[n] - this.range[k - 1];
        }
        if (this.tempFile == null) {
            this.bout = this.temporaryOS.toByteArray();
            this.range[this.range.length - 1] = (long)this.bout.length - this.range[this.range.length - 2];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfOutputStream os = new PdfOutputStream(bos);
            os.write(91);
            for (int k = 0; k < this.range.length; ++k) {
                ((PdfOutputStream)os.writeLong(this.range[k])).write(32);
            }
            os.write(93);
            System.arraycopy(bos.toByteArray(), 0, this.bout, (int)byteRangePosition, bos.size());
            os.close();
        } else {
            try {
                this.raf = FileUtil.getRandomAccessFile(this.tempFile);
                long len = this.raf.length();
                this.range[this.range.length - 1] = len - this.range[this.range.length - 2];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PdfOutputStream os = new PdfOutputStream(bos);
                os.write(91);
                for (int k = 0; k < this.range.length; ++k) {
                    ((PdfOutputStream)os.writeLong(this.range[k])).write(32);
                }
                os.write(93);
                this.raf.seek(byteRangePosition);
                this.raf.write(bos.toByteArray(), 0, bos.size());
                os.close();
            }
            catch (IOException e) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.tempFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    public void setAppearance(PdfSignatureAppearance appearance) {
        this.appearance = appearance;
    }

    protected InputStream getRangeStream() throws IOException {
        RandomAccessSourceFactory fac = new RandomAccessSourceFactory();
        return new RASInputStream(fac.createRanged(this.getUnderlyingSource(), this.range));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(PdfDictionary update) throws IOException {
        try {
            if (!this.preClosed) {
                throw new PdfException("Document must be preClosed.");
            }
            if (update.size() != 0) {
                ByteArrayOutputStream bous = new ByteArrayOutputStream();
                PdfOutputStream os = new PdfOutputStream(bous);
                for (PdfName key : update.keySet()) {
                    PdfObject obj = update.get(key);
                    PdfLiteral lit = this.exclusionLocations.get(key);
                    if (lit == null) {
                        throw new IllegalArgumentException("The key didn't reserve space in preclose");
                    }
                    bous.reset();
                    os.write(obj);
                    if (bous.size() > lit.getBytesCount()) {
                        throw new IllegalArgumentException("The key is too big");
                    }
                    if (this.tempFile == null) {
                        System.arraycopy(bous.toByteArray(), 0, this.bout, (int)lit.getPosition(), bous.size());
                        continue;
                    }
                    this.raf.seek(lit.getPosition());
                    this.raf.write(bous.toByteArray(), 0, bous.size());
                }
                if (update.size() != this.exclusionLocations.size()) {
                    throw new IllegalArgumentException("The update dictionary has less keys than required");
                }
                if (this.tempFile == null) {
                    this.originalOS.write(this.bout, 0, this.bout.length);
                } else if (this.originalOS != null) {
                    int r;
                    this.raf.seek(0L);
                    byte[] buf = new byte[8192];
                    for (long length = this.raf.length(); length > 0L; length -= (long)r) {
                        r = this.raf.read(buf, 0, (int)Math.min((long)buf.length, length));
                        if (r < 0) {
                            throw new EOFException("unexpected eof");
                        }
                        this.originalOS.write(buf, 0, r);
                    }
                }
            }
        }
        finally {
            if (this.tempFile != null) {
                this.raf.close();
                if (this.originalOS != null) {
                    this.tempFile.delete();
                }
            }
            if (this.originalOS != null) {
                try {
                    this.originalOS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected IRandomAccessSource getUnderlyingSource() throws IOException {
        RandomAccessSourceFactory fac = new RandomAccessSourceFactory();
        return this.raf == null ? fac.createSource(this.bout) : fac.createSource(this.raf);
    }

    protected void addDocMDP(PdfSignature crypto) {
        PdfDictionary reference = new PdfDictionary();
        PdfDictionary transformParams = new PdfDictionary();
        transformParams.put(PdfName.P, new PdfNumber(this.certificationLevel));
        transformParams.put(PdfName.V, new PdfName("1.2"));
        transformParams.put(PdfName.Type, PdfName.TransformParams);
        reference.put(PdfName.TransformMethod, PdfName.DocMDP);
        reference.put(PdfName.Type, PdfName.SigRef);
        reference.put(PdfName.TransformParams, transformParams);
        if (this.document.getPdfVersion().compareTo(PdfVersion.PDF_1_6) < 0) {
            reference.put(PdfName.DigestValue, new PdfString("aa"));
            PdfArray loc = new PdfArray();
            loc.add(new PdfNumber(0));
            loc.add(new PdfNumber(0));
            reference.put(PdfName.DigestLocation, loc);
            reference.put(PdfName.DigestMethod, PdfName.MD5);
        }
        reference.put(PdfName.Data, this.document.getTrailer().get(PdfName.Root));
        PdfArray types = new PdfArray();
        types.add(reference);
        crypto.put(PdfName.Reference, types);
    }

    protected void addFieldMDP(PdfSignature crypto, PdfSigFieldLockDictionary fieldLock) {
        PdfDictionary reference = new PdfDictionary();
        PdfDictionary transformParams = new PdfDictionary();
        transformParams.putAll((PdfDictionary)fieldLock.getPdfObject());
        transformParams.put(PdfName.Type, PdfName.TransformParams);
        transformParams.put(PdfName.V, new PdfName("1.2"));
        reference.put(PdfName.TransformMethod, PdfName.FieldMDP);
        reference.put(PdfName.Type, PdfName.SigRef);
        reference.put(PdfName.TransformParams, transformParams);
        reference.put(PdfName.DigestValue, new PdfString("aa"));
        PdfArray loc = new PdfArray();
        loc.add(new PdfNumber(0));
        loc.add(new PdfNumber(0));
        reference.put(PdfName.DigestLocation, loc);
        reference.put(PdfName.DigestMethod, PdfName.MD5);
        reference.put(PdfName.Data, this.document.getTrailer().get(PdfName.Root));
        PdfArray types = ((PdfDictionary)crypto.getPdfObject()).getAsArray(PdfName.Reference);
        if (types == null) {
            types = new PdfArray();
        }
        types.add(reference);
        crypto.put(PdfName.Reference, types);
    }

    protected Rectangle getWidgetRectangle(PdfWidgetAnnotation widget) {
        return widget.getRectangle().toRectangle();
    }

    protected int getWidgetPageNumber(PdfWidgetAnnotation widget) {
        int pageNumber = 0;
        PdfDictionary pageDict = ((PdfDictionary)widget.getPdfObject()).getAsDictionary(PdfName.P);
        if (pageDict != null) {
            pageNumber = this.document.getPageNumber(pageDict);
        } else {
            for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
                PdfPage page = this.document.getPage(i);
                if (page.isFlushed() || !page.containsAnnotation(widget)) continue;
                pageNumber = i;
                break;
            }
        }
        return pageNumber;
    }

    protected void preClose(PdfDictionary sig, PdfStream normal) throws IOException {
        if (this.preClosed) {
            throw new PdfException("Document has been already pre closed.");
        }
        this.preClosed = true;
        PdfAcroForm acroForm = PdfAcroForm.getAcroForm(this.document, true);
        SignatureUtil sgnUtil = new SignatureUtil(this.document);
        String name = this.getFieldName();
        boolean fieldExist = sgnUtil.doesSignatureFieldExist(name);
        acroForm.setSignatureFlags(3);
        PdfSigFieldLockDictionary fieldLock = null;
        if (this.cryptoDictionary == null) {
            throw new PdfException("No crypto dictionary defined.");
        }
        sig.makeIndirect(this.document);
        if (fieldExist) {
            throw new PdfException("preClose failed,signature can not reuse");
        }
        PdfWidgetAnnotation widget = new PdfWidgetAnnotation(this.appearance.getPageRect());
        widget.setFlags(132);
        PdfSignatureFormField sigField = PdfFormField.createSignature(this.document);
        sigField.setFieldName(name);
        sigField.put(PdfName.V, sig);
        sigField.addKid(widget);
        if (this.fieldLock != null) {
            ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
            sigField.put(PdfName.Lock, (PdfObject)this.fieldLock.getPdfObject());
            fieldLock = this.fieldLock;
        }
        int pagen = this.appearance.getPageNumber();
        widget.setPage(this.document.getPage(pagen));
        PdfDictionary ap = widget.getAppearanceDictionary();
        if (ap == null) {
            ap = new PdfDictionary();
            widget.put(PdfName.AP, ap);
        }
        ap.put(PdfName.N, normal);
        acroForm.addField(sigField, this.document.getPage(pagen));
        if (((PdfDictionary)acroForm.getPdfObject()).isIndirect()) {
            acroForm.setModified();
        } else {
            this.document.getCatalog().setModified();
        }
        if (this.certificationLevel > 0) {
            this.addDocMDP(this.cryptoDictionary);
        }
        if (fieldLock != null) {
            this.addFieldMDP(this.cryptoDictionary, fieldLock);
        }
        if (this.signatureEvent != null) {
            this.signatureEvent.getSignatureDictionary(this.cryptoDictionary);
        }
        if (this.certificationLevel > 0) {
            PdfDictionary docmdp = new PdfDictionary();
            docmdp.put(PdfName.DocMDP, (PdfObject)this.cryptoDictionary.getPdfObject());
            this.document.getCatalog().put(PdfName.Perms, docmdp);
            this.document.getCatalog().setModified();
        }
        sig.flush(false);
        this.document.close();
    }

    public void setJavaScript(String javaScript) {
        this.javaScript = javaScript;
    }

    public void setSignatureVersion(int signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setSignatureOnce(boolean signatureOnce) {
        this.signatureOnce = signatureOnce;
    }

    public void addAppearanceToDocument(PdfSignatureAppearance appearance, String fieldName) throws IOException {
        PdfPage pdfPage = this.document.getPage(appearance.getPageNumber());
        Rectangle pageRect0 = appearance.getPageRect();
        Rectangle pageRect = CoordinateUtil.rectangleToTransformedCoordinate(pdfPage, pageRect0);
        PdfWidgetAnnotation widget = new PdfWidgetAnnotation(pageRect);
        widget.setFlags(132);
        PdfSignatureFormField sigField = PdfFormField.createSignature(this.document);
        sigField.setFieldName(fieldName);
        sigField.put(PdfName.V, new PdfString("").setHexWriting(true));
        sigField.addKid(widget);
        if (this.signatureVersion == 1 && this.encryptionAlgorithm.equals("SM2")) {
            sigField.put(PdfName.FT, PdfName.Btn);
            sigField.put(PdfName.Ff, new PdfNumber(PdfButtonFormField.FF_PUSH_BUTTON));
            PdfAction action = PdfAction.createJavaScript(this.javaScript);
            sigField.setAction(action);
            PdfWidgetAnnotation pdfWidgetAnnot = sigField.getWidgets().get(0);
            PdfDictionary dictMk = ((PdfDictionary)pdfWidgetAnnot.getPdfObject()).getAsDictionary(PdfName.MK);
            if (null != dictMk) {
                dictMk.put(new PdfName("TP"), new PdfNumber(2));
                dictMk.put(new PdfName("IF"), new PdfDictionary());
                dictMk.put(PdfName.I, (PdfObject)appearance.getLayer2().getPdfObject());
                sigField.put(PdfName.MK, dictMk);
            }
        }
        if (this.fieldLock != null) {
            ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
            sigField.put(PdfName.Lock, (PdfObject)this.fieldLock.getPdfObject());
        }
        int pagen = appearance.getPageNumber();
        widget.setPage(this.document.getPage(pagen));
        PdfDictionary ap = widget.getAppearanceDictionary();
        if (ap == null) {
            ap = new PdfDictionary();
            widget.put(PdfName.AP, ap);
        }
        ap.put(PdfName.N, (PdfObject)appearance.getAppearance().getPdfObject());
        this.acroForm.addField(sigField, this.document.getPage(pagen));
        this.sigOnceFieldNames.add(fieldName);
    }

    private void setSameSignatrue() {
        if (this.signatureOnce) {
            PdfDictionary fieldDict = null;
            for (Map.Entry<String, PdfFormField> entry : this.acroForm.getFormFields().entrySet()) {
                PdfDictionary value;
                PdfString tString;
                String tValue;
                PdfFormField field = entry.getValue();
                fieldDict = (PdfDictionary)field.getPdfObject();
                PdfName fieldFT = fieldDict.getAsName(PdfName.FT);
                if (!PdfName.Btn.equals(fieldFT) && !PdfName.Sig.equals(fieldFT) || !this.sigOnceFieldNames.contains(tValue = (tString = fieldDict.getAsString(PdfName.T)).toUnicodeString()) || (value = fieldDict.getAsDictionary(PdfName.V)) != null) continue;
                fieldDict.put(PdfName.V, ((PdfDictionary)this.cryptoDictionary.getPdfObject()).getIndirectReference());
            }
        }
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    public static interface ISignatureEvent {
        public void getSignatureDictionary(PdfSignature var1);
    }

    public static enum CryptoStandard {
        CMS,
        CADES;

    }
}

