/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.SvgNodeUtil;
import java.util.HashMap;
import java.util.List;

public class RectangleSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    public RectangleSvgNodeRenderer() {
        this.attributesAndStyles = new HashMap();
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfCanvas cv = context.getCurrentCanvas();
        cv.writeLiteral("% rect\n");
        float x = 0.0f;
        float y = 0.0f;
        if (this.getAttribute("x") != null) {
            x = CssUtils.parseAbsoluteLength(this.getAttribute("x"));
        }
        if (this.getAttribute("y") != null) {
            y = CssUtils.parseAbsoluteLength(this.getAttribute("y"));
        }
        float[] startPoint = SvgNodeUtil.getStartPoint(this);
        x -= CssUtils.parseAbsoluteLength(String.valueOf(startPoint[0]));
        y -= CssUtils.parseAbsoluteLength(String.valueOf(startPoint[1]));
        float width = CssUtils.parseAbsoluteLength(this.getAttribute("width"));
        float height = CssUtils.parseAbsoluteLength(this.getAttribute("height"));
        boolean rxPresent = false;
        boolean ryPresent = false;
        float rx = 0.0f;
        float ry = 0.0f;
        if (this.attributesAndStyles.containsKey("rx")) {
            rx = CssUtils.parseAbsoluteLength(this.getAttribute("rx"));
            rxPresent = true;
        }
        if (this.attributesAndStyles.containsKey("ry")) {
            ry = CssUtils.parseAbsoluteLength(this.getAttribute("ry"));
            ryPresent = true;
        }
        boolean singleValuePresent = rxPresent && !ryPresent || !rxPresent && ryPresent;
        rx = this.checkRadius(rx, width);
        ry = this.checkRadius(ry, height);
        if (!rxPresent && !ryPresent) {
            cv.rectangle(x, y, width, height);
        } else if (singleValuePresent) {
            cv.writeLiteral("% circle rounded rect\n");
            float radius = this.findCircularRadius(rx, ry, width, height);
            cv.roundRectangle(x, y, width, height, radius);
        } else {
            cv.writeLiteral("% ellipse rounded rect\n");
            cv.moveTo(x + rx, y);
            cv.lineTo(x + width - rx, y);
            this.arc(x + width - 2.0f * rx, y, x + width, y + 2.0f * ry, -90.0f, 90.0f, cv);
            cv.lineTo(x + width, y + height - ry);
            this.arc(x + width, y + height - 2.0f * ry, x + width - 2.0f * rx, y + height, 0.0f, 90.0f, cv);
            cv.lineTo(x + rx, y + height);
            this.arc(x + 2.0f * rx, y + height, x, y + height - 2.0f * ry, 90.0f, 90.0f, cv);
            cv.lineTo(x, y + ry);
            this.arc(x, y + 2.0f * ry, x + 2.0f * rx, y, 180.0f, 90.0f, cv);
            cv.closePath();
        }
    }

    private void arc(float x1, float y1, float x2, float y2, float startAng, float extent, PdfCanvas cv) {
        List<double[]> ar = PdfCanvas.bezierArc(x1, y1, x2, y2, startAng, extent);
        if (!ar.isEmpty()) {
            for (int k = 0; k < ar.size(); ++k) {
                double[] pt = ar.get(k);
                cv.curveTo(pt[2], pt[3], pt[4], pt[5], pt[6], pt[7]);
            }
        }
    }

    float checkRadius(float radius, float distance) {
        if (radius <= 0.0f) {
            return 0.0f;
        }
        if (radius > distance / 2.0f) {
            return distance / 2.0f;
        }
        return radius;
    }

    float findCircularRadius(float rx, float ry, float width, float height) {
        float maxRadius = Math.min(width, height) / 2.0f;
        float biggestRadius = Math.max(rx, ry);
        return Math.min(maxRadius, biggestRadius);
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        RectangleSvgNodeRenderer copy = new RectangleSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

