/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String escape(String src, HashMap<String, String> hashMap) {
        if (src == null || src.trim().length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator sci = new StringCharacterIterator(src);
        char c = sci.first();
        while (c != '\uffff') {
            String ch = String.valueOf(c);
            if (hashMap.containsKey(ch)) {
                ch = hashMap.get(ch);
            }
            sb.append(ch);
            c = sci.next();
        }
        return sb.toString();
    }

    public static String escapeSQL(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("'", "''");
        return StringUtil.escape(input, hashMap);
    }

    public static String escapeXML(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("<", "&lt;");
        hashMap.put(">", "&gt;");
        hashMap.put("'", "&apos;");
        hashMap.put("\"", "&quot;");
        hashMap.put("&", "&amp;");
        return StringUtil.escape(input, hashMap);
    }

    public static String removeComma(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (',' == string.charAt(i)) continue;
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static String replace(String string, String replacement) {
        if (string != null) {
            return string.replaceAll(replacement, "");
        }
        return null;
    }

    public static String trim(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        return string.trim();
    }

    public static String clearSpace(String target, String operator) {
        String[] items = target.split(operator);
        String result = "";
        for (String item : items) {
            result = result + operator + item.trim();
        }
        return result.substring(1);
    }

    public static String addCharOnRight(String str, String padChar, int strLength) {
        int strLen = str.length();
        if (strLen < strLength) {
            while (strLen < strLength) {
                StringBuffer sb = new StringBuffer();
                sb.append(str).append(padChar);
                str = sb.toString();
                strLen = str.length();
            }
        }
        return str;
    }

    public static String addZeroOnLeft(String str, int strLength) {
        int strLen = str.length();
        if (strLen < strLength) {
            while (strLen < strLength) {
                StringBuffer sb = new StringBuffer();
                sb.append("0").append(str);
                str = sb.toString();
                strLen = str.length();
            }
        }
        return str;
    }

    public static int getSingleNum(String lastBaseLoc) {
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(lastBaseLoc);
        String fileId = m.replaceAll("").trim();
        int newFileId = Integer.parseInt(fileId);
        return newFileId;
    }

    public static boolean isNumber(String str) {
        String reg = "^[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]+");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isContainValidChar(String str) {
        Pattern p = Pattern.compile("[\\w\\s\u4e00-\u9fa5\\p{P}]+");
        Matcher m = p.matcher(str);
        return m.find();
    }
}

