/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import cfca.sadk.com.itextpdf.layout.Document;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.sign.SealResultInfo;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.CFCAP7Signer;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.UCS4FontUtil;
import cfca.sadk.seal.util.SealSignatureUtil;
import cfca.sadk.seal.util.VerifyUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class WatermarkUtil {
    private static Logger businessLog = LoggerFactory.getLogger(WatermarkUtil.class);

    public static byte[] addCrossWatermark(byte[] pdfData, byte[] imageBytes, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption, int crossPageStyle, int dpi) throws SealException, IOException {
        PdfReader reader = new PdfReader(pdfData);
        return WatermarkUtil.addCrossWatermark(reader, imageBytes, null, pageRangeOption, waterMarkOption, crossPageStyle, dpi, false, null, null);
    }

    public static void addCrossWatermark(InputStream inputStream, OutputStream outputStream, byte[] imageBytes, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption, int crossPageStyle, int dpi) throws SealException, IOException {
        PdfReader reader = new PdfReader(inputStream);
        WatermarkUtil.addCrossWatermark(reader, imageBytes, outputStream, pageRangeOption, waterMarkOption, crossPageStyle, dpi, false, null, null);
    }

    public static byte[] addCrossWatermark(byte[] pdfData, byte[] imageBytes, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption, int crossPageStyle, boolean signLast, SignInfoConfig signInfo, GraphicAppearance appearance) throws SealException, IOException {
        PdfReader reader = new PdfReader(pdfData);
        return WatermarkUtil.addCrossWatermark(reader, imageBytes, null, pageRangeOption, waterMarkOption, crossPageStyle, appearance.getDpi(), signLast, signInfo, appearance);
    }

    public static void addCrossWatermark(InputStream inputStream, OutputStream outputStream, byte[] imageBytes, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption, int crossPageStyle, boolean signLast, SignInfoConfig signInfo, GraphicAppearance appearance) throws SealException, IOException {
        PdfReader reader = new PdfReader(inputStream);
        WatermarkUtil.addCrossWatermark(reader, imageBytes, outputStream, pageRangeOption, waterMarkOption, crossPageStyle, appearance.getDpi(), signLast, signInfo, appearance);
    }

    public static void addWatermark(InputStream inputStream, OutputStream outputStream, byte[] imageBytes, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException, IOException {
        WatermarkUtil.addWatermark(new PdfReader(inputStream), outputStream, imageBytes, pageRangeOption, waterMarkOption);
    }

    public static void addWatermark(byte[] pdfData, OutputStream outputStream, byte[] imageBytes, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException, IOException {
        WatermarkUtil.addWatermark(new PdfReader(pdfData), outputStream, imageBytes, pageRangeOption, waterMarkOption);
    }

    public static void addWatermark(InputStream inputStream, OutputStream outputStream, String text, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException, IOException {
        WatermarkUtil.addWatermark(new PdfReader(inputStream), outputStream, text, pageRangeOption, waterMarkOption);
    }

    public static void addWatermark(byte[] pdfData, OutputStream outputStream, String text, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException, IOException {
        WatermarkUtil.addWatermark(new PdfReader(pdfData), outputStream, text, pageRangeOption, waterMarkOption);
    }

    private static byte[] addCrossWatermark(PdfReader reader, byte[] imageBytes, OutputStream outputStream, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption, int crossPageStyle, int dpi, boolean signLast, SignInfoConfig signInfo, GraphicAppearance appearance) throws SealException {
        businessLog.info("addWatermark begin...");
        boolean isReturnBytes = false;
        byte[] resultBytes = null;
        ByteArrayOutputStream tmpOs = new ByteArrayOutputStream();
        if (outputStream == null) {
            isReturnBytes = true;
        }
        Document document = null;
        try {
            StampingProperties properties = new StampingProperties().preserveEncryption();
            byte[] openPassword = null;
            if (null != signInfo && null != (openPassword = signInfo.getOpenPassword())) {
                reader.setOpenPassword(openPassword);
            }
            PdfDocument pdfDocument = new PdfDocument(reader, new PdfWriter(tmpOs), properties, true);
            ParamsCheckUtil.checkSignature(pdfDocument);
            document = new Document(pdfDocument);
            int fromPage = pageRangeOption.getFromPage();
            int toPage = pageRangeOption.getToPage();
            if (null == imageBytes) {
                throw new SealException("imageBytes is null!");
            }
            if (!ImageDataFactory.isPNGType(imageBytes)) {
                throw new SealException("imageBytes is not PNG type!");
            }
            if (fromPage == 0 || -1 > fromPage) {
                businessLog.error("fromPage must be positive or -1!");
                throw new SealException("fromPage must be positive or -1!");
            }
            if (toPage == 0 || -1 > toPage) {
                businessLog.error("toPage must be positive or -1!");
                throw new SealException("toPage must be positive or -1!");
            }
            if (crossPageStyle != 6 && crossPageStyle != 5 && crossPageStyle != 7) {
                throw new SealException("crossPageStyle must be RIGHT_STRIPE or LEFT_STRIPE or UP_STRIPE!");
            }
            int numberOfPages = pdfDocument.getNumberOfPages();
            if (-1 == fromPage) {
                fromPage = 1;
            }
            if (-1 == toPage) {
                toPage = numberOfPages;
            }
            if (fromPage > toPage) {
                int temp = fromPage;
                fromPage = toPage;
                toPage = temp;
            }
            if (0 != pageRangeOption.getSubPageRangeOption()) {
                if (1 == pageRangeOption.getSubPageRangeOption()) {
                    if (fromPage % 2 == 0) {
                        ++fromPage;
                    }
                } else if (2 == pageRangeOption.getSubPageRangeOption() && fromPage % 2 != 0) {
                    ++fromPage;
                }
            }
            boolean ifUnderContent = waterMarkOption.ifUnderContent();
            float absoluteX = waterMarkOption.getAbsoluteX();
            float absoluteY = waterMarkOption.getAbsoluteY();
            float offsetX = waterMarkOption.getOffsetX();
            float offsetY = waterMarkOption.getOffsetY();
            float alpha = waterMarkOption.getAlpha();
            float tmpAbsoluteX = absoluteX + offsetX;
            float tmpAbsoluteY = absoluteY + offsetY;
            ArrayList<PDFUtil.SplittedImage> splittedImages = PDFUtil.splitImage(pdfDocument, new ByteArrayInputStream(imageBytes), "PNG", fromPage, toPage, crossPageStyle, pageRangeOption.subPageRangeOption, dpi, null);
            int imageSizes = splittedImages.size();
            if (signLast) {
                imageSizes = splittedImages.size() - 1;
            }
            for (int i = 0; i < imageSizes; ++i) {
                PdfCanvas pdfCanvas;
                PDFUtil.SplittedImage splittedImage = splittedImages.get(i);
                byte[] oneImageBytes = splittedImage.imageBytes;
                Rectangle rect = splittedImage.imageRect;
                ImageData imageData = ImageDataFactory.create(oneImageBytes);
                if (crossPageStyle == 7) {
                    if (absoluteX == -1.0f) {
                        tmpAbsoluteX = rect.getX() + offsetX;
                    }
                    tmpAbsoluteY = rect.getY() + offsetY;
                } else if (crossPageStyle == 5 || crossPageStyle == 6) {
                    if (absoluteY == -1.0f) {
                        tmpAbsoluteY = rect.getY() + offsetY;
                    }
                    tmpAbsoluteX = rect.getX() + offsetX;
                }
                float fitWidth = rect.getWidth();
                float fitHeight = rect.getHeight();
                WatermarkTransformation watermarkTransformation = new WatermarkTransformation(imageData);
                watermarkTransformation.scaleToFit(fitWidth, fitHeight);
                PdfPage pdfPage = pdfDocument.getPage(splittedImage.pageNo);
                Rectangle pageSize = pdfPage.getPageSizeWithRotation();
                float pageHeight = pageSize.getHeight();
                Rectangle mediaBox = pdfPage.getMediaBox();
                if (waterMarkOption.isUpperLeftCoordinate()) {
                    tmpAbsoluteY = pageHeight - absoluteY - offsetY - fitHeight;
                }
                if (mediaBox.getX() != 0.0f || mediaBox.getY() != 0.0f) {
                    tmpAbsoluteX = absoluteX + offsetX + mediaBox.getX();
                    tmpAbsoluteY = absoluteY + offsetY + mediaBox.getY();
                }
                if (ifUnderContent) {
                    PdfStream pdfStreamBefore = pdfPage.newContentStreamBefore();
                    pdfCanvas = new PdfCanvas(pdfStreamBefore, pdfPage.getResources(), pdfDocument);
                } else {
                    pdfCanvas = new PdfCanvas(pdfPage);
                }
                pdfCanvas.saveState();
                PdfExtGState gs1 = new PdfExtGState();
                gs1.setFillOpacity(alpha);
                pdfCanvas.setExtGState(gs1);
                float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{tmpAbsoluteX, tmpAbsoluteY, 0.0f}, pdfPage);
                float tmpX = transformedValues[0];
                float tmpY = transformedValues[1];
                float tmpRotationDegree = transformedValues[2];
                float[] tmpArray = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX, tmpY}, pdfPage, rect);
                tmpX = tmpArray[0];
                tmpY = tmpArray[1];
                watermarkTransformation.setAbsolutePosition(tmpX, tmpY);
                watermarkTransformation.setRotationDegrees(tmpRotationDegree);
                float[] matrix = watermarkTransformation.doMatrixElement();
                pdfCanvas.addImage(imageData, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], false);
                pdfCanvas.restoreState();
            }
            document.close();
            resultBytes = tmpOs.toByteArray();
            if (signLast) {
                PDFUtil.SplittedImage signImageData = splittedImages.get(imageSizes);
                appearance.setPageNum(signImageData.pageNo);
                appearance.setStamperSr(signImageData.imageBytes);
                appearance.setTransparency(alpha);
                Rectangle rect = signImageData.imageRect;
                rect.setX(tmpAbsoluteX);
                rect.setY(tmpAbsoluteY);
                rect.setWidth((int)rect.getWidth());
                appearance.setRectangle(rect);
                appearance.setUpperLeftCoordinate(false);
                signInfo.setP7Signer(new CFCAP7Signer(signInfo));
                SealResultInfo result = SealSignatureUtil.signGraphic(resultBytes, appearance, signInfo);
                resultBytes = result.getSignedPDFData();
                SealVerifyResult verify = VerifyUtil.verify(resultBytes, openPassword);
                if (!verify.getVerifyResult()) {
                    throw new SealException("sign failed:" + verify.getFailReason());
                }
            }
            if (!isReturnBytes) {
                IOUtils.writeChunked((byte[])resultBytes, (OutputStream)outputStream);
                resultBytes = null;
            }
            byte[] byArray = resultBytes;
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("addWatermark failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addWatermark failed", (Throwable)e);
            throw new SealException("addWatermark failed", e);
        }
        finally {
            if (null != document) {
                document.close();
            }
            businessLog.info("addWatermark end...");
        }
    }

    private static float[] toTranslateValuesInTransformedCoordinate(float[] oldXY, PdfPage pdfPage, Rectangle untransformedRect) {
        float[] newXY = new float[2];
        float tmpX = oldXY[0];
        float tmpY = oldXY[1];
        int rotation = pdfPage.getRotation();
        Rectangle transformedRect = new Rectangle(untransformedRect);
        if (90 == rotation) {
            transformedRect.setWidth(untransformedRect.getHeight());
            transformedRect.setHeight(untransformedRect.getWidth());
            tmpX -= transformedRect.getWidth();
        } else if (180 == rotation) {
            tmpX -= transformedRect.getWidth();
            tmpY -= transformedRect.getHeight();
        } else if (270 == rotation) {
            transformedRect.setWidth(untransformedRect.getHeight());
            transformedRect.setHeight(untransformedRect.getWidth());
            tmpY -= transformedRect.getHeight();
        }
        newXY[0] = tmpX;
        newXY[1] = tmpY;
        return newXY;
    }

    private static void addWatermark(PdfReader reader, OutputStream outputStream, byte[] imageBytes, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException {
        businessLog.info("addWatermark begin...");
        Document document = null;
        try {
            StampingProperties properties = new StampingProperties();
            PdfDocument pdfDocument = new PdfDocument(reader, new PdfWriter(outputStream), properties, true);
            ParamsCheckUtil.checkSignature(pdfDocument);
            document = new Document(pdfDocument);
            int step = 1;
            int fromPage = pageRangeOption.getFromPage();
            int toPage = pageRangeOption.getToPage();
            if (fromPage == 0 || -1 > fromPage) {
                businessLog.error("fromPage must be positive or -1!");
                throw new PdfException("fromPage must be positive or -1!");
            }
            if (toPage == 0 || -1 > toPage) {
                businessLog.error("toPage must be positive or -1!");
                throw new PdfException("toPage must be positive or -1!");
            }
            int numberOfPages = pdfDocument.getNumberOfPages();
            if (-1 == fromPage) {
                fromPage = 1;
            }
            if (-1 == toPage) {
                toPage = numberOfPages;
            }
            if (fromPage > toPage) {
                int temp = fromPage;
                fromPage = toPage;
                toPage = temp;
            }
            if (0 != pageRangeOption.getSubPageRangeOption()) {
                if (1 == pageRangeOption.getSubPageRangeOption()) {
                    if (fromPage % 2 == 0) {
                        ++fromPage;
                    }
                    step = 2;
                } else if (2 == pageRangeOption.getSubPageRangeOption()) {
                    if (fromPage % 2 != 0) {
                        ++fromPage;
                    }
                    step = 2;
                }
            }
            boolean ifUnderContent = waterMarkOption.ifUnderContent();
            float absoluteX = waterMarkOption.getAbsoluteX();
            float absoluteY = waterMarkOption.getAbsoluteY();
            float fitWidth = waterMarkOption.getFitWidth();
            float fitHeight = waterMarkOption.getFitHeight();
            float rotationDegree = waterMarkOption.getRotationDegree();
            float alpha = waterMarkOption.getAlpha();
            float apartX = waterMarkOption.getApartX();
            float apartY = waterMarkOption.getApartY();
            ImageData imageData = ImageDataFactory.create(imageBytes);
            PdfImageXObject imageXObject = new PdfImageXObject(imageData);
            PdfName pdfName = null;
            WatermarkTransformation watermarkTransformation = new WatermarkTransformation(imageData);
            watermarkTransformation.scaleToFit(fitWidth, fitHeight);
            fitHeight = watermarkTransformation.getScaledHeight();
            fitWidth = watermarkTransformation.getScaledWidth();
            boolean ifBeddingX = false;
            boolean ifBeddingY = false;
            if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
                ifBeddingX = true;
            }
            if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
                ifBeddingY = true;
            }
            float tmpAbsoluteX = 0.0f;
            float tmpAbsoluteY = 0.0f;
            for (int i = fromPage; i <= toPage; i += step) {
                float upwardY;
                float downwardY;
                float[] matrix;
                float[] tmpArray;
                Rectangle rect;
                float tmpY;
                float tmpX;
                float[] matrix2;
                float[] tmpArray2;
                float tmpRotationDegree;
                float tmpY2;
                PdfCanvas pdfCanvas;
                PdfPage pdfPage = pdfDocument.getPage(i);
                Rectangle pageSize = pdfPage.getPageSizeWithRotation();
                float pageWidth = pageSize.getWidth();
                float pageHeight = pageSize.getHeight();
                if (i == fromPage) {
                    tmpAbsoluteX = absoluteX;
                    tmpAbsoluteY = absoluteY;
                }
                if (tmpAbsoluteX >= 0.0f && tmpAbsoluteY >= 0.0f) {
                    Rectangle mediaBox = pdfPage.getMediaBox();
                    if (waterMarkOption.isUpperLeftCoordinate()) {
                        absoluteY = pageHeight - tmpAbsoluteY - fitHeight;
                    }
                    if (mediaBox.getX() != 0.0f || mediaBox.getY() != 0.0f) {
                        absoluteX = tmpAbsoluteX + mediaBox.getX();
                        absoluteY = tmpAbsoluteY + mediaBox.getY();
                    }
                } else {
                    if (tmpAbsoluteX < 0.0f) {
                        absoluteX = pageWidth + tmpAbsoluteX;
                    }
                    if (tmpAbsoluteY < 0.0f) {
                        absoluteY = pageHeight + tmpAbsoluteY;
                    }
                }
                if (ifUnderContent) {
                    PdfStream pdfStreamBefore = pdfPage.newContentStreamBefore();
                    pdfCanvas = new PdfCanvas(pdfStreamBefore, pdfPage.getResources(), pdfDocument);
                } else {
                    pdfCanvas = new PdfCanvas(pdfPage);
                }
                pdfCanvas.saveState();
                PdfExtGState gs1 = new PdfExtGState();
                gs1.setFillOpacity(alpha);
                pdfCanvas.setExtGState(gs1);
                if (ifBeddingX) {
                    float leftwardX = absoluteX;
                    while (true) {
                        float f;
                        leftwardX = leftwardX - fitWidth - apartX;
                        if (!(f >= 0.0f)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{leftwardX, absoluteY, rotationDegree}, pdfPage);
                        float tmpX2 = transformedValues[0];
                        tmpY2 = transformedValues[1];
                        tmpRotationDegree = transformedValues[2];
                        watermarkTransformation.setAbsolutePosition(tmpX2, tmpY2);
                        watermarkTransformation.setRotationDegrees(tmpRotationDegree);
                        Rectangle rect2 = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                        tmpArray2 = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX2, tmpY2}, pdfPage, rect2);
                        tmpX2 = tmpArray2[0];
                        tmpY2 = tmpArray2[1];
                        watermarkTransformation.setAbsolutePosition(tmpX2, tmpY2);
                        matrix2 = watermarkTransformation.doMatrixElement();
                        pdfName = pdfCanvas.addImage(imageXObject, matrix2[0], matrix2[1], matrix2[2], matrix2[3], matrix2[4], matrix2[5], pdfName);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f;
                        rightwardX = rightwardX + apartX + fitWidth;
                        if (!(f < pageWidth)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{rightwardX, absoluteY, rotationDegree}, pdfPage);
                        tmpX = transformedValues[0];
                        tmpY = transformedValues[1];
                        float tmpRotationDegree2 = transformedValues[2];
                        watermarkTransformation.setAbsolutePosition(tmpX, tmpY);
                        watermarkTransformation.setRotationDegrees(tmpRotationDegree2);
                        rect = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                        tmpArray = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX, tmpY}, pdfPage, rect);
                        tmpX = tmpArray[0];
                        tmpY = tmpArray[1];
                        watermarkTransformation.setAbsolutePosition(tmpX, tmpY);
                        matrix = watermarkTransformation.doMatrixElement();
                        pdfName = pdfCanvas.addImage(imageXObject, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], pdfName);
                    }
                }
                if (ifBeddingY) {
                    downwardY = absoluteY;
                    while (true) {
                        float f;
                        downwardY = downwardY - apartY - fitHeight;
                        if (!(f >= 0.0f)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{absoluteX, downwardY, rotationDegree}, pdfPage);
                        float tmpX3 = transformedValues[0];
                        tmpY2 = transformedValues[1];
                        tmpRotationDegree = transformedValues[2];
                        watermarkTransformation.setAbsolutePosition(tmpX3, tmpY2);
                        watermarkTransformation.setRotationDegrees(tmpRotationDegree);
                        Rectangle rect3 = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                        tmpArray2 = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX3, tmpY2}, pdfPage, rect3);
                        tmpX3 = tmpArray2[0];
                        tmpY2 = tmpArray2[1];
                        watermarkTransformation.setAbsolutePosition(tmpX3, tmpY2);
                        matrix2 = watermarkTransformation.doMatrixElement();
                        pdfName = pdfCanvas.addImage(imageXObject, matrix2[0], matrix2[1], matrix2[2], matrix2[3], matrix2[4], matrix2[5], pdfName);
                    }
                    upwardY = absoluteY;
                    while (true) {
                        float f;
                        upwardY = upwardY + apartY + fitHeight;
                        if (!(f < pageHeight)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{absoluteX, upwardY, rotationDegree}, pdfPage);
                        tmpX = transformedValues[0];
                        tmpY = transformedValues[1];
                        float tmpRotationDegree3 = transformedValues[2];
                        watermarkTransformation.setAbsolutePosition(tmpX, tmpY);
                        watermarkTransformation.setRotationDegrees(tmpRotationDegree3);
                        rect = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                        tmpArray = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX, tmpY}, pdfPage, rect);
                        tmpX = tmpArray[0];
                        tmpY = tmpArray[1];
                        watermarkTransformation.setAbsolutePosition(tmpX, tmpY);
                        matrix = watermarkTransformation.doMatrixElement();
                        pdfName = pdfCanvas.addImage(imageXObject, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], pdfName);
                    }
                }
                if (ifBeddingX && ifBeddingY) {
                    float[] matrix3;
                    float[] tmpArray3;
                    downwardY = absoluteY;
                    block11: while (true) {
                        float f;
                        downwardY = downwardY - apartY - fitHeight;
                        if (!(f >= 0.0f)) break;
                        float leftwardX = absoluteX;
                        while (true) {
                            float f2;
                            leftwardX = leftwardX - fitWidth - apartX;
                            if (!(f2 >= 0.0f)) break;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{leftwardX, downwardY, rotationDegree}, pdfPage);
                            float tmpX4 = transformedValues[0];
                            tmpY = transformedValues[1];
                            float tmpRotationDegree4 = transformedValues[2];
                            watermarkTransformation.setAbsolutePosition(tmpX4, tmpY);
                            watermarkTransformation.setRotationDegrees(tmpRotationDegree4);
                            Rectangle rect4 = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                            tmpArray = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX4, tmpY}, pdfPage, rect4);
                            tmpX4 = tmpArray[0];
                            tmpY = tmpArray[1];
                            watermarkTransformation.setAbsolutePosition(tmpX4, tmpY);
                            matrix = watermarkTransformation.doMatrixElement();
                            pdfName = pdfCanvas.addImage(imageXObject, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], pdfName);
                        }
                        float rightwardX = absoluteX;
                        while (true) {
                            float f3;
                            rightwardX = rightwardX + apartX + fitWidth;
                            if (!(f3 < pageWidth)) continue block11;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{rightwardX, downwardY, rotationDegree}, pdfPage);
                            float tmpX5 = transformedValues[0];
                            float tmpY3 = transformedValues[1];
                            float tmpRotationDegree5 = transformedValues[2];
                            watermarkTransformation.setAbsolutePosition(tmpX5, tmpY3);
                            watermarkTransformation.setRotationDegrees(tmpRotationDegree5);
                            Rectangle rect5 = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                            tmpArray3 = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX5, tmpY3}, pdfPage, rect5);
                            tmpX5 = tmpArray3[0];
                            tmpY3 = tmpArray3[1];
                            watermarkTransformation.setAbsolutePosition(tmpX5, tmpY3);
                            matrix3 = watermarkTransformation.doMatrixElement();
                            pdfName = pdfCanvas.addImage(imageXObject, matrix3[0], matrix3[1], matrix3[2], matrix3[3], matrix3[4], matrix3[5], pdfName);
                        }
                        break;
                    }
                    upwardY = absoluteY;
                    block14: while (true) {
                        float f;
                        upwardY = upwardY + apartY + fitHeight;
                        if (!(f < pageHeight)) break;
                        float leftwardX = absoluteX;
                        while (true) {
                            float f4;
                            leftwardX = leftwardX - apartX - fitWidth;
                            if (!(f4 >= 0.0f)) break;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{leftwardX, upwardY, rotationDegree}, pdfPage);
                            float tmpX6 = transformedValues[0];
                            float tmpY4 = transformedValues[1];
                            float tmpRotationDegree6 = transformedValues[2];
                            watermarkTransformation.setAbsolutePosition(tmpX6, tmpY4);
                            watermarkTransformation.setRotationDegrees(tmpRotationDegree6);
                            Rectangle rect6 = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                            tmpArray3 = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX6, tmpY4}, pdfPage, rect6);
                            tmpX6 = tmpArray3[0];
                            tmpY4 = tmpArray3[1];
                            watermarkTransformation.setAbsolutePosition(tmpX6, tmpY4);
                            matrix3 = watermarkTransformation.doMatrixElement();
                            pdfName = pdfCanvas.addImage(imageXObject, matrix3[0], matrix3[1], matrix3[2], matrix3[3], matrix3[4], matrix3[5], pdfName);
                        }
                        float rightwardX = absoluteX;
                        while (true) {
                            float f5;
                            rightwardX = rightwardX + apartX + fitWidth;
                            if (!(f5 < pageWidth)) continue block14;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{rightwardX, upwardY, rotationDegree}, pdfPage);
                            float tmpX7 = transformedValues[0];
                            float tmpY5 = transformedValues[1];
                            float tmpRotationDegree7 = transformedValues[2];
                            watermarkTransformation.setAbsolutePosition(tmpX7, tmpY5);
                            watermarkTransformation.setRotationDegrees(tmpRotationDegree7);
                            Rectangle rect7 = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                            float[] tmpArray4 = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX7, tmpY5}, pdfPage, rect7);
                            tmpX7 = tmpArray4[0];
                            tmpY5 = tmpArray4[1];
                            watermarkTransformation.setAbsolutePosition(tmpX7, tmpY5);
                            float[] matrix4 = watermarkTransformation.doMatrixElement();
                            pdfName = pdfCanvas.addImage(imageXObject, matrix4[0], matrix4[1], matrix4[2], matrix4[3], matrix4[4], matrix4[5], pdfName);
                        }
                        break;
                    }
                }
                float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{absoluteX, absoluteY, rotationDegree}, pdfPage);
                float tmpX8 = transformedValues[0];
                float tmpY6 = transformedValues[1];
                float tmpRotationDegree8 = transformedValues[2];
                watermarkTransformation.setAbsolutePosition(tmpX8, tmpY6);
                watermarkTransformation.setRotationDegrees(tmpRotationDegree8);
                Rectangle rect8 = new Rectangle(absoluteX, absoluteY, watermarkTransformation.getScaledWidth(), watermarkTransformation.getScaledHeight());
                float[] tmpArray5 = WatermarkUtil.toTranslateValuesInTransformedCoordinate(new float[]{tmpX8, tmpY6}, pdfPage, rect8);
                tmpX8 = tmpArray5[0];
                tmpY6 = tmpArray5[1];
                watermarkTransformation.setAbsolutePosition(tmpX8, tmpY6);
                float[] matrix5 = watermarkTransformation.doMatrixElement();
                pdfName = pdfCanvas.addImage(imageXObject, matrix5[0], matrix5[1], matrix5[2], matrix5[3], matrix5[4], matrix5[5], pdfName);
                pdfCanvas.restoreState();
            }
            document.close();
        }
        catch (SealException e) {
            businessLog.error("addWatermark failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addWatermark failed", (Throwable)e);
            throw new SealException("addWatermark failed", e);
        }
        finally {
            if (null != document) {
                document.close();
            }
            businessLog.info("addWatermark end...");
        }
    }

    private static void addWatermark(PdfReader reader, OutputStream outputStream, String text, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException {
        businessLog.info("addWatermark begin...");
        Document document = null;
        try {
            StampingProperties properties = new StampingProperties();
            PdfDocument pdfDocument = new PdfDocument(reader, new PdfWriter(outputStream), properties, true);
            ParamsCheckUtil.checkSignature(pdfDocument);
            document = new Document(pdfDocument);
            int step = 1;
            int fromPage = pageRangeOption.getFromPage();
            int toPage = pageRangeOption.getToPage();
            if (fromPage == 0 || -1 > fromPage) {
                businessLog.error("fromPage must be positive or -1!");
                throw new PdfException("fromPage must be positive or -1!");
            }
            if (toPage == 0 || -1 > toPage) {
                businessLog.error("toPage must be positive or -1!");
                throw new PdfException("toPage must be positive or -1!");
            }
            int numberOfPages = pdfDocument.getNumberOfPages();
            if (-1 == fromPage) {
                fromPage = 1;
            }
            if (-1 == toPage) {
                toPage = numberOfPages;
            }
            if (fromPage > toPage) {
                int temp = fromPage;
                fromPage = toPage;
                toPage = temp;
            }
            if (0 != pageRangeOption.getSubPageRangeOption()) {
                if (1 == pageRangeOption.getSubPageRangeOption()) {
                    if (fromPage % 2 == 0) {
                        ++fromPage;
                    }
                    step = 2;
                } else if (2 == pageRangeOption.getSubPageRangeOption()) {
                    if (fromPage % 2 != 0) {
                        ++fromPage;
                    }
                    step = 2;
                }
            }
            boolean ifUnderContent = waterMarkOption.ifUnderContent();
            float absoluteX = waterMarkOption.getAbsoluteX();
            float absoluteY = waterMarkOption.getAbsoluteY();
            float rotationDegree = waterMarkOption.getRotationDegree();
            float alpha = waterMarkOption.getAlpha();
            float apartX = waterMarkOption.getApartX();
            float apartY = waterMarkOption.getApartY();
            boolean ifBeddingX = false;
            boolean ifBeddingY = false;
            Color color = waterMarkOption.getColor();
            PdfFont pdfFont = waterMarkOption.getPdfFont();
            float fontSize = waterMarkOption.getFontSize();
            TextAlignment alignment = waterMarkOption.getAlignment();
            if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
                ifBeddingX = true;
            }
            if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
                ifBeddingY = true;
            }
            PdfExtGState gs1 = new PdfExtGState();
            gs1.setFillOpacity(alpha);
            Paragraph paragraph = new Paragraph(text);
            if (PDFUtil.containsUCS4Glyph(text)) {
                try {
                    pdfFont = UCS4FontUtil.getInstance().subsetFont(text);
                }
                catch (SealException e) {
                    businessLog.error("UCS4FontUtil.subsetFont failed", (Throwable)e);
                }
            }
            if (null == pdfFont) {
                try {
                    pdfFont = FontUtil.getInstance().subsetFont(text);
                }
                catch (SealException e) {
                    businessLog.error("FontUtil.subsetFont failed", (Throwable)e);
                }
            }
            ((Paragraph)((Paragraph)paragraph.setFont(pdfFont)).setFontColor(color)).setFontSize(fontSize);
            int textWidth = pdfFont.getWidth(text) / 1000;
            float stretchingX = (float)((double)textWidth * Math.cos(Math.toRadians(rotationDegree)));
            float stretchingY = (float)((double)textWidth * Math.sin(Math.toRadians(rotationDegree)));
            float tmpAbsoluteX = 0.0f;
            float tmpAbsoluteY = 0.0f;
            for (int i = fromPage; i <= toPage; i += step) {
                float tmpRotationDegree;
                float tmpY;
                float tmpX;
                float tmpRotationDegree2;
                float tmpY2;
                PdfCanvas pdfCanvas;
                if (i == fromPage) {
                    tmpAbsoluteX = absoluteX;
                    tmpAbsoluteY = absoluteY;
                }
                PdfPage pdfPage = pdfDocument.getPage(i);
                Rectangle pageSize = pdfPage.getPageSizeWithRotation();
                float pageWidth = pageSize.getWidth();
                float pageHeight = pageSize.getHeight();
                if (tmpAbsoluteX >= 0.0f && tmpAbsoluteY >= 0.0f) {
                    Rectangle mediaBox = pdfPage.getMediaBox();
                    if (waterMarkOption.isUpperLeftCoordinate()) {
                        int lineNum = WatermarkUtil.getNumberOfLines(text);
                        absoluteY = pageHeight - tmpAbsoluteY - (float)lineNum * (fontSize * 1.15f);
                    }
                    if (mediaBox.getX() != 0.0f || mediaBox.getY() != 0.0f) {
                        absoluteX = tmpAbsoluteX + mediaBox.getX();
                        absoluteY = tmpAbsoluteY + mediaBox.getY();
                    }
                } else {
                    if (absoluteX < 0.0f) {
                        absoluteX = pageWidth + absoluteX;
                    }
                    if (absoluteY < 0.0f) {
                        absoluteY = pageHeight + absoluteY;
                    }
                }
                if (ifUnderContent) {
                    PdfStream pdfStreamBefore = pdfPage.newContentStreamBefore();
                    pdfCanvas = new PdfCanvas(pdfStreamBefore, pdfPage.getResources(), pdfDocument);
                } else {
                    pdfCanvas = new PdfCanvas(pdfPage);
                }
                pdfCanvas.saveState();
                pdfCanvas.setExtGState(gs1);
                if (ifBeddingX) {
                    float leftwardX = absoluteX;
                    while (true) {
                        float f;
                        leftwardX = leftwardX - apartX - stretchingX;
                        if (!(f > 0.0f)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{leftwardX, absoluteY, rotationDegree}, pdfPage);
                        float tmpX2 = transformedValues[0];
                        tmpY2 = transformedValues[1];
                        tmpRotationDegree2 = transformedValues[2];
                        document.showTextAligned(paragraph, tmpX2, tmpY2, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree2));
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f;
                        rightwardX = rightwardX + apartX + stretchingX;
                        if (!(f < pageWidth)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{rightwardX, absoluteY, rotationDegree}, pdfPage);
                        tmpX = transformedValues[0];
                        tmpY = transformedValues[1];
                        tmpRotationDegree = transformedValues[2];
                        document.showTextAligned(paragraph, tmpX, tmpY, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree));
                    }
                }
                if (ifBeddingY) {
                    float downwardY = absoluteY;
                    while (true) {
                        float f;
                        downwardY = downwardY - apartY - stretchingY;
                        if (!(f >= 0.0f)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{absoluteX, downwardY, rotationDegree}, pdfPage);
                        float tmpX3 = transformedValues[0];
                        tmpY2 = transformedValues[1];
                        tmpRotationDegree2 = transformedValues[2];
                        document.showTextAligned(paragraph, tmpX3, tmpY2, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree2));
                    }
                    float upwardY = absoluteY;
                    while (true) {
                        float f;
                        upwardY = upwardY + apartY + stretchingY;
                        if (!(f < pageHeight)) break;
                        float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{absoluteX, upwardY, rotationDegree}, pdfPage);
                        tmpX = transformedValues[0];
                        tmpY = transformedValues[1];
                        tmpRotationDegree = transformedValues[2];
                        document.showTextAligned(paragraph, tmpX, tmpY, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree));
                    }
                }
                if (ifBeddingX && ifBeddingY) {
                    float tmpRotationDegree3;
                    float tmpY3;
                    float downwardY = absoluteY;
                    block15: while (true) {
                        float f;
                        downwardY = downwardY - apartY - stretchingY;
                        if (!(f >= 0.0f)) break;
                        float leftwardX = absoluteX;
                        while (true) {
                            float f2;
                            leftwardX = leftwardX - stretchingX - apartX;
                            if (!(f2 >= 0.0f)) break;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{leftwardX, downwardY, rotationDegree}, pdfPage);
                            float tmpX4 = transformedValues[0];
                            tmpY = transformedValues[1];
                            tmpRotationDegree = transformedValues[2];
                            document.showTextAligned(paragraph, tmpX4, tmpY, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree));
                        }
                        float rightwardX = absoluteX;
                        while (true) {
                            float f3;
                            rightwardX = rightwardX + apartX + stretchingX;
                            if (!(f3 < pageWidth)) continue block15;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{rightwardX, downwardY, rotationDegree}, pdfPage);
                            float tmpX5 = transformedValues[0];
                            tmpY3 = transformedValues[1];
                            tmpRotationDegree3 = transformedValues[2];
                            document.showTextAligned(paragraph, tmpX5, tmpY3, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree3));
                        }
                        break;
                    }
                    float upwardY = absoluteY;
                    block18: while (true) {
                        float f;
                        upwardY = upwardY + apartY + stretchingY;
                        if (!(f < pageHeight)) break;
                        float leftwardX = absoluteX;
                        while (true) {
                            float f4;
                            leftwardX = leftwardX - apartX - stretchingX;
                            if (!(f4 >= 0.0f)) break;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{leftwardX, upwardY, rotationDegree}, pdfPage);
                            float tmpX6 = transformedValues[0];
                            tmpY3 = transformedValues[1];
                            tmpRotationDegree3 = transformedValues[2];
                            document.showTextAligned(paragraph, tmpX6, tmpY3, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree3));
                        }
                        float rightwardX = absoluteX;
                        while (true) {
                            float f5;
                            rightwardX = rightwardX + apartX + stretchingX;
                            if (!(f5 < pageWidth)) continue block18;
                            float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{rightwardX, upwardY, rotationDegree}, pdfPage);
                            float tmpX7 = transformedValues[0];
                            float tmpY4 = transformedValues[1];
                            float tmpRotationDegree4 = transformedValues[2];
                            document.showTextAligned(paragraph, tmpX7, tmpY4, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree4));
                        }
                        break;
                    }
                }
                float[] transformedValues = WatermarkUtil.toTransformedCoordinateValues(new float[]{absoluteX, absoluteY, rotationDegree}, pdfPage);
                float tmpX8 = transformedValues[0];
                float tmpY5 = transformedValues[1];
                float tmpRotationDegree5 = transformedValues[2];
                document.showTextAligned(paragraph, tmpX8, tmpY5, i, alignment, VerticalAlignment.BOTTOM, (float)Math.toRadians(tmpRotationDegree5));
                pdfCanvas.restoreState();
            }
        }
        catch (SealException e) {
            businessLog.error("addWatermark failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addWatermark failed", (Throwable)e);
            throw new SealException("addWatermark failed", e);
        }
        finally {
            if (null != document) {
                document.close();
            }
            businessLog.info("addWatermark end...");
        }
    }

    private static int getNumberOfLines(String text) {
        if (null == text || 0 == text.length()) {
            return 0;
        }
        int idx = text.indexOf("\n");
        if (-1 == idx || idx == text.length()) {
            return 1;
        }
        String tmpText = text.substring(idx + 1);
        return 1 + WatermarkUtil.getNumberOfLines(tmpText);
    }

    static float[] toTransformedCoordinateValues(float[] untransformedValues, PdfPage pdfPage) {
        float[] transformedValues = new float[3];
        Rectangle pageRect = pdfPage.getPageSizeWithRotation();
        int rotation = pdfPage.getRotation();
        float tmpX = untransformedValues[0];
        float tmpY = untransformedValues[1];
        float tmpRotationDegree = untransformedValues[2];
        float pageHeight = pageRect.getHeight();
        float pageWidth = pageRect.getWidth();
        float x = tmpX;
        float y = tmpY;
        float rotationDegree = tmpRotationDegree;
        if (90 == rotation) {
            x = pageHeight - tmpY;
            y = tmpX;
            rotationDegree = tmpRotationDegree + 90.0f;
            rotationDegree %= 360.0f;
        } else if (180 == rotation) {
            x = pageWidth - tmpX;
            y = pageHeight - tmpY;
            rotationDegree = tmpRotationDegree + 180.0f;
            rotationDegree %= 360.0f;
        } else if (270 == rotation) {
            x = tmpY;
            y = pageWidth - tmpX;
            rotationDegree = tmpRotationDegree - 90.0f;
            rotationDegree %= 360.0f;
        }
        transformedValues[0] = x;
        transformedValues[1] = y;
        transformedValues[2] = rotationDegree;
        return transformedValues;
    }

    public static class WatermarkTransformation {
        public static final int AX = 0;
        public static final int AY = 1;
        public static final int BX = 2;
        public static final int BY = 3;
        public static final int CX = 4;
        public static final int CY = 5;
        public static final int DX = 6;
        public static final int DY = 7;
        protected float rotationRadians;
        protected float absoluteX = Float.NaN;
        protected float absoluteY = Float.NaN;
        protected float plainWidth;
        protected float plainHeight;
        protected float scaledWidth;
        protected float scaledHeight;
        private float widthPercentage = 100.0f;
        private float initialRotation;
        private ImageData imageData;

        public WatermarkTransformation(ImageData imageData) {
            this.imageData = imageData;
        }

        public float[] doMatrixElement() {
            float[] matrix = this.matrix();
            matrix[4] = this.getAbsoluteX() - matrix[4];
            matrix[5] = this.getAbsoluteY() - matrix[5];
            return matrix;
        }

        public float[] matrix(float scalePercentage) {
            float[] matrix = new float[8];
            float cosX = (float)Math.cos(this.rotationRadians);
            float sinX = (float)Math.sin(this.rotationRadians);
            matrix[0] = this.plainWidth * cosX * scalePercentage;
            matrix[1] = this.plainWidth * sinX * scalePercentage;
            matrix[2] = -this.plainHeight * sinX * scalePercentage;
            matrix[3] = this.plainHeight * cosX * scalePercentage;
            if ((double)this.rotationRadians < 1.5707963267948966) {
                matrix[4] = matrix[2];
                matrix[5] = 0.0f;
                matrix[6] = matrix[0];
                matrix[7] = matrix[1] + matrix[3];
            } else if ((double)this.rotationRadians < Math.PI) {
                matrix[4] = matrix[0] + matrix[2];
                matrix[5] = matrix[3];
                matrix[6] = 0.0f;
                matrix[7] = matrix[1];
            } else if ((double)this.rotationRadians < 4.71238898038469) {
                matrix[4] = matrix[0];
                matrix[5] = matrix[1] + matrix[3];
                matrix[6] = matrix[2];
                matrix[7] = 0.0f;
            } else {
                matrix[4] = 0.0f;
                matrix[5] = matrix[1];
                matrix[6] = matrix[0] + matrix[2];
                matrix[7] = matrix[3];
            }
            return matrix;
        }

        public float[] matrix() {
            return this.matrix(1.0f);
        }

        public void scalePercent(float percentX, float percentY) {
            this.plainWidth = this.getWidth() * percentX / 100.0f;
            this.plainHeight = this.getHeight() * percentY / 100.0f;
            float[] matrix = this.matrix();
            this.scaledWidth = matrix[6] - matrix[4];
            this.scaledHeight = matrix[7] - matrix[5];
            this.setWidthPercentage(0.0f);
        }

        public float getHeight() {
            return this.imageData.getHeight();
        }

        public float getWidth() {
            return this.imageData.getWidth();
        }

        public void setWidthPercentage(float widthPercentage) {
            this.widthPercentage = widthPercentage;
        }

        public void scaleToFit(float fitWidth, float fitHeight) {
            this.scalePercent(100.0f);
            float percentX = fitWidth * 100.0f / this.getScaledWidth();
            float percentY = fitHeight * 100.0f / this.getScaledHeight();
            this.scalePercent(percentX < percentY ? percentX : percentY);
            this.setWidthPercentage(0.0f);
        }

        public void scalePercent(float percent) {
            this.widthPercentage = percent;
            this.scalePercent(percent, percent);
        }

        public float getScaledWidth() {
            return this.scaledWidth;
        }

        public float getScaledHeight() {
            return this.scaledHeight;
        }

        public void setRotationDegrees(float deg) {
            double d = Math.PI;
            this.setRotation(deg / 180.0f * (float)d);
        }

        public void setRotation(float r) {
            double d = Math.PI * 2;
            this.rotationRadians = (float)((double)(r + this.initialRotation) % d);
            if (this.rotationRadians < 0.0f) {
                this.rotationRadians = (float)((double)this.rotationRadians + d);
            }
            float[] matrix = this.matrix();
            this.scaledWidth = matrix[6] - matrix[4];
            this.scaledHeight = matrix[7] - matrix[5];
        }

        public void setAbsolutePosition(float absoluteX, float absoluteY) {
            this.absoluteX = absoluteX;
            this.absoluteY = absoluteY;
        }

        public float getAbsoluteX() {
            return this.absoluteX;
        }

        public float getAbsoluteY() {
            return this.absoluteY;
        }
    }

    public static class PageRangeOption {
        private int fromPage;
        private int toPage;
        private int subPageRangeOption;

        private PageRangeOption(int fromPage, int toPage, int subPageRangeOption) {
            this.fromPage = fromPage;
            this.toPage = toPage;
            this.subPageRangeOption = subPageRangeOption;
        }

        public static PageRangeOption build(int fromPage, int toPage, int subPageRangeOption) {
            return new PageRangeOption(fromPage, toPage, subPageRangeOption);
        }

        public int getFromPage() {
            return this.fromPage;
        }

        public int getToPage() {
            return this.toPage;
        }

        public int getSubPageRangeOption() {
            return this.subPageRangeOption;
        }

        public static interface SubPageRangeOption {
            public static final int ALL = 0;
            public static final int ODD = 1;
            public static final int EVEN = 2;
        }
    }

    public static class WatermarkOption {
        private boolean ifUnderContent;
        private float rotationDegree;
        private float alpha;
        private float absoluteX;
        private float absoluteY;
        private float fitWidth;
        private float fitHeight;
        private Color color;
        private PdfFont pdfFont;
        private float fontSize;
        private TextAlignment textAlignment;
        private float apartX;
        private float apartY;
        private float offsetX;
        private float offsetY;
        private boolean isUpperLeftCoordinate = false;

        private WatermarkOption(boolean ifUnderContent, float absoluteX, float absoluteY, float apartX, float apartY, float rotationDegree, float alpha, float fitWidth, float fitHeight, Color color, PdfFont pdfFont, float fontSize, TextAlignment textAlignment, boolean isUpperLeftCoordinate) {
            this.ifUnderContent = ifUnderContent;
            this.isUpperLeftCoordinate = isUpperLeftCoordinate;
            if (isUpperLeftCoordinate) {
                ParamsCheckUtil.negativeException(absoluteX, -1.0f, true);
                ParamsCheckUtil.negativeException(absoluteY, -1.0f, true);
            }
            this.absoluteX = absoluteX;
            this.absoluteY = absoluteY;
            this.apartX = apartX;
            this.apartY = apartY;
            this.rotationDegree = rotationDegree;
            ParamsCheckUtil.negativeException(alpha, -1.0f, true);
            this.alpha = alpha;
            ParamsCheckUtil.negativeException(fitWidth, -1.0f, true);
            ParamsCheckUtil.negativeException(fitHeight, -1.0f, true);
            this.fitWidth = fitWidth;
            this.fitHeight = fitHeight;
            this.color = color;
            this.pdfFont = pdfFont;
            ParamsCheckUtil.negativeException(fontSize, -1.0f, true);
            this.fontSize = fontSize;
            this.textAlignment = textAlignment;
        }

        public static WatermarkOption buildImageOption(boolean ifUnderContent, float absoluteX, float absoluteY, float apartX, float apartY, float rotationDegree, float alpha, float fitWidth, float fitHeight) {
            return new WatermarkOption(ifUnderContent, absoluteX, absoluteY, apartX, apartY, rotationDegree, alpha, fitWidth, fitHeight, null, null, 0.0f, TextAlignment.CENTER, false);
        }

        public static WatermarkOption buildImageOption(float absoluteX, float absoluteY, float rotationDegree, float alpha, float fitWidth, float fitHeight) {
            return new WatermarkOption(false, absoluteX, absoluteY, -1.0f, -1.0f, rotationDegree, alpha, fitWidth, fitHeight, null, null, 0.0f, TextAlignment.CENTER, false);
        }

        public static WatermarkOption buildTextOption(boolean ifUnderContent, float absoluteX, float absoluteY, float apartX, float apartY, float rotationDegree, float alpha, Color color, PdfFont pdfFont, float fontSize, TextAlignment textAlignment) {
            return new WatermarkOption(ifUnderContent, absoluteX, absoluteY, apartX, apartY, rotationDegree, alpha, 0.0f, 0.0f, color, pdfFont, fontSize, textAlignment, false);
        }

        public static WatermarkOption buildTextOption(float absoluteX, float absoluteY, float rotationDegree, float alpha, Color color, PdfFont pdfFont, float fontSize, TextAlignment textAlignment) {
            return new WatermarkOption(false, absoluteX, absoluteY, -1.0f, -1.0f, rotationDegree, alpha, 0.0f, 0.0f, color, pdfFont, fontSize, textAlignment, false);
        }

        public boolean ifUnderContent() {
            return this.ifUnderContent;
        }

        public float getRotationDegree() {
            return this.rotationDegree;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public float getAbsoluteX() {
            return this.absoluteX;
        }

        public float getAbsoluteY() {
            return this.absoluteY;
        }

        public float getFitWidth() {
            return this.fitWidth;
        }

        public float getFitHeight() {
            return this.fitHeight;
        }

        public Color getColor() {
            return this.color;
        }

        public PdfFont getPdfFont() {
            return this.pdfFont;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public TextAlignment getAlignment() {
            return this.textAlignment;
        }

        public float getApartX() {
            return this.apartX;
        }

        public float getApartY() {
            return this.apartY;
        }

        public float getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(float offsetX) {
            this.offsetX = offsetX;
        }

        public float getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetY(float offsetY) {
            this.offsetY = offsetY;
        }

        public boolean isUpperLeftCoordinate() {
            return this.isUpperLeftCoordinate;
        }

        public void setUpperLeftCoordinate(boolean isUpperLeftCoordinate) {
            this.isUpperLeftCoordinate = isUpperLeftCoordinate;
        }
    }
}

