/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.forms.fields;

import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.io.codec.Base64;
import cfca.sadk.com.itextpdf.io.util.StreamUtil;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import java.io.FileInputStream;
import java.io.IOException;

public class PdfButtonFormField
extends PdfFormField {
    public static final int FF_NO_TOGGLE_TO_OFF = PdfButtonFormField.makeFieldFlag(15);
    public static final int FF_RADIO = PdfButtonFormField.makeFieldFlag(16);
    public static final int FF_PUSH_BUTTON = PdfButtonFormField.makeFieldFlag(17);
    public static final int FF_RADIOS_IN_UNISON = PdfButtonFormField.makeFieldFlag(26);
    public static final int FF_IMAGE_BUTTON = 65536;

    protected PdfButtonFormField(PdfDocument pdfDocument) {
        super(pdfDocument);
    }

    protected PdfButtonFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        super(widget, pdfDocument);
    }

    protected PdfButtonFormField(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getFormType() {
        return PdfName.Btn;
    }

    public boolean isRadio() {
        return this.getFieldFlag(FF_RADIO);
    }

    public PdfButtonFormField setRadio(boolean radio) {
        return (PdfButtonFormField)this.setFieldFlag(FF_RADIO, radio);
    }

    public boolean isToggleOff() {
        return !this.getFieldFlag(FF_NO_TOGGLE_TO_OFF);
    }

    public PdfButtonFormField setToggleOff(boolean toggleOff) {
        return (PdfButtonFormField)this.setFieldFlag(FF_NO_TOGGLE_TO_OFF, !toggleOff);
    }

    public boolean isPushButton() {
        return this.getFieldFlag(FF_PUSH_BUTTON);
    }

    public PdfButtonFormField setPushButton(boolean pushButton) {
        return (PdfButtonFormField)this.setFieldFlag(FF_PUSH_BUTTON, pushButton);
    }

    public boolean isRadiosInUnison() {
        return this.getFieldFlag(FF_RADIOS_IN_UNISON);
    }

    public PdfButtonFormField setRadiosInUnison(boolean radiosInUnison) {
        return (PdfButtonFormField)this.setFieldFlag(FF_RADIOS_IN_UNISON, radiosInUnison);
    }

    public PdfButtonFormField setImage(String image) throws IOException {
        FileInputStream is = new FileInputStream(image);
        String str = Base64.encodeBytes(StreamUtil.inputStreamToArray(is));
        return (PdfButtonFormField)this.setValue(str);
    }

    public PdfButtonFormField setImage(byte[] imageBytes) throws IOException {
        String str = Base64.encodeBytes(imageBytes);
        return (PdfButtonFormField)this.setValue(str);
    }

    public PdfButtonFormField setImageAsForm(PdfFormXObject form) {
        this.form = form;
        this.regenerateField();
        return this;
    }
}

