/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf;

import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.action.PdfAction;
import cfca.sadk.com.itextpdf.kernel.pdf.navigation.PdfDestination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PdfOutline
implements Serializable {
    private static final long serialVersionUID = 5730874960685950376L;
    public static int FLAG_ITALIC = 1;
    public static int FLAG_BOLD = 2;
    private List<PdfOutline> children = new ArrayList<PdfOutline>();
    private String title;
    private PdfDictionary content;
    private PdfDestination destination;
    private PdfOutline parent;
    private PdfDocument pdfDoc;

    @Deprecated
    public PdfOutline(String title, PdfDictionary content, PdfDocument pdfDocument) {
        this.title = title;
        this.content = content;
        this.pdfDoc = pdfDocument;
    }

    @Deprecated
    public PdfOutline(String title, PdfDictionary content, PdfOutline parent) {
        this.title = title;
        this.content = content;
        this.parent = parent;
        this.pdfDoc = parent.pdfDoc;
        content.makeIndirect(parent.pdfDoc);
    }

    @Deprecated
    protected PdfOutline(PdfDocument doc) {
        this.content = new PdfDictionary();
        this.content.put(PdfName.Type, PdfName.Outlines);
        this.pdfDoc = doc;
        this.content.makeIndirect(doc);
        doc.getCatalog().addRootOutline(this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.content.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
    }

    public void setColor(Color color) {
        this.content.put(PdfName.C, new PdfArray(color.getColorValue()));
    }

    public void setStyle(int style) {
        if (style == FLAG_BOLD || style == FLAG_ITALIC) {
            this.content.put(PdfName.F, new PdfNumber(style));
        }
    }

    public PdfDictionary getContent() {
        return this.content;
    }

    public List<PdfOutline> getAllChildren() {
        return this.children;
    }

    public PdfOutline getParent() {
        return this.parent;
    }

    public PdfDestination getDestination() {
        return this.destination;
    }

    public void addDestination(PdfDestination destination) {
        this.setDestination(destination);
        this.content.put(PdfName.Dest, (PdfObject)destination.getPdfObject());
    }

    public void addAction(PdfAction action) {
        this.content.put(PdfName.A, (PdfObject)action.getPdfObject());
    }

    public void setOpen(boolean open) {
        if (!open) {
            this.content.put(PdfName.Count, new PdfNumber(-1));
        } else if (this.children.size() > 0) {
            this.content.put(PdfName.Count, new PdfNumber(this.children.size()));
        } else {
            this.content.remove(PdfName.Count);
        }
    }

    public PdfOutline addOutline(String title, int position) {
        PdfNumber count;
        if (position == -1) {
            position = this.children.size();
        }
        PdfDictionary dictionary = new PdfDictionary();
        PdfOutline outline = new PdfOutline(title, dictionary, this);
        dictionary.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
        dictionary.put(PdfName.Parent, this.content);
        if (this.children.size() > 0) {
            if (position != 0) {
                PdfDictionary prevContent = this.children.get(position - 1).getContent();
                dictionary.put(PdfName.Prev, prevContent);
                prevContent.put(PdfName.Next, dictionary);
            }
            if (position != this.children.size()) {
                PdfDictionary nextContent = this.children.get(position).getContent();
                dictionary.put(PdfName.Next, nextContent);
                nextContent.put(PdfName.Prev, dictionary);
            }
        }
        if (position == 0) {
            this.content.put(PdfName.First, dictionary);
        }
        if (position == this.children.size()) {
            this.content.put(PdfName.Last, dictionary);
        }
        if ((count = this.content.getAsNumber(PdfName.Count)) == null || count.getValue() != -1.0) {
            this.content.put(PdfName.Count, new PdfNumber(this.children.size() + 1));
        }
        this.children.add(position, outline);
        return outline;
    }

    public PdfOutline addOutline(String title) {
        return this.addOutline(title, -1);
    }

    public PdfOutline addOutline(PdfOutline outline) {
        PdfOutline newOutline = this.addOutline(outline.getTitle());
        newOutline.addDestination(outline.getDestination());
        List<PdfOutline> children = outline.getAllChildren();
        for (PdfOutline child : children) {
            newOutline.addOutline(child);
        }
        return newOutline;
    }

    void clear() {
        this.children.clear();
    }

    void setDestination(PdfDestination destination) {
        this.destination = destination;
    }

    void removeOutline() {
        PdfName type = this.content.getAsName(PdfName.Type);
        if (type != null && type.equals(PdfName.Outlines)) {
            this.pdfDoc.getCatalog().remove(PdfName.Outlines);
            return;
        }
        PdfOutline parent = this.parent;
        if (parent != null) {
            List<PdfOutline> children = parent.children;
            if (children != null) {
                children.remove(this);
            }
            PdfDictionary parentContent = parent.content;
            if (children.size() > 0) {
                parentContent.put(PdfName.First, children.get((int)0).content);
                parentContent.put(PdfName.Last, children.get((int)(children.size() - 1)).content);
            } else {
                parent.removeOutline();
                return;
            }
        }
        PdfDictionary next = this.content.getAsDictionary(PdfName.Next);
        PdfDictionary prev = this.content.getAsDictionary(PdfName.Prev);
        if (prev != null) {
            if (next != null) {
                prev.put(PdfName.Next, next);
                next.put(PdfName.Prev, prev);
            } else {
                prev.remove(PdfName.Next);
            }
        } else if (next != null) {
            next.remove(PdfName.Prev);
        }
    }
}

