/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf;

import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import cfca.sadk.com.itextpdf.kernel.pdf.colorspace.PdfShading;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PdfResources
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 7160318458835945391L;
    private static final String F = "F";
    private static final String Im = "Im";
    private static final String Fm = "Fm";
    private static final String Gs = "Gs";
    private static final String Pr = "Pr";
    private static final String Cs = "Cs";
    private static final String P = "P";
    private static final String Sh = "Sh";
    private Map<PdfObject, PdfName> resourceToName = new HashMap<PdfObject, PdfName>();
    private ResourceNameGenerator fontNamesGen = new ResourceNameGenerator(PdfName.Font, "F");
    private ResourceNameGenerator imageNamesGen = new ResourceNameGenerator(PdfName.XObject, "Im");
    private ResourceNameGenerator formNamesGen = new ResourceNameGenerator(PdfName.XObject, "Fm");
    private ResourceNameGenerator egsNamesGen = new ResourceNameGenerator(PdfName.ExtGState, "Gs");
    private ResourceNameGenerator propNamesGen = new ResourceNameGenerator(PdfName.Properties, "Pr");
    private ResourceNameGenerator csNamesGen = new ResourceNameGenerator(PdfName.ColorSpace, "Cs");
    private ResourceNameGenerator patternNamesGen = new ResourceNameGenerator(PdfName.Pattern, "P");
    private ResourceNameGenerator shadingNamesGen = new ResourceNameGenerator(PdfName.Shading, "Sh");
    private boolean readOnly = false;
    private boolean isModified = false;

    public PdfResources(PdfDictionary pdfObject) {
        super(pdfObject);
        this.buildResources(pdfObject);
    }

    public PdfResources() {
        this(new PdfDictionary());
    }

    public PdfName addFont(PdfDocument pdfDocument, PdfFont font) {
        pdfDocument.addFont(font);
        return this.addResource(font, this.fontNamesGen);
    }

    public PdfName addImage(PdfImageXObject image) {
        return this.addResource(image, this.imageNamesGen);
    }

    public PdfName addImage(PdfStream image) {
        return this.addResource(image, this.imageNamesGen);
    }

    @Deprecated
    public PdfName addImage(PdfObject image) {
        if (image.getType() != 9) {
            throw new PdfException("Cannot add image to resources. The PdfObject type is {0}, but should be PdfStream.").setMessageParams(image.getClass().toString());
        }
        return this.addResource(image, this.imageNamesGen);
    }

    public PdfImageXObject getImage(PdfName name) {
        PdfStream image = this.getResource(PdfName.Image).getAsStream(name);
        return image != null ? new PdfImageXObject(image) : null;
    }

    public PdfName addForm(PdfFormXObject form) {
        return this.addResource(form, this.formNamesGen);
    }

    public PdfName addForm(PdfStream form) {
        return this.addResource(form, this.formNamesGen);
    }

    @Deprecated
    public PdfName addForm(PdfObject form) {
        if (form.getType() != 9) {
            throw new PdfException("Cannot add form to resources. The PdfObject type is {0}, but should be PdfStream.").setMessageParams(form.getClass().toString());
        }
        return this.addResource(form, this.formNamesGen);
    }

    public PdfName addForm(PdfFormXObject form, PdfName name) {
        if (this.getResourceNames(PdfName.XObject).contains(name)) {
            name = this.addResource(form, this.formNamesGen);
        } else {
            this.addResource((PdfObject)form.getPdfObject(), PdfName.XObject, name);
        }
        return name;
    }

    public PdfFormXObject getForm(PdfName name) {
        PdfStream form = this.getResource(PdfName.Form).getAsStream(name);
        return form != null ? new PdfFormXObject(form) : null;
    }

    public PdfName addExtGState(PdfExtGState extGState) {
        return this.addResource(extGState, this.egsNamesGen);
    }

    public PdfName addExtGState(PdfDictionary extGState) {
        return this.addResource(extGState, this.egsNamesGen);
    }

    @Deprecated
    public PdfName addExtGState(PdfObject extGState) {
        if (extGState.getType() != 3) {
            throw new PdfException("Cannot add graphic state to resources. The PdfObject type is {0}, but should be PdfDictionary.").setMessageParams(extGState.getClass().toString());
        }
        return this.addResource(extGState, this.egsNamesGen);
    }

    public PdfExtGState getPdfExtGState(PdfName name) {
        PdfDictionary dic = this.getResource(PdfName.ExtGState).getAsDictionary(name);
        return dic != null ? new PdfExtGState(dic) : null;
    }

    public PdfName addProperties(PdfDictionary properties) {
        return this.addResource(properties, this.propNamesGen);
    }

    @Deprecated
    public PdfName addProperties(PdfObject properties) {
        if (properties.getType() != 3) {
            throw new PdfException("Cannot add properties to resources. The PdfObject type is {0}, but should be PdfDictionary.").setMessageParams(properties.getClass().toString());
        }
        return this.addResource(properties, this.propNamesGen);
    }

    public PdfObject getProperties(PdfName name) {
        return this.getResourceObject(PdfName.Properties, name);
    }

    public PdfName addColorSpace(PdfColorSpace cs) {
        return this.addResource(cs, this.csNamesGen);
    }

    public PdfName addColorSpace(PdfObject colorSpace) {
        return this.addResource(colorSpace, this.csNamesGen);
    }

    public PdfColorSpace getColorSpace(PdfName name) {
        PdfObject colorSpace = this.getResourceObject(PdfName.ColorSpace, name);
        return colorSpace != null ? PdfColorSpace.makeColorSpace(colorSpace) : null;
    }

    public PdfName addPattern(PdfPattern pattern) {
        return this.addResource(pattern, this.patternNamesGen);
    }

    public PdfName addPattern(PdfDictionary pattern) {
        return this.addResource(pattern, this.patternNamesGen);
    }

    @Deprecated
    public PdfName addPattern(PdfObject pattern) {
        if (pattern instanceof PdfDictionary) {
            throw new PdfException("Cannot add pattern to resources. The PdfObject type is {0}, but should be PdfDictionary or PdfStream.").setMessageParams(pattern.getClass().toString());
        }
        return this.addResource(pattern, this.patternNamesGen);
    }

    public PdfPattern getPattern(PdfName name) {
        PdfObject pattern = this.getResourceObject(PdfName.Pattern, name);
        return pattern instanceof PdfDictionary ? PdfPattern.getPatternInstance((PdfDictionary)pattern) : null;
    }

    public PdfName addShading(PdfShading shading) {
        return this.addResource(shading, this.shadingNamesGen);
    }

    public PdfName addShading(PdfDictionary shading) {
        return this.addResource(shading, this.shadingNamesGen);
    }

    @Deprecated
    public PdfName addShading(PdfObject shading) {
        if (shading instanceof PdfDictionary) {
            throw new PdfException("Cannot add shading to resources. The PdfObject type is {0}, but should be PdfDictionary or PdfStream.").setMessageParams(shading.getClass().toString());
        }
        return this.addResource(shading, this.shadingNamesGen);
    }

    public PdfShading getShading(PdfName name) {
        PdfObject shading = this.getResourceObject(PdfName.Shading, name);
        return shading instanceof PdfDictionary ? PdfShading.makeShading((PdfDictionary)shading) : null;
    }

    protected boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected boolean isModified() {
        return this.isModified;
    }

    protected void setModified(boolean isModified) {
        this.isModified = isModified;
    }

    @Deprecated
    public void setDefaultColorSpace(PdfName defaultCsKey, PdfColorSpace defaultCsValue) {
        if (!(defaultCsKey.equals(PdfName.DefaultCMYK) || defaultCsKey.equals(PdfName.DefaultGray) || defaultCsKey.equals(PdfName.DefaultRGB))) {
            throw new PdfException("Unsupported default color space name. Was {0}, but should be DefaultCMYK, DefaultGray or DefaultRGB").setMessageParams(defaultCsKey.toString());
        }
        this.addResource((PdfObject)defaultCsValue.getPdfObject(), PdfName.ColorSpace, defaultCsKey);
    }

    public void setDefaultGray(PdfColorSpace defaultCs) {
        this.addResource((PdfObject)defaultCs.getPdfObject(), PdfName.ColorSpace, PdfName.DefaultGray);
    }

    public void setDefaultRgb(PdfColorSpace defaultCs) {
        this.addResource((PdfObject)defaultCs.getPdfObject(), PdfName.ColorSpace, PdfName.DefaultRGB);
    }

    public void setDefaultCmyk(PdfColorSpace defaultCs) {
        this.addResource((PdfObject)defaultCs.getPdfObject(), PdfName.ColorSpace, PdfName.DefaultCMYK);
    }

    public <T extends PdfObject> PdfName getResourceName(PdfObjectWrapper<T> resource) {
        return this.getResourceName((PdfObject)resource.getPdfObject());
    }

    public PdfName getResourceName(PdfObject resource) {
        PdfName resName = this.resourceToName.get(resource);
        if (resName == null) {
            resName = this.resourceToName.get(resource.getIndirectReference());
        }
        return resName;
    }

    public Set<PdfName> getResourceNames() {
        TreeSet<PdfName> names = new TreeSet<PdfName>();
        for (PdfName resType : ((PdfDictionary)this.getPdfObject()).keySet()) {
            names.addAll(this.getResourceNames(resType));
        }
        return names;
    }

    public PdfArray getProcSet() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.ProcSet);
    }

    public void setProcSet(PdfArray array) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ProcSet, array);
    }

    public Set<PdfName> getResourceNames(PdfName resType) {
        PdfDictionary resourceCategory = ((PdfDictionary)this.getPdfObject()).getAsDictionary(resType);
        return resourceCategory == null ? new TreeSet() : resourceCategory.keySet();
    }

    public PdfDictionary getResource(PdfName resType) {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(resType);
    }

    public PdfObject getResourceObject(PdfName resType, PdfName resName) {
        PdfDictionary resource = this.getResource(resType);
        if (resource != null) {
            return resource.get(resName);
        }
        return null;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    <T extends PdfObject> PdfName addResource(PdfObjectWrapper<T> resource, ResourceNameGenerator nameGen) {
        return this.addResource((PdfObject)resource.getPdfObject(), nameGen);
    }

    protected void addResource(PdfObject resource, PdfName resType, PdfName resName) {
        if (resType.equals(PdfName.XObject)) {
            this.checkAndResolveCircularReferences(resource);
        }
        if (this.readOnly) {
            this.setPdfObject(((PdfDictionary)this.getPdfObject()).clone(Collections.<PdfName>emptyList()));
            this.buildResources((PdfDictionary)this.getPdfObject());
            this.isModified = true;
            this.readOnly = false;
        }
        if (((PdfDictionary)this.getPdfObject()).containsKey(resType) && ((PdfDictionary)this.getPdfObject()).getAsDictionary(resType).containsKey(resName)) {
            return;
        }
        this.resourceToName.put(resource, resName);
        PdfDictionary resourceCategory = ((PdfDictionary)this.getPdfObject()).getAsDictionary(resType);
        if (resourceCategory == null) {
            resourceCategory = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(resType, resourceCategory);
        } else {
            PdfIndirectReference indirectReference = resourceCategory.getIndirectReference();
            if (null != indirectReference) {
                resourceCategory.setModified();
            }
        }
        resourceCategory.put(resName, resource);
        PdfDictionary resDictionary = (PdfDictionary)((PdfDictionary)this.getPdfObject()).get(resType);
        if (resDictionary == null) {
            resDictionary = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(resType, resDictionary);
        }
        resDictionary.put(resName, resource);
        try {
            if (resource != null && resource.getIndirectReference() != null) {
                PdfDocument pdfDoc = resource.getIndirectReference().getDocument();
                PdfAcroForm acroForm = PdfAcroForm.getAcroForm(pdfDoc, true);
                PdfDictionary defaultResDict = ((PdfDictionary)acroForm.getPdfObject()).getAsDictionary(PdfName.DR);
                PdfDictionary fontDict = defaultResDict.getAsDictionary(PdfName.Font);
                fontDict.put(resName, resource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    PdfName addResource(PdfObject resource, ResourceNameGenerator nameGen) {
        PdfName resName = this.getResourceName(resource);
        if (resName == null) {
            resName = nameGen.generate(this);
            this.addResource(resource, nameGen.getResourceType(), resName);
        }
        return resName;
    }

    protected void buildResources(PdfDictionary dictionary) {
        for (PdfName resourceType : dictionary.keySet()) {
            PdfDictionary resources;
            if (((PdfDictionary)this.getPdfObject()).get(resourceType) == null) {
                ((PdfDictionary)this.getPdfObject()).put(resourceType, new PdfDictionary());
            }
            if ((resources = dictionary.getAsDictionary(resourceType)) == null) continue;
            for (PdfName resourceName : resources.keySet()) {
                PdfObject resource = resources.get(resourceName, false);
                this.resourceToName.put(resource, resourceName);
            }
        }
    }

    private void checkAndResolveCircularReferences(PdfObject pdfObject) {
        PdfDictionary pdfXObject;
        PdfObject pdfXObjectResources;
        if (pdfObject instanceof PdfDictionary && !pdfObject.isFlushed() && (pdfXObjectResources = (pdfXObject = (PdfDictionary)pdfObject).get(PdfName.Resources)) != null && pdfXObjectResources.getIndirectReference() != null && pdfXObjectResources.getIndirectReference().equals(((PdfDictionary)this.getPdfObject()).getIndirectReference())) {
            PdfObject cloneResources = ((PdfDictionary)this.getPdfObject()).clone();
            cloneResources.makeIndirect(((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument());
            pdfXObject.put(PdfName.Resources, cloneResources.getIndirectReference());
        }
    }

    static class ResourceNameGenerator
    implements Serializable {
        private static final long serialVersionUID = 1729961083476558303L;
        private PdfName resourceType;
        private int counter;
        private String prefix;

        public ResourceNameGenerator(PdfName resourceType, String prefix, int seed) {
            this.prefix = prefix;
            this.resourceType = resourceType;
            this.counter = seed;
        }

        public ResourceNameGenerator(PdfName resourceType, String prefix) {
            this(resourceType, prefix, 1);
        }

        public PdfName getResourceType() {
            return this.resourceType;
        }

        public PdfName generate(PdfResources resources) {
            PdfName newName = new PdfName(this.prefix + this.counter++);
            PdfDictionary r = (PdfDictionary)resources.getPdfObject();
            if (r.containsKey(this.resourceType)) {
                while (r.getAsDictionary(this.resourceType).containsKey(newName)) {
                    newName = new PdfName(this.prefix + this.counter++);
                }
            }
            return newName;
        }
    }
}

