/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.kernel.geom.LineSegment;
import cfca.sadk.com.itextpdf.kernel.geom.Matrix;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.geom.Vector;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasTag;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.EventType;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.KeywordProcessTool;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.ITextChunkLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.ITextChunkLocationStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.TextChunk;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.TextChunkComparator;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.TextChunkLocationComparator;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.keyword.TextChunkLocationDefaultImp;
import cfca.sadk.seal.base.util.KMPUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class KeywordLocationExtractionStrategy
implements ILocationExtractionStrategy {
    private int[] kmpnext = null;
    private String keyword = null;
    private static boolean DUMP_STATE = false;
    private static final float DIACRITICAL_MARKS_ALLOWED_VERTICAL_DEVIATION = 2.0f;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    private final ITextChunkLocationStrategy tclStrat;
    private boolean useActualText = false;
    private boolean rightToLeftRunDirection = false;
    private TextRenderInfo lastTextRenderInfo;
    private boolean ignoreCharNumSpace = true;
    private static final float ROTATION_PRECISION = 0.001f;

    public KeywordLocationExtractionStrategy() {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
    }

    public KeywordLocationExtractionStrategy(String keyword, int[] kmpnext, String originKeyword) {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
        this.keyword = keyword;
        this.kmpnext = kmpnext;
    }

    public KeywordLocationExtractionStrategy(String keyword, int[] kmpnext, boolean ignoreCharNumSpace) {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
        this.keyword = keyword;
        this.kmpnext = kmpnext;
        this.ignoreCharNumSpace = ignoreCharNumSpace;
        boolean isChinese = false;
        for (int i = 0; i < keyword.length(); ++i) {
            if (keyword.codePointAt(i) != keyword.charAt(i)) {
                ++i;
                continue;
            }
            isChinese = KMPUtil.isChinese(keyword.charAt(i));
            if (!isChinese) break;
        }
        if (isChinese) {
            this.ignoreCharNumSpace = true;
        }
    }

    public KeywordLocationExtractionStrategy(ITextChunkLocationStrategy strat) {
        this.tclStrat = strat;
    }

    public KeywordLocationExtractionStrategy setUseActualText(boolean useActualText) {
        this.useActualText = useActualText;
        return this;
    }

    public KeywordLocationExtractionStrategy setRightToLeftRunDirection(boolean rightToLeftRunDirection) {
        this.rightToLeftRunDirection = rightToLeftRunDirection;
        return this;
    }

    public boolean isUseActualText() {
        return this.useActualText;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type.equals((Object)EventType.RENDER_TEXT)) {
            TextRenderInfo renderInfo = (TextRenderInfo)data;
            LineSegment segment = renderInfo.getBaseline();
            if (renderInfo.getRise() != 0.0f) {
                Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
                segment = segment.transformBy(riseOffsetTransform);
            }
            if (this.useActualText) {
                CanvasTag lastTagWithActualText;
                CanvasTag canvasTag = lastTagWithActualText = this.lastTextRenderInfo != null ? this.findLastTagWithActualText(this.lastTextRenderInfo.getCanvasTagHierarchy()) : null;
                if (lastTagWithActualText != null && lastTagWithActualText == this.findLastTagWithActualText(renderInfo.getCanvasTagHierarchy())) {
                    TextChunk lastTextChunk = this.locationalResult.get(this.locationalResult.size() - 1);
                    Vector mergedStart = new Vector(Math.min(lastTextChunk.getLocation().getStartLocation().get(0), segment.getStartPoint().get(0)), Math.min(lastTextChunk.getLocation().getStartLocation().get(1), segment.getStartPoint().get(1)), Math.min(lastTextChunk.getLocation().getStartLocation().get(2), segment.getStartPoint().get(2)));
                    Vector mergedEnd = new Vector(Math.max(lastTextChunk.getLocation().getEndLocation().get(0), segment.getEndPoint().get(0)), Math.max(lastTextChunk.getLocation().getEndLocation().get(1), segment.getEndPoint().get(1)), Math.max(lastTextChunk.getLocation().getEndLocation().get(2), segment.getEndPoint().get(2)));
                    TextChunk merged = new TextChunk(lastTextChunk.getText(), this.tclStrat.createLocation(renderInfo, new LineSegment(mergedStart, mergedEnd)));
                    this.locationalResult.set(this.locationalResult.size() - 1, merged);
                } else {
                    String actualText = renderInfo.getActualText();
                    TextChunk tc = new TextChunk(actualText != null ? actualText : renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
                    this.locationalResult.add(tc);
                }
            } else {
                TextChunk tc = new TextChunk(renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment), renderInfo.getFont(), segment, renderInfo.getAscentLine(), renderInfo.getDescentLine());
                this.locationalResult.add(tc);
            }
            this.lastTextRenderInfo = renderInfo;
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return null;
    }

    public String getResultantText() {
        if (DUMP_STATE) {
            this.dumpState();
        }
        ArrayList<TextChunk> textChunks = new ArrayList<TextChunk>(this.locationalResult);
        this.sortWithMarks(textChunks);
        StringBuilder sb = new StringBuilder();
        TextChunk lastChunk = null;
        for (TextChunk chunk : textChunks) {
            if (lastChunk == null) {
                sb.append(chunk.getText());
            } else if (chunk.sameLine(lastChunk)) {
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.getText()) && !this.endsWithSpace(lastChunk.getText())) {
                    sb.append(' ');
                }
                sb.append(chunk.getText());
            } else {
                sb.append('\n');
                sb.append(chunk.getText());
            }
            lastChunk = chunk;
        }
        return sb.toString();
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        return chunk.getLocation().isAtWordBoundary(previousChunk.getLocation());
    }

    private boolean startsWithSpace(String str) {
        return str.length() != 0 && str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        return str.length() != 0 && str.charAt(str.length() - 1) == ' ';
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
        }
    }

    private CanvasTag findLastTagWithActualText(List<CanvasTag> canvasTagHierarchy) {
        CanvasTag lastActualText = null;
        for (CanvasTag tag : canvasTagHierarchy) {
            if (tag.getActualText() == null) continue;
            lastActualText = tag;
            break;
        }
        return lastActualText;
    }

    private void sortWithMarks(List<TextChunk> textChunks) {
        HashMap<TextChunk, TextChunkMarks> marks = new HashMap<TextChunk, TextChunkMarks>();
        ArrayList<TextChunk> toSort = new ArrayList<TextChunk>();
        for (int markInd = 0; markInd < textChunks.size(); ++markInd) {
            ITextChunkLocation location = textChunks.get(markInd).getLocation();
            if (location.getStartLocation().equals(location.getEndLocation())) {
                boolean foundBaseToAttachTo = false;
                for (int baseInd = 0; baseInd < textChunks.size(); ++baseInd) {
                    ITextChunkLocation baseLocation;
                    if (markInd == baseInd || (baseLocation = textChunks.get(baseInd).getLocation()).getStartLocation().equals(baseLocation.getEndLocation()) || !this.containsMark(baseLocation, location)) continue;
                    TextChunkMarks currentMarks = (TextChunkMarks)marks.get(textChunks.get(baseInd));
                    if (currentMarks == null) {
                        currentMarks = new TextChunkMarks();
                        marks.put(textChunks.get(baseInd), currentMarks);
                    }
                    if (markInd < baseInd) {
                        currentMarks.preceding.add(textChunks.get(markInd));
                    } else {
                        currentMarks.succeeding.add(textChunks.get(markInd));
                    }
                    foundBaseToAttachTo = true;
                    break;
                }
                if (foundBaseToAttachTo) continue;
                toSort.add(textChunks.get(markInd));
                continue;
            }
            toSort.add(textChunks.get(markInd));
        }
        if (this.rightToLeftRunDirection) {
            Collections.sort(toSort, new TextChunkComparator(new TextChunkLocationComparator(false)));
        } else {
            Collections.sort(toSort);
        }
        textChunks.clear();
        for (TextChunk current : toSort) {
            int j;
            TextChunkMarks currentMarks = (TextChunkMarks)marks.get(current);
            if (currentMarks != null) {
                if (!this.rightToLeftRunDirection) {
                    for (j = 0; j < currentMarks.preceding.size(); ++j) {
                        textChunks.add(currentMarks.preceding.get(j));
                    }
                } else {
                    for (j = currentMarks.succeeding.size() - 1; j >= 0; --j) {
                        textChunks.add(currentMarks.succeeding.get(j));
                    }
                }
            }
            textChunks.add(current);
            if (currentMarks == null) continue;
            if (!this.rightToLeftRunDirection) {
                for (j = 0; j < currentMarks.succeeding.size(); ++j) {
                    textChunks.add(currentMarks.succeeding.get(j));
                }
                continue;
            }
            for (j = currentMarks.preceding.size() - 1; j >= 0; --j) {
                textChunks.add(currentMarks.preceding.get(j));
            }
        }
    }

    private boolean containsMark(ITextChunkLocation baseLocation, ITextChunkLocation markLocation) {
        return baseLocation.getStartLocation().get(0) <= markLocation.getStartLocation().get(0) && baseLocation.getEndLocation().get(0) >= markLocation.getEndLocation().get(0) && (float)Math.abs(baseLocation.distPerpendicular() - markLocation.distPerpendicular()) <= 2.0f;
    }

    @Override
    public Collection<IPdfTextLocation> getResultantLocations() {
        HashMap<Integer, Integer> chunkPositions = new HashMap<Integer, Integer>();
        StringBuilder sb = new StringBuilder();
        ArrayList<IPdfTextLocation> retval = new ArrayList();
        int totalChars = 0;
        TextChunk lastChunk = null;
        for (int i = 0; i < this.locationalResult.size(); ++i) {
            TextChunk chunk = this.locationalResult.get(i);
            String text = chunk.getText();
            if (lastChunk != null && this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.getText()) && !this.endsWithSpace(lastChunk.getText())) {
                text = ' ' + text;
            }
            sb.append(text);
            for (int j = 0; j < text.length(); ++j) {
                chunkPositions.put(totalChars, i);
                ++totalChars;
            }
            lastChunk = chunk;
        }
        retval = this.getKeywordList(sb.toString(), chunkPositions, this.ignoreCharNumSpace);
        Collections.sort(retval, new Comparator<IPdfTextLocation>(){

            @Override
            public int compare(IPdfTextLocation l1, IPdfTextLocation l2) {
                Vector orientationVector = l1.getOrientationVector();
                Rectangle o1 = l1.getRectangle();
                Rectangle o2 = l2.getRectangle();
                if (Math.abs(orientationVector.get(0) - 1.0f) < 0.001f) {
                    if (o1.getY() == o2.getY()) {
                        return o1.getX() == o2.getX() ? 0 : (o1.getX() < o2.getX() ? -1 : 1);
                    }
                    return o1.getY() < o2.getY() ? 1 : -1;
                }
                if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) {
                    if (o1.getX() == o2.getX()) {
                        return o1.getY() == o2.getY() ? 0 : (o1.getY() < o2.getY() ? -1 : 1);
                    }
                    return o1.getX() < o2.getX() ? -1 : 1;
                }
                if (Math.abs(orientationVector.get(0) + 1.0f) < 0.001f) {
                    if (o1.getY() == o2.getY()) {
                        return o1.getX() == o2.getX() ? 0 : (o1.getX() < o2.getX() ? 1 : -1);
                    }
                    return o1.getY() < o2.getY() ? -1 : 1;
                }
                if (Math.abs(orientationVector.get(1) + 1.0f) < 0.001f) {
                    if (o1.getX() == o2.getX()) {
                        return o1.getY() == o2.getY() ? 0 : (o1.getY() < o2.getY() ? 1 : -1);
                    }
                    return o1.getX() < o2.getX() ? 1 : -1;
                }
                return 0;
            }
        });
        this.reset();
        return retval;
    }

    private List<IPdfTextLocation> getKeywordList(String pageWords, HashMap<Integer, Integer> chunkPositions, boolean ignoreCharNumSpace) {
        KeywordProcessTool processor = new KeywordProcessTool();
        List<IPdfTextLocation> retval = processor.getKeywordLocation(pageWords, chunkPositions, this.keyword, this.kmpnext, this.locationalResult, ignoreCharNumSpace, true);
        return retval;
    }

    public void reset() {
        this.locationalResult.clear();
    }

    private static class TextChunkMarks {
        List<TextChunk> preceding = new ArrayList<TextChunk>();
        List<TextChunk> succeeding = new ArrayList<TextChunk>();

        private TextChunkMarks() {
        }
    }
}

