/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.config;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.CrlManager;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public final class SysEnv {
    private static final Logger sysLog = LoggerFactory.getLogger(SysEnv.class);
    private static final String sealSADKConfigFile = "SealSADK7.ini";
    private static boolean crlLoaded = false;
    private static boolean trustCertLoaded = false;
    public static boolean isUseJNIForHash = true;
    public static boolean supportSVG = false;
    public static boolean changeSVG = false;
    public static boolean checkFontSizeOverflow = false;
    private static boolean checkTSA = true;
    private static boolean checkTSATrustCert = false;
    private static boolean acro6Layers = false;
    private static boolean useDPIChangeSize = true;
    private static boolean checkOutOfPage = false;
    private static boolean useCFCASubFilter = true;
    private static boolean ignoreTextFieldBolder = false;
    public static int defaultDPI = 96;
    private static long MAX_PDF_FILE_LENGTH = 0x6400000L;
    public static int RSAP7TSALength = 3072;
    public static int SM2P7TSALength = 3072;
    public static int diskPdfFileLength = 0x200000;
    private static int maxCRLRecode = 500000;
    private static float minRectWidth = 0.0f;
    private static int RESERVE_GB_SIG_LENGTH = 61440;

    public static boolean isUseJNIForHash() {
        return isUseJNIForHash;
    }

    public static void setUseJNIForHash(boolean isUseJNIForHash) {
        SysEnv.isUseJNIForHash = isUseJNIForHash;
    }

    public static int getDefaultDPI() {
        return defaultDPI;
    }

    public static void setDefaultDPI(int defaultDPI) {
        SysEnv.defaultDPI = defaultDPI;
    }

    public static boolean isCheckFontSizeOverflow() {
        return checkFontSizeOverflow;
    }

    public static void setCheckFontSizeOverflow(boolean checkFontSizeOverflow) {
        SysEnv.checkFontSizeOverflow = checkFontSizeOverflow;
    }

    public static boolean isSupportSVG() {
        return supportSVG;
    }

    public static void setSupportSVG(boolean supportSVG) {
        SysEnv.supportSVG = supportSVG;
    }

    public static int getDiskPdfFileLength() {
        return diskPdfFileLength;
    }

    public static void setDiskPdfFileLength(int diskPdfFileLength) {
        SysEnv.diskPdfFileLength = diskPdfFileLength;
    }

    public static int getMaxCRLRecode() {
        return maxCRLRecode;
    }

    public static void setMaxCRLRecode(int maxCRLRecode) {
        SysEnv.maxCRLRecode = maxCRLRecode;
    }

    public static boolean isCrlLoaded() {
        return crlLoaded;
    }

    public static boolean isTrustCertLoaded() {
        return trustCertLoaded;
    }

    public static float getMinRectWidth() {
        return minRectWidth;
    }

    public static void setMinRectWidth(float minRectWidth) {
        SysEnv.minRectWidth = minRectWidth;
    }

    public static boolean isAcro6Layers() {
        return acro6Layers;
    }

    public static void setAcro6Layers(boolean acro6Layers) {
        SysEnv.acro6Layers = acro6Layers;
    }

    public static boolean isChangeSVG() {
        return changeSVG;
    }

    public static void setChangeSVG(boolean changeSVG) {
        SysEnv.changeSVG = changeSVG;
    }

    public static boolean isUseDPIChangeSize() {
        return useDPIChangeSize;
    }

    public static void setUseDPIChangeSize(boolean useDPIChangeSize) {
        SysEnv.useDPIChangeSize = useDPIChangeSize;
    }

    public static boolean isCheckOutOfPage() {
        return checkOutOfPage;
    }

    public static void setCheckOutOfPage(boolean checkOutOfPage) {
        SysEnv.checkOutOfPage = checkOutOfPage;
    }

    public static void loadCRL(String crlFilePath) throws PKIException, SealException, IOException {
        CrlManager.init(crlFilePath);
        crlLoaded = true;
        sysLog.info("CRL File is loaded,filePath is " + crlFilePath);
    }

    public static void loadTrustCerts(String trustCertPath) throws PKIException {
        if (null == trustCertPath || trustCertPath.isEmpty()) {
            throw new IllegalArgumentException("trustCertPath is null!");
        }
        File trustCertDir = new File(trustCertPath);
        ArrayList<X509Cert> trustCertList = new ArrayList<X509Cert>();
        if (trustCertDir.isDirectory()) {
            File[] files = trustCertDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().toLowerCase().endsWith(".cer")) continue;
                String filePath = files[i].getAbsolutePath();
                trustCertList.add(new X509Cert(filePath));
            }
        }
        if (trustCertList.size() == 0) {
            throw new IllegalArgumentException(trustCertPath + " is empty,trustCert File is not loaded");
        }
        for (int j = 0; j < trustCertList.size(); ++j) {
            X509CertVerifier.updateTrustCertsMap((X509Cert)((X509Cert)trustCertList.get(j)));
            trustCertLoaded = true;
        }
        sysLog.info("trustCert File is loaded,filePath is " + trustCertPath);
    }

    public static boolean isUseCFCASubFilter() {
        return useCFCASubFilter;
    }

    public static void setUseCFCASubFilter(boolean useCFCASubFilter) {
        SysEnv.useCFCASubFilter = useCFCASubFilter;
    }

    public static boolean isCheckTSA() {
        return checkTSA;
    }

    public static void setCheckTSA(boolean checkTSA) {
        SysEnv.checkTSA = checkTSA;
    }

    public static long getMaxPdfFileLength() {
        return MAX_PDF_FILE_LENGTH;
    }

    public static void setMaxPdfFileLength(long maxPdfFileLength) {
        MAX_PDF_FILE_LENGTH = maxPdfFileLength;
    }

    public static int getRESERVE_GB_SIG_LENGTH() {
        return RESERVE_GB_SIG_LENGTH;
    }

    public static void setRESERVE_GB_SIG_LENGTH(int rESERVE_GB_SIG_LENGTH) {
        RESERVE_GB_SIG_LENGTH = rESERVE_GB_SIG_LENGTH;
    }

    public static boolean isCheckTSATrustCert() {
        return checkTSATrustCert;
    }

    public static void setCheckTSATrustCert(boolean checkTSATrustCert) {
        SysEnv.checkTSATrustCert = checkTSATrustCert;
    }

    public static boolean isIgnoreTextFieldBolder() {
        return ignoreTextFieldBolder;
    }

    public static void setIgnoreTextFieldBolder(boolean ignoreTextFieldBolder) {
        SysEnv.ignoreTextFieldBolder = ignoreTextFieldBolder;
    }

    public static void loadConfigFile(String filePath) {
        try {
            sysLog.info("config file path is:" + filePath);
            if (null != filePath) {
                File configFile = new File(filePath);
                if (null != configFile && configFile.exists()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(configFile));
                    SysEnv.parseProperties(properties);
                } else {
                    sysLog.info(filePath + " is not found!");
                }
            }
        }
        catch (Exception e) {
            sysLog.info("SysEnv init failed", (Throwable)e);
        }
    }

    private static void parseProperties(Properties properties) {
        String p_RESERVE_GB_SIG_LENGTH;
        String p_maxCRLRecode;
        String p_SM2P7TSALength;
        String p_RSAP7TSALength;
        String p_MAX_PDF_FILE_LENGTH;
        String p_isUseJNIForHash = properties.getProperty("isUseJNIForHash", "true");
        isUseJNIForHash = p_isUseJNIForHash == null || !"false".equals(p_isUseJNIForHash);
        String p_supportSVG = properties.getProperty("supportSVG", "false");
        supportSVG = p_supportSVG != null && "true".equals(p_supportSVG);
        String p_changeSVG = properties.getProperty("changeSVG", "false");
        changeSVG = p_changeSVG != null && "true".equals(p_changeSVG);
        String p_checkFontSizeOverflow = properties.getProperty("checkFontSizeOverflow", "false");
        checkFontSizeOverflow = p_checkFontSizeOverflow != null && "true".equals(p_checkFontSizeOverflow);
        String p_ignoreTextFieldBolder = properties.getProperty("ignoreTextFieldBolder", "false");
        ignoreTextFieldBolder = p_ignoreTextFieldBolder != null && "true".equals(p_ignoreTextFieldBolder);
        String p_useDPIChangeSize = properties.getProperty("useDPIChangeSize", "true");
        useDPIChangeSize = p_useDPIChangeSize == null || !"false".equals(p_useDPIChangeSize);
        String p_checkOutOfPage = properties.getProperty("checkOutOfPage", "false");
        checkOutOfPage = p_checkOutOfPage != null && "true".equals(p_checkOutOfPage);
        String p_acro6Layers = properties.getProperty("acro6Layers", "false");
        acro6Layers = p_acro6Layers != null && "true".equals(p_acro6Layers);
        String p_useCFCASubFilter = properties.getProperty("useCFCASubFilter", "true");
        useCFCASubFilter = p_useCFCASubFilter == null || !"false".equals(p_useCFCASubFilter);
        String p_checkTSA = properties.getProperty("checkTSA", "true");
        checkTSA = p_checkTSA == null || !"false".equals(p_checkTSA);
        String p_checkTSATrustCert = properties.getProperty("checkTSATrustCert", "false");
        checkTSATrustCert = p_checkTSATrustCert != null && "true".equals(p_checkTSATrustCert);
        String p_defaultDPI = properties.getProperty("defaultDPI", "96");
        if (p_defaultDPI != null) {
            defaultDPI = Integer.parseInt(p_defaultDPI);
        }
        if ((p_MAX_PDF_FILE_LENGTH = properties.getProperty("MAX_PDF_FILE_LENGTH", "104857600")) != null) {
            MAX_PDF_FILE_LENGTH = Long.parseLong(p_MAX_PDF_FILE_LENGTH);
        }
        if ((p_RSAP7TSALength = properties.getProperty("RSAP7TSALength", "3072")) != null) {
            RSAP7TSALength = Integer.parseInt(p_RSAP7TSALength);
        }
        if ((p_SM2P7TSALength = properties.getProperty("SM2P7TSALength", "3072")) != null) {
            SM2P7TSALength = Integer.parseInt(p_SM2P7TSALength);
        }
        if ((p_maxCRLRecode = properties.getProperty("maxCRLRecode", "500000")) != null) {
            maxCRLRecode = Integer.parseInt(p_maxCRLRecode);
        }
        if ((p_RESERVE_GB_SIG_LENGTH = properties.getProperty("RESERVE_GB_SIG_LENGTH", "61140")) != null) {
            RESERVE_GB_SIG_LENGTH = Integer.parseInt(p_RESERVE_GB_SIG_LENGTH);
        }
        sysLog.info("SysEnv init:" + properties);
    }

    static {
        try {
            Properties properties = new Properties();
            properties.load(SysEnv.class.getClassLoader().getResourceAsStream(sealSADKConfigFile));
            SysEnv.parseProperties(properties);
        }
        catch (Exception e) {
            sysLog.info("init SealSADK7.ini from jar failed", (Throwable)e);
        }
    }
}

