/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.Constants;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.PdfHashUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.security.GeneralSecurityException;

public class CFCANoCertP7Signer
extends AbstractExternalP7Signer {
    private static Logger businessLog = LoggerFactory.getLogger(CFCANoCertP7Signer.class);
    protected Mechanism mechanism = null;
    protected X509Cert signCert = null;
    private int estimatedSize = 8192;
    private byte[] hashValue = null;
    private boolean isSecondHash = false;

    public CFCANoCertP7Signer(SignInfoConfig signatureConfig) throws SealException {
        this.signInfoConfig = signatureConfig;
        this.mechanism = signatureConfig.getSignAlg();
        this.signCert = signatureConfig.getSignCert();
        this.isSecondHash = signatureConfig.isSecondHash();
    }

    @Override
    public void modifySigningDictionary(PdfDictionary signDic) {
        signDic.put(PdfName.Filter, PdfName.Adobe_PPKLite);
        if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
            signDic.put(PdfName.Filter, Constants.OLD_SM2_FILTER);
            if (this.isSecondHash) {
                signDic.put(PdfName.SubFilter, SysEnv.isUseCFCASubFilter() ? Constants.CFCA_SM2_ATTACH_FILTER : Constants.SM2_ATTACH_FILTER);
            } else {
                signDic.put(PdfName.SubFilter, SysEnv.isUseCFCASubFilter() ? Constants.CFCA_SM2_FILTER : Constants.SM2_FILTER);
            }
        } else if (this.isSecondHash && Mechanisms.M_SHA1_RSA.equals((Object)this.mechanism)) {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_sha1);
        } else {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_detached);
        }
    }

    @Override
    public byte[] sign(InputStream paramInputStream) throws GeneralSecurityException {
        byte[] hash = null;
        byte[] signedData = null;
        String methodid = MethodCostTimeUtil.recordStartTime("----CFCANoCertP7Signer.sign");
        try {
            if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
                SM2PublicKey sm2PublicKey = null;
                if (!this.isSecondHash && (sm2PublicKey = (SM2PublicKey)this.signCert.getPublicKey()) == null) {
                    throw new GeneralSecurityException("sm2PublicKey is null");
                }
                hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, this.mechanism, sm2PublicKey);
            } else {
                hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, this.mechanism, null);
            }
            this.hashValue = hash;
            String methodid2 = MethodCostTimeUtil.recordStartTime("----CFCANoCertP7Signer.sign.packagePKCS7");
            signedData = new byte[8192];
            MethodCostTimeUtil.recordEndTime(methodid2);
            this.estimatedSize = signedData.length;
            byte[] byArray = signedData;
            return byArray;
        }
        catch (GeneralSecurityException e) {
            businessLog.error("CFCANoCertP7Signer sign failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("CFCANoCertP7Signer sign failed", (Throwable)e);
            throw new GeneralSecurityException("CFCANoCertP7Signer sign failed", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public byte[] getHashValue() {
        return this.hashValue;
    }
}

