/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.FontFactory;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.sadk.com.google.typography.font.tools.sfnttool.GlyphCoverage;
import cfca.sadk.com.google.typography.font.tools.subsetter.RenumberingSubsetter;
import cfca.sadk.com.itextpdf.io.font.FontProgram;
import cfca.sadk.com.itextpdf.io.font.FontProgramFactory;
import cfca.sadk.com.itextpdf.io.font.otf.Glyph;
import cfca.sadk.com.itextpdf.io.source.ByteArrayOutputStream;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.font.PdfFontFactory;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FontsFactory {
    private static Logger businessLog = LoggerFactory.getLogger(FontsFactory.class);
    private Map<String, PdfFont> fontsMap = new ConcurrentHashMap<String, PdfFont>();
    private Map<String, FontInfo> fontInfoMap = new ConcurrentHashMap<String, FontInfo>();
    private static FontsFactory instance = new FontsFactory();

    public PdfFont createFont(String fontName) throws SealException {
        PdfFont newFont = null;
        FontInfo fontInfo = this.fontInfoMap.get(fontName);
        if (fontInfo != null) {
            newFont = fontInfo.createPdfFont();
        }
        return newFont;
    }

    private FontsFactory() {
    }

    public static FontsFactory getInstance() throws SealException {
        return instance;
    }

    public PdfFont getFont(String fontName) {
        PdfFont newFont = null;
        try {
            FontInfo fontInfo = this.fontInfoMap.get(fontName);
            if (fontInfo != null) {
                newFont = fontInfo.createPdfFont();
            }
        }
        catch (SealException e) {
            businessLog.error("createFont of " + fontName + " failed", (Throwable)e);
        }
        return newFont;
    }

    public void loadFonts(String fontPath) throws SealException {
        boolean hasCorrectFont = false;
        if (null != fontPath) {
            File dir = new File(fontPath);
            if (null != dir && dir.isDirectory()) {
                File[] fontFiles = dir.listFiles();
                for (int i = 0; i < fontFiles.length; ++i) {
                    String fontFile = fontFiles[i].getAbsolutePath();
                    String fontFileName = fontFiles[i].getName().toLowerCase();
                    if (!fontFileName.endsWith(".ttf") && !fontFileName.endsWith(".otf")) continue;
                    FontInfo fontInfo = new FontInfo(fontFile);
                    PdfFont pdfFont = fontInfo.createPdfFont();
                    this.fontsMap.put(fontInfo.getFontName(), pdfFont);
                    this.fontInfoMap.put(fontInfo.getFontName(), fontInfo);
                    this.fontsMap.put(fontInfo.getFontName().toLowerCase(), pdfFont);
                    this.fontInfoMap.put(fontInfo.getFontName().toLowerCase(), fontInfo);
                    hasCorrectFont = true;
                }
            } else {
                throw new SealException("fontPath is wrong!");
            }
            businessLog.info("loat fonts: " + this.fontsMap.keySet());
            if (!hasCorrectFont) {
                throw new SealException("no font loaded,file type need ttf or otf format!");
            }
        } else {
            throw new SealException("fontPath is null!");
        }
    }

    public PdfFont getSubSetFont(String fontName, String content, boolean isThrowException) throws SealException {
        FontInfo fontInfo = this.fontInfoMap.get(fontName);
        if (null != fontInfo) {
            return fontInfo.subsetFont(content);
        }
        if (isThrowException) {
            throw new SealException("fontName =" + fontName + ", fontInfo is not found");
        }
        return null;
    }

    public PdfFont getSubSetFont(String fontName, String content) throws SealException {
        return this.getSubSetFont(fontName, content, true);
    }

    public Set<String> getFontNames() {
        return this.fontInfoMap.keySet();
    }

    public class FontInfo {
        private FontProgram fontProgram = null;
        private FontFactory fontFactory = FontFactory.getInstance();
        private Font[] fontArray = null;
        private Set<Integer> removeTables = new HashSet<Integer>();
        private List<CMapTable.CMapId> cmapIds = new ArrayList<CMapTable.CMapId>();
        private static final float NEED_CALCULATA = 0.0f;

        private FontInfo(String ttfTile) throws SealException {
            FileInputStream fis = null;
            try {
                this.fontProgram = FontProgramFactory.createFont(ttfTile, false);
                File fontFile = new File(ttfTile);
                fis = new FileInputStream(fontFile);
                byte[] fontBytes = new byte[(int)fontFile.length()];
                fis.read(fontBytes);
                this.fontArray = this.fontFactory.loadFonts(fontBytes);
                this.cmapIds.add(CMapTable.CMapId.WINDOWS_BMP);
                this.removeTables.add(Tag.BASE);
                this.removeTables.add(Tag.GDEF);
                this.removeTables.add(Tag.GPOS);
                this.removeTables.add(Tag.GSUB);
                this.removeTables.add(Tag.JSTF);
                this.removeTables.add(Tag.DSIG);
                this.removeTables.add(Tag.gasp);
                this.removeTables.add(Tag.hdmx);
                this.removeTables.add(Tag.kern);
                this.removeTables.add(Tag.LTSH);
                this.removeTables.add(Tag.PCLT);
                this.removeTables.add(Tag.VDMX);
                this.removeTables.add(Tag.vhea);
                this.removeTables.add(Tag.vmtx);
                this.removeTables.add(Tag.EBLC);
                this.removeTables.add(Tag.EBDT);
                this.removeTables.add(Tag.EBSC);
                this.removeTables.add(Tag.CFF);
                this.removeTables.add(Tag.VORG);
                this.removeTables.add(Tag.maxp);
                this.removeTables.add(Tag.fpgm);
                this.removeTables.add(Tag.prep);
                this.removeTables.add(Tag.cvt);
                this.removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 116}));
                this.removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 120}));
            }
            catch (FileNotFoundException e) {
                businessLog.error("FileNotFoundException", (Throwable)e);
                throw new SealException("FontUtil getInstance() FileNotFoundException", e);
            }
            catch (IOException e) {
                businessLog.error("IOException", (Throwable)e);
                throw new SealException("FontUtil getInstance() IOException", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new SealException("FontUtil close() IOException", e);
                    }
                }
            }
        }

        public PdfFont subsetFont(String signString) throws SealException {
            PdfFont font = null;
            String methodid = MethodCostTimeUtil.recordStartTime("subsetFont");
            if (signString == null || signString.isEmpty()) {
                throw new SealException("param is null!");
            }
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
                this.subsetFontFile(outputStream, signString);
                font = PdfFontFactory.createFont(outputStream.toByteArray(), "Identity-H", false, false);
                Glyph glyph = font.getFontProgram().getGlyph(signString.codePointAt(0));
                if (null == glyph) {
                    font = this.createPdfFont();
                }
            }
            catch (IOException e) {
                businessLog.error("subsetFont() IOException", (Throwable)e);
                throw new SealException("subsetFont() IOException", e);
            }
            finally {
                MethodCostTimeUtil.recordEndTime(methodid);
            }
            return font;
        }

        public void subsetFontFile(File outputFile, String subsetString) throws SealException, IOException {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outputFile);
                this.subsetFontFile(fos, subsetString);
            }
            catch (Exception e) {
                throw new SealException("subsetFontFile", e);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }

        public void subsetFontFile(OutputStream outputStream, String subsetString) throws IOException {
            Font newFont = this.fontArray[0];
            boolean isValidFont = false;
            if (subsetString != null) {
                List<Integer> glyphs = GlyphCoverage.getGlyphCoverage(newFont, subsetString);
                RenumberingSubsetter subsetter = new RenumberingSubsetter(this.fontArray[0], this.fontFactory);
                subsetter.setCMaps(this.cmapIds, 1);
                subsetter.setGlyphs(glyphs);
                subsetter.setRemoveTables(this.removeTables);
                newFont = subsetter.subset().build();
                isValidFont = true;
            }
            this.fontFactory.serializeFont(newFont, outputStream);
            if (isValidFont) {
                newFont.clearTableMap();
            }
            newFont = null;
        }

        public PdfFont createPdfFont() throws SealException {
            PdfFont font = null;
            try {
                font = PdfFontFactory.createFont(this.fontProgram, "Identity-H", false);
            }
            catch (IOException e) {
                throw new SealException("createPdfFont failed", e);
            }
            return font;
        }

        public PdfFont createPdfFont(String baseFontName) throws SealException {
            PdfFont font = null;
            try {
                font = PdfFontFactory.createFont(baseFontName, "Identity-H", false);
            }
            catch (IOException e) {
                throw new SealException("load baseFontName failed" + baseFontName, e);
            }
            return font;
        }

        public PdfFont createPdfFont(FontProgram fontProgram) throws SealException {
            PdfFont font = null;
            try {
                font = PdfFontFactory.createFont(fontProgram, "Identity-H", false);
            }
            catch (IOException e) {
                throw new SealException("createPdfFont failed", e);
            }
            return font;
        }

        public float normalizeFontSize(float fs, PdfFont localFont, Rectangle bBox, String value) throws SealException {
            float height = bBox.getHeight() - 4.0f;
            float width = bBox.getWidth() - 4.0f;
            if (fs == 0.0f) {
                int[] fontBbox = localFont.getFontProgram().getFontMetrics().getBbox();
                float baseWidth = localFont.getWidth(value, 1.0f);
                fs = height * 75.0f / (float)(fontBbox[2] - fontBbox[1]) * 1000.0f / 100.0f;
                if (baseWidth != 0.0f) {
                    fs = Math.min(fs, width / (float)(fontBbox[2] - fontBbox[1]) * 1000.0f);
                    fs = this.getFontSize(fs, baseWidth, width);
                }
            }
            fs = (float)Math.ceil(fs);
            return fs;
        }

        private float getFontSize(float fs, float words, float width) {
            if (fs > 0.1f) {
                if (fs * words > width) {
                    fs = fs * 9.0f / 10.0f;
                    return this.getFontSize(fs, words, width);
                }
                return fs;
            }
            return 0.1f;
        }

        public FontProgram getFontProgram() {
            return this.fontProgram;
        }

        public String getFontName() {
            if (null != this.fontProgram) {
                return this.fontProgram.getFontNames().getFontName();
            }
            return null;
        }
    }
}

