/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.sadk.seal.base.bean.sign.KeywordPosition;
import java.util.List;

public class KMPUtil {
    public static int kmpList(String source, String keyword, int[] next, List<Integer> positions) {
        int j = 0;
        for (int i = 0; i < source.length(); ++i) {
            char nextChar = source.charAt(i);
            while (j > 0 && nextChar != keyword.charAt(j)) {
                j = next[j - 1];
            }
            if (nextChar == keyword.charAt(j)) {
                ++j;
            }
            if (j != keyword.length()) continue;
            int position = i - j + 1;
            positions.add(position);
            int endFlag = KMPUtil.kmpList(source.substring(position + next.length), keyword, next, positions);
            if (endFlag != -1) continue;
            return -1;
        }
        return -1;
    }

    public static KeywordPosition getFirstPosition(String source, String keyword, int[] next, boolean ignoreCharNumSpace) {
        KeywordPosition position = new KeywordPosition();
        int preChar = -1;
        int j = 0;
        for (int i = 0; i < source.length(); ++i) {
            char currentChar = source.charAt(i);
            if (KMPUtil.isSpaceOrSpecial(currentChar) && (ignoreCharNumSpace || KMPUtil.isSpaceOrSpecial(preChar))) continue;
            while (j > 0 && currentChar != keyword.charAt(j)) {
                j = next[j - 1];
            }
            if (currentChar == keyword.charAt(j)) {
                if (j == 0) {
                    position.setStartIndex(i);
                }
                ++j;
            }
            if (j == keyword.length()) {
                position.setEndIndex(i);
                return position;
            }
            preChar = currentChar;
        }
        return null;
    }

    public static KeywordPosition getFirstPosition(String source, String keyword, int[] next) {
        KeywordPosition position = new KeywordPosition();
        int j = 0;
        for (int i = 0; i < source.length(); ++i) {
            char currentChar = source.charAt(i);
            while (j > 0 && currentChar != keyword.charAt(j)) {
                j = next[j - 1];
            }
            if (currentChar == keyword.charAt(j)) {
                if (j == 0) {
                    position.setStartIndex(i);
                }
                ++j;
            }
            if (j != keyword.length()) continue;
            position.setEndIndex(i);
            return position;
        }
        return null;
    }

    public static int kmp(String source, String keyword, int[] next) {
        int j = 0;
        for (int i = 0; i < source.length(); ++i) {
            char nextChar = source.charAt(i);
            while (j > 0 && nextChar != keyword.charAt(j)) {
                j = next[j - 1];
            }
            if (nextChar == keyword.charAt(j)) {
                ++j;
            }
            if (j != keyword.length()) continue;
            return i - j + 1;
        }
        return -1;
    }

    public static int[] getEqualsSubString(String source, String keyword, int[] next) {
        int[] result = new int[2];
        keyword = keyword.replaceAll(" ", "");
        source = source.trim();
        int spaceNum = 0;
        int j = 0;
        for (int i = 0; i < source.length(); ++i) {
            char nextChar = source.charAt(i);
            if (KMPUtil.isSpaceOrSpecial(nextChar)) {
                if (j <= 0) continue;
                ++spaceNum;
                continue;
            }
            while (j > 0 && nextChar != keyword.charAt(j) && next[j - 1] != 0) {
                j = next[j - 1];
            }
            if (nextChar == keyword.charAt(j)) {
                // empty if block
            }
            result[0] = i;
            result[1] = ++j;
        }
        result[0] = result[0] - result[1] + 1 - spaceNum;
        return result;
    }

    public static int kmp(byte[] source, byte[] keyword, int[] next) {
        int j = 0;
        for (int i = 0; i < source.length; ++i) {
            byte nextChar = source[i];
            while (j > 0 && nextChar != keyword[j]) {
                j = next[j - 1];
            }
            if (nextChar == keyword[j]) {
                ++j;
            }
            if (j != keyword.length) continue;
            return i - j + 1;
        }
        return -1;
    }

    public static int[] kmpnext(String keyword) {
        int[] next = new int[keyword.length()];
        next[0] = 0;
        int j = 0;
        for (int i = 1; i < keyword.length(); ++i) {
            char nextChar = keyword.charAt(i);
            while (j > 0 && keyword.charAt(j) != nextChar) {
                j = next[j - 1];
            }
            if (nextChar == keyword.charAt(j)) {
                // empty if block
            }
            next[i] = ++j;
        }
        return next;
    }

    public static int[] kmpnext(byte[] keyword) {
        int[] next = new int[keyword.length];
        next[0] = 0;
        int j = 0;
        for (int i = 1; i < keyword.length; ++i) {
            byte nextChar = keyword[i];
            while (j > 0 && keyword[j] != nextChar) {
                j = next[j - 1];
            }
            if (nextChar == keyword[j]) {
                // empty if block
            }
            next[i] = ++j;
        }
        return next;
    }

    public static boolean isNumberOrChar(int preChar) {
        return preChar >= 48 && preChar <= 57 || preChar >= 65 && preChar <= 90 || preChar >= 97 && preChar <= 122;
    }

    public static boolean isSpaceOrSpecial(int currentChar) {
        return currentChar == "\u00a0".charAt(0) || currentChar == 32 || currentChar == 65533 || currentChar == 9;
    }

    public static boolean isChinese(char preChar) {
        return preChar >= '\u4e00' && preChar <= '\u9fbb';
    }
}

