/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.seal.base.bean.appearance.AbstractAppearance;
import cfca.sadk.seal.base.bean.appearance.BlankAppearance;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.CertVerifyUtil;
import cfca.sadk.seal.base.util.CrlManager;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;

public class ParamsCheckUtil {
    private static final Logger logger = LoggerFactory.getLogger(ParamsCheckUtil.class);
    private static byte[] pdfFlagBytes = null;
    private static byte[] pdfEndFlagBytes = null;
    private static final String PDF_FILE_FLAG = "%PDF";
    private static final String PDF_FILE_END_FLAG = "%%EOF";

    public static final void checkPrimaryParam(PdfDocument pdfDocument, AbstractAppearance appearance, SignInfoConfig signatureConfig, boolean isCreate, boolean isCheckCert) throws SealException {
        ParamsCheckUtil.checkPrimaryParam(pdfDocument, appearance, isCreate);
        ParamsCheckUtil.checkPrimaryParam(signatureConfig, isCheckCert);
    }

    public static final void checkPrimaryParam(SignInfoConfig signatureConfig, boolean isCheckCert) throws SealException {
        Mechanism signAlg;
        if (isCheckCert) {
            PrivateKey privateKey = signatureConfig.getPrivateKey();
            if (privateKey == null) {
                throw new SealException("privateKey is null!");
            }
            X509Cert[] certs = signatureConfig.getCerts();
            if (certs == null || certs.length == 0) {
                throw new SealException("X509Cert[] certs is null!");
            }
            try {
                boolean isContainDS = ParamsCheckUtil.verifyKeyUsageForDS(certs[0]);
                if (!isContainDS) {
                    throw new SealException("signCert keyUsage is wrong,SN is " + certs[0].getStringSerialNumber());
                }
            }
            catch (SealException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SealException("checkPrimaryParam failed", e);
            }
        }
        if ((signAlg = signatureConfig.getSignAlg()) == null) {
            throw new SealException("signAlg is null!");
        }
    }

    public static final void checkPrimaryParam(PdfDocument pdfDocument, AbstractAppearance appearance, boolean isCreate) throws SealException {
        String signFieldName = appearance.getSignFieldName();
        if (signFieldName == null) {
            throw new SealException("signFieldName is null!");
        }
        if (isCreate) {
            ParamsCheckUtil.checkSignFieldNotExists(pdfDocument, signFieldName);
            int pageNum = appearance.getPageNum();
            ParamsCheckUtil.checkPageNum(pdfDocument, appearance.getPageNum());
            Rectangle rect = appearance.getRectangle();
            if (rect == null) {
                throw new SealException("Rectangle is null!");
            }
            if (appearance.isCheckRectangle()) {
                ParamsCheckUtil.checkRectangle(pdfDocument, pageNum, rect);
            }
        } else {
            ParamsCheckUtil.checkSignFieldExists(pdfDocument, signFieldName);
        }
    }

    public static final void checkBlankPrimaryParam(PdfDocument pdfDocument, BlankAppearance appearance, boolean isCreate) throws SealException {
        String signFieldName = appearance.getSignFieldName();
        if (signFieldName == null) {
            throw new SealException("signFieldName is null!");
        }
        if (isCreate) {
            int pageNum = appearance.getPageNum();
            ParamsCheckUtil.checkPageNum(pdfDocument, pageNum);
            Rectangle rect = appearance.getRectangle();
            if (rect == null) {
                throw new SealException("Rectangle is null!");
            }
            ParamsCheckUtil.checkSignFieldNotExists(pdfDocument, signFieldName);
            if (appearance.isCheckRectangle()) {
                ParamsCheckUtil.checkRectangle(pdfDocument, pageNum, rect);
            }
        } else {
            ParamsCheckUtil.checkBlankSignFieldExists(pdfDocument, signFieldName);
        }
    }

    public static final void checkSignFieldExists(PdfDocument pdfDocument, String signFieldName) throws SealException {
        SignatureUtil signatureUtil;
        boolean isNotExists;
        block7: {
            isNotExists = true;
            signatureUtil = null;
            try {
                signatureUtil = new SignatureUtil(pdfDocument);
            }
            catch (PdfException e) {
                if (e == null || e.getMessage() == null || !e.getMessage().contains("There is no associate PdfWriter for making indirects")) break block7;
                throw new SealException("signFieldName error:no signature found!");
            }
        }
        if (signatureUtil != null) {
            List<String> signedNames = signatureUtil.getSignatureNames();
            if (signedNames == null || signedNames.isEmpty()) {
                isNotExists = true;
            } else {
                for (String name : signedNames) {
                    if (!name.equals(signFieldName)) continue;
                    isNotExists = false;
                    break;
                }
            }
        }
        if (isNotExists) {
            throw new SealException("signFieldName error:" + signFieldName + " not exists!");
        }
    }

    public static final void checkBlankSignFieldExists(PdfDocument pdfDocument, String signFieldName) throws SealException {
        List<String> blankNames;
        SignatureUtil signatureUtil;
        boolean isExists;
        block5: {
            isExists = true;
            signatureUtil = null;
            try {
                signatureUtil = new SignatureUtil(pdfDocument);
            }
            catch (PdfException e) {
                if (e == null || e.getMessage() == null || !e.getMessage().contains("There is no associate PdfWriter for making indirects")) break block5;
                throw new SealException("signFieldName error:no signature found!");
            }
        }
        if (signatureUtil != null && (blankNames = signatureUtil.getBlankSignatureNames()) != null && !blankNames.isEmpty()) {
            for (String name : blankNames) {
                if (!name.equals(signFieldName)) continue;
                isExists = false;
                break;
            }
        }
        if (isExists) {
            throw new SealException("signFieldName error:" + signFieldName + " not exists!");
        }
    }

    public static final void checkSignFieldNotExists(PdfDocument pdfDocument, String signFieldName) throws SealException {
        SignatureUtil signatureUtil;
        boolean isExists;
        block8: {
            isExists = false;
            signatureUtil = null;
            try {
                signatureUtil = new SignatureUtil(pdfDocument);
            }
            catch (PdfException e) {
                if (e == null || e.getMessage() == null || !e.getMessage().contains("There is no associate PdfWriter for making indirects")) break block8;
                throw new SealException("signFieldName error:no signature found!");
            }
        }
        if (signatureUtil != null) {
            List<String> signedNames = signatureUtil.getSignatureNames();
            if (signedNames != null && !signedNames.isEmpty()) {
                for (String name : signedNames) {
                    if (!name.equals(signFieldName)) continue;
                    isExists = true;
                    break;
                }
            }
            if (!isExists) {
                List<String> blankNames = signatureUtil.getBlankSignatureNames();
                for (String name : blankNames) {
                    if (!name.equals(signFieldName)) continue;
                    isExists = true;
                    break;
                }
            }
        }
        if (isExists) {
            throw new SealException("signFieldName error:" + signFieldName + " is exists!");
        }
    }

    public static final void checkPageNum(PdfDocument pdfDocument, int pageNum) throws SealException {
        int totalPages = pdfDocument.getNumberOfPages();
        if (pageNum < 1 || pageNum > totalPages) {
            throw new SealException("pageNum error:pageNum =" + pageNum + ", totalPages=" + totalPages);
        }
    }

    public static final void checkPageNum(PdfDocument pdfDocument, int begin, int end) throws SealException {
        int totalPages = pdfDocument.getNumberOfPages();
        if (begin < 1 || begin > totalPages || end < 1 || end > totalPages || end < begin) {
            throw new SealException("pageNum error: beginPageNum =" + begin + " endPageNum=" + end + " totalPages=" + totalPages);
        }
    }

    public static final void checkPageNum(PdfDocument pdfDocument, int[] pageArray) throws SealException {
        int totalPages = pdfDocument.getNumberOfPages();
        for (int i = 0; i < pageArray.length; ++i) {
            int onePageNum = pageArray[i];
            if (onePageNum >= 1 && onePageNum <= totalPages) continue;
            throw new SealException("pageNum error: PageNum =" + onePageNum + " totalPages=" + totalPages);
        }
    }

    public static final void checkPageNum(int pdfNo, PdfDocument pdfDocument, int begin, int end) throws SealException {
        int totalPages = pdfDocument.getNumberOfPages();
        if (begin < 1 || begin > totalPages || end < 1 || end > totalPages || end < begin) {
            throw new SealException("pageNum error: pdfNo = " + pdfNo + " beginPageNum =" + begin + " endPageNum=" + end + " totalPages=" + totalPages);
        }
    }

    public static final void checkRectangle(PdfDocument pdfDocument, int pageNum, Rectangle rect) throws SealException {
        PdfPage page = pdfDocument.getPage(pageNum);
        Rectangle pageRect = page.getPageSize();
        float height = pageRect.getHeight();
        float width = pageRect.getWidth();
        float x = rect.getX();
        float y = rect.getY();
        float rlx = x + rect.getWidth();
        float rly = y + rect.getHeight();
        if (x < 0.0f || x > width || y < 0.0f || y > height || rlx > width || rly > height) {
            throw new SealException("Rectangle error:(x,y)=(" + x + "," + y + ")" + rect.toString() + " is out of range");
        }
    }

    public static void checkCertValidity(X509Cert x509Cert) throws SealException {
        Date currentDate = new Date();
        ParamsCheckUtil.checkCertValidity(x509Cert, currentDate);
    }

    public static void checkCertValidity(X509Cert x509Cert, Date currentDate) throws SealException {
        if (null != x509Cert) {
            String issuerKey;
            boolean isRevoked2;
            Date notBefore = x509Cert.getNotBefore();
            Date notAfter = x509Cert.getNotAfter();
            if (currentDate.before(notBefore) && notBefore.getTime() / 1000L != currentDate.getTime() / 1000L) {
                throw new SealException("x509Cert is not valid,DN=" + x509Cert.getSubject());
            }
            if (currentDate.after(notAfter)) {
                throw new SealException("x509Cert is expired,DN=" + x509Cert.getSubject());
            }
            if (SysEnv.isCrlLoaded() && (isRevoked2 = CrlManager.isRevoked(issuerKey = x509Cert.getIssuer(), x509Cert.getSerialNumber().toString(16)))) {
                String errorInfo = "x509Cert is revoked,DN=" + x509Cert.getSubject();
                logger.error(errorInfo);
                throw new SealException(errorInfo);
            }
            if (SysEnv.isTrustCertLoaded()) {
                boolean isTrusted = false;
                try {
                    isTrusted = CertVerifyUtil.verifyCertSign(x509Cert);
                }
                catch (Exception isRevoked2) {
                    // empty catch block
                }
                if (!isTrusted) {
                    String errorInfo = "x509Cert is not trusted,DN=" + x509Cert.getSubject() + ",Issuer=" + x509Cert.getIssuer();
                    logger.error(errorInfo);
                    throw new SealException(errorInfo);
                }
            }
        }
    }

    public static boolean[] getCertKeyUsage(X509Cert userCert) throws Exception {
        boolean[] keyUsage;
        byte[] extData = userCert.getExtensionByteData(Extension.keyUsage);
        if (extData != null) {
            DERBitString bits = DERBitString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])extData));
            int length = (extData = bits.getBytes()).length * 8 - bits.getPadBits();
            keyUsage = new boolean[length < 9 ? 9 : length];
            for (int i = 0; i != length; ++i) {
                keyUsage[i] = (extData[i / 8] & 128 >>> i % 8) != 0;
            }
        } else {
            keyUsage = null;
        }
        return keyUsage;
    }

    public static boolean verifyKeyUsageForDS(X509Cert userCert) throws Exception {
        boolean isForDS = false;
        boolean[] keyUsage = ParamsCheckUtil.getCertKeyUsage(userCert);
        if (keyUsage != null && keyUsage[0]) {
            isForDS = true;
        } else {
            logger.error("signCert keyUsage is wrong,SN is " + userCert.getStringSerialNumber());
        }
        return isForDS;
    }

    public static void checkTimestampValidity(Date signTime, X509Cert signCert) throws SealException, TSAException, GeneralSecurityException {
        if (null != signTime) {
            if (signTime.before(signCert.getNotBefore())) {
                throw new GeneralSecurityException("NotBefore time of Certificate is later than timestamp time!");
            }
            if (signTime.after(signCert.getNotAfter())) {
                throw new GeneralSecurityException("NotAfter time of Certificate is earlier than timestamp time!");
            }
        }
    }

    public static void checkSignParams(byte[] sourceData, AbstractAppearance appearance, SignInfoConfig signInfo) throws SealException {
        if (sourceData == null) {
            throw new SealException("sourceData is null");
        }
        if (appearance == null) {
            throw new SealException("appearance is null");
        }
        if (signInfo == null) {
            throw new SealException("signInfo is null");
        }
        ParamsCheckUtil.checkPdfHeader(sourceData);
    }

    public static void checkSignParams(InputStream sourceStream, OutputStream outputStream, AbstractAppearance appearance, SignInfoConfig signInfo) throws SealException {
        if (sourceStream == null) {
            throw new SealException("InputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("OutputStream is null");
        }
        if (appearance == null) {
            throw new SealException("appearance is null");
        }
        if (signInfo == null) {
            throw new SealException("signInfo is null");
        }
    }

    public static void checkSignParams(byte[] sourceData, AbstractAppearance appearance) throws SealException {
        if (sourceData == null) {
            throw new SealException("sourceData is null");
        }
        if (appearance == null) {
            throw new SealException("appearance is null");
        }
        ParamsCheckUtil.checkPdfHeader(sourceData);
    }

    public static void checkSignParams(InputStream sourceStream, OutputStream outputStream, AbstractAppearance appearance) throws SealException {
        if (sourceStream == null) {
            throw new SealException("InputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("OutputStream is null");
        }
        if (appearance == null) {
            throw new SealException("appearance is null");
        }
    }

    public static boolean negativeException(float number, float exceptForNumber, boolean throwException) throws InvalidParameterException {
        if (throwException) {
            if (number < 0.0f && exceptForNumber != -1.0f) {
                throw new InvalidParameterException("parameter number can not be negative!");
            }
            return false;
        }
        return number < 0.0f && exceptForNumber != -1.0f;
    }

    public static void checkFontSize(float fontSize, String signText, Rectangle rect) throws SealException {
        if (SysEnv.isCheckFontSizeOverflow() && fontSize != 0.0f && null != signText) {
            if (rect.getHeight() < fontSize) {
                throw new SealException("rectangle height less than fontSize , fontSize should be smaller!signText is " + signText + ", Rectangle is " + rect);
            }
            if ((float)signText.length() * fontSize > rect.getWidth()) {
                throw new SealException("rectangle width is less than text width , fontSize should be smaller!signText is " + signText + ", Rectangle is " + rect);
            }
        }
    }

    public static void checkSignParams(InputStream sourceStream, OutputStream outputStream, List<AbstractAppearance> appearanceList, SignInfoConfig signInfo) throws SealException {
        if (sourceStream == null) {
            throw new SealException("InputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("OutputStream is null");
        }
        if (appearanceList == null) {
            throw new SealException("appearanceList is null");
        }
        if (signInfo == null) {
            throw new SealException("signInfo is null");
        }
    }

    public static void checkPrimaryParam(SignInfoConfig signatureConfig) throws SealException {
        ParamsCheckUtil.checkPrimaryParam(signatureConfig, true);
    }

    public static void checkPdfHeader(byte[] pdfData) {
        boolean isValid = true;
        String errorMsgString = null;
        if (null == pdfData || pdfData.length < pdfFlagBytes.length + pdfEndFlagBytes.length) {
            errorMsgString = "pdf is null ";
        }
        for (int i = 0; i < pdfFlagBytes.length; ++i) {
            if (pdfFlagBytes[i] == pdfData[i]) continue;
            errorMsgString = "the file is not pdf format";
            isValid = false;
        }
        if (!isValid) {
            throw new IllegalArgumentException(errorMsgString);
        }
    }

    public static String checkIsValidPdfFile(byte[] pdfData, boolean isThrowException) {
        boolean isValid = true;
        String errorMsgString = null;
        if (null == pdfData || pdfData.length < pdfFlagBytes.length + pdfEndFlagBytes.length) {
            errorMsgString = "pdf is null ";
        }
        for (int i = 0; i < pdfFlagBytes.length; ++i) {
            if (pdfFlagBytes[i] == pdfData[i]) continue;
            errorMsgString = "the file is not pdf format";
        }
        int totalLength = pdfData.length;
        int destArrayLength = pdfEndFlagBytes.length;
        int srcPos = totalLength - destArrayLength;
        byte[] endBytes = new byte[destArrayLength];
        byte newLine = 10;
        byte enter = 13;
        if (pdfData[totalLength - 1] == newLine || pdfData[totalLength - 1] == enter) {
            --srcPos;
        }
        if (pdfData[totalLength - 2] == newLine || pdfData[totalLength - 2] == enter) {
            --srcPos;
        }
        System.arraycopy(pdfData, srcPos, endBytes, 0, destArrayLength);
        for (int i = 0; i < destArrayLength; ++i) {
            if (pdfEndFlagBytes[i] == endBytes[i]) continue;
            errorMsgString = "the file is not end width %%EOF";
            isValid = false;
            break;
        }
        if (!isValid) {
            String realText = null;
            try {
                realText = new String(endBytes, "UTF8");
                errorMsgString = "the file is not end width %%EOF,end width:[" + realText + "]";
                logger.error(errorMsgString);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("checkIsValidPdfFile failed:", (Throwable)e);
            }
            if (isThrowException) {
                throw new IllegalArgumentException(errorMsgString);
            }
        }
        return errorMsgString;
    }

    public static void checkSignature(PdfDocument pdfDoc) throws SealException {
        SignatureUtil signatureUtil = new SignatureUtil(pdfDoc, true);
        List<String> sigNames = signatureUtil.getSignatureNames();
        if (sigNames != null && sigNames.size() > 0) {
            throw new SealException("pdfDocument is signed,can not restore!");
        }
    }

    static {
        try {
            pdfFlagBytes = PDF_FILE_FLAG.getBytes("UTF8");
            pdfEndFlagBytes = PDF_FILE_END_FLAG.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("ParamsCheckUtil init failed:", (Throwable)e);
        }
    }
}

