/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetCESU8;
import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.UTF8;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF8
extends CharsetICU {
    private static final byte[] fromUSubstitution = new byte[]{-17, -65, -67};
    private static final int[] BITMASK_FROM_UTF8 = new int[]{-1, 127, 31, 15, 7};
    private final boolean isCESU8 = this instanceof CharsetCESU8;

    public CharsetUTF8(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    private static final byte encodeHeadOf1(int char32) {
        return (byte)char32;
    }

    private static final byte encodeHeadOf2(int char32) {
        return (byte)(0xC0 | char32 >>> 6);
    }

    private static final byte encodeHeadOf3(int char32) {
        return (byte)(0xE0 | char32 >>> 12);
    }

    private static final byte encodeHeadOf4(int char32) {
        return (byte)(0xF0 | char32 >>> 18);
    }

    private static final byte encodeThirdToLastTail(int char32) {
        return (byte)(0x80 | char32 >>> 12 & 0x3F);
    }

    private static final byte encodeSecondToLastTail(int char32) {
        return (byte)(0x80 | char32 >>> 6 & 0x3F);
    }

    private static final byte encodeLastTail(int char32) {
        return (byte)(0x80 | char32 & 0x3F);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF8(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF8(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        CharsetUTF8.getNonSurrogateUnicodeSet(setFillIn);
    }

    class CharsetEncoderUTF8
    extends CharsetEncoderICU {
        private int sourceIndex;
        private int targetIndex;

        public CharsetEncoderUTF8(CharsetICU cs) {
            super(cs, fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if (source.hasArray() && target.hasArray()) {
                CoderResult cr2;
                char[] sourceArray = source.array();
                int srcIdx = source.arrayOffset() + source.position();
                int sourceLimit = source.arrayOffset() + source.limit();
                byte[] targetArray = target.array();
                int tgtIdx = target.arrayOffset() + target.position();
                int targetLimit = target.arrayOffset() + target.limit();
                if (this.fromUChar32 != 0) {
                    this.sourceIndex = srcIdx;
                    this.targetIndex = tgtIdx;
                    cr2 = this.encodeFourBytes(sourceArray, targetArray, sourceLimit, targetLimit, this.fromUChar32);
                    srcIdx = this.sourceIndex;
                    tgtIdx = this.targetIndex;
                    if (cr2 != null) {
                        source.position(srcIdx - source.arrayOffset());
                        target.position(tgtIdx - target.arrayOffset());
                        return cr2;
                    }
                }
                while (true) {
                    char char32;
                    if (srcIdx >= sourceLimit) {
                        cr2 = CoderResult.UNDERFLOW;
                        break;
                    }
                    if (tgtIdx >= targetLimit) {
                        cr2 = CoderResult.OVERFLOW;
                        break;
                    }
                    if ((char32 = sourceArray[srcIdx++]) <= '\u007f') {
                        targetArray[tgtIdx++] = CharsetUTF8.encodeHeadOf1(char32);
                        continue;
                    }
                    if (char32 <= '\u07ff') {
                        targetArray[tgtIdx++] = CharsetUTF8.encodeHeadOf2(char32);
                        if (tgtIdx >= targetLimit) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                            cr2 = CoderResult.OVERFLOW;
                            break;
                        }
                        targetArray[tgtIdx++] = CharsetUTF8.encodeLastTail(char32);
                        continue;
                    }
                    if (!UTF16.isSurrogate((char)char32) || CharsetUTF8.this.isCESU8) {
                        targetArray[tgtIdx++] = CharsetUTF8.encodeHeadOf3(char32);
                        if (tgtIdx >= targetLimit) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                            cr2 = CoderResult.OVERFLOW;
                            break;
                        }
                        targetArray[tgtIdx++] = CharsetUTF8.encodeSecondToLastTail(char32);
                        if (tgtIdx >= targetLimit) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                            cr2 = CoderResult.OVERFLOW;
                            break;
                        }
                        targetArray[tgtIdx++] = CharsetUTF8.encodeLastTail(char32);
                        continue;
                    }
                    this.sourceIndex = srcIdx;
                    this.targetIndex = tgtIdx;
                    cr2 = this.encodeFourBytes(sourceArray, targetArray, sourceLimit, targetLimit, char32);
                    srcIdx = this.sourceIndex;
                    tgtIdx = this.targetIndex;
                    if (cr2 != null) break;
                }
                source.position(srcIdx - source.arrayOffset());
                target.position(tgtIdx - target.arrayOffset());
                return cr2;
            }
            if (this.fromUChar32 != 0 && (cr = this.encodeFourBytes(source, target, this.fromUChar32)) != null) {
                return cr;
            }
            while (source.hasRemaining()) {
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char char32 = source.get();
                if (char32 <= '\u007f') {
                    target.put(CharsetUTF8.encodeHeadOf1(char32));
                    continue;
                }
                if (char32 <= '\u07ff') {
                    target.put(CharsetUTF8.encodeHeadOf2(char32));
                    if (!target.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                        return CoderResult.OVERFLOW;
                    }
                    target.put(CharsetUTF8.encodeLastTail(char32));
                    continue;
                }
                if (!UTF16.isSurrogate((char)char32) || CharsetUTF8.this.isCESU8) {
                    target.put(CharsetUTF8.encodeHeadOf3(char32));
                    if (!target.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                        return CoderResult.OVERFLOW;
                    }
                    target.put(CharsetUTF8.encodeSecondToLastTail(char32));
                    if (!target.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                        return CoderResult.OVERFLOW;
                    }
                    target.put(CharsetUTF8.encodeLastTail(char32));
                    continue;
                }
                cr = this.encodeFourBytes(source, target, char32);
                if (cr != null) return cr;
            }
            return CoderResult.UNDERFLOW;
        }

        private final CoderResult encodeFourBytes(char[] sourceArray, byte[] targetArray, int sourceLimit, int targetLimit, int char32) {
            CoderResult cr = this.handleSurrogates(sourceArray, this.sourceIndex, sourceLimit, (char)char32);
            if (cr != null) {
                return cr;
            }
            ++this.sourceIndex;
            char32 = this.fromUChar32;
            this.fromUChar32 = 0;
            targetArray[this.targetIndex++] = CharsetUTF8.encodeHeadOf4(char32);
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeThirdToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            targetArray[this.targetIndex++] = CharsetUTF8.encodeThirdToLastTail(char32);
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            targetArray[this.targetIndex++] = CharsetUTF8.encodeSecondToLastTail(char32);
            if (this.targetIndex >= targetLimit) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            targetArray[this.targetIndex++] = CharsetUTF8.encodeLastTail(char32);
            return null;
        }

        private final CoderResult encodeFourBytes(CharBuffer source, ByteBuffer target, int char32) {
            CoderResult cr = this.handleSurrogates(source, (char)char32);
            if (cr != null) {
                return cr;
            }
            char32 = this.fromUChar32;
            this.fromUChar32 = 0;
            target.put(CharsetUTF8.encodeHeadOf4(char32));
            if (!target.hasRemaining()) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeThirdToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            target.put(CharsetUTF8.encodeThirdToLastTail(char32));
            if (!target.hasRemaining()) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(char32);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            target.put(CharsetUTF8.encodeSecondToLastTail(char32));
            if (!target.hasRemaining()) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(char32);
                return CoderResult.OVERFLOW;
            }
            target.put(CharsetUTF8.encodeLastTail(char32));
            return null;
        }
    }

    class CharsetDecoderUTF8
    extends CharsetDecoderICU {
        public CharsetDecoderUTF8(CharsetICU cs) {
            super(cs);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            int targetIndex;
            int sourceIndex;
            block32: {
                int bytesSoFar;
                int char32;
                int bytesExpected;
                byte ch;
                if (!source.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                if (source.hasArray() && target.hasArray()) {
                    CoderResult cr2;
                    int targetIndex2;
                    int sourceIndex2;
                    block31: {
                        int bytesSoFar2;
                        int char322;
                        int bytesExpected2;
                        byte ch2;
                        byte[] sourceArray = source.array();
                        sourceIndex2 = source.arrayOffset() + source.position();
                        int sourceLimit = source.arrayOffset() + source.limit();
                        char[] targetArray = target.array();
                        targetIndex2 = target.arrayOffset() + target.position();
                        int targetLimit = target.arrayOffset() + target.limit();
                        if (this.mode == 0) {
                            this.toUBytesArray[0] = ch2 = sourceArray[sourceIndex2++];
                            bytesExpected2 = UTF8.countBytes(ch2);
                            char322 = ch2 & BITMASK_FROM_UTF8[bytesExpected2];
                            bytesSoFar2 = 1;
                        } else {
                            char322 = this.toUnicodeStatus;
                            bytesExpected2 = this.mode;
                            bytesSoFar2 = this.toULength;
                            this.toUnicodeStatus = 0;
                            this.mode = 0;
                            this.toULength = 0;
                        }
                        while (true) {
                            if (bytesSoFar2 < bytesExpected2) {
                                if (sourceIndex2 >= sourceLimit) {
                                    this.toUnicodeStatus = char322;
                                    this.mode = bytesExpected2;
                                    this.toULength = bytesSoFar2;
                                    cr2 = CoderResult.UNDERFLOW;
                                    break block31;
                                }
                                this.toUBytesArray[bytesSoFar2] = ch2 = sourceArray[sourceIndex2++];
                                if (!(UTF8.isValidTrail(char322, ch2, bytesSoFar2, bytesExpected2) || CharsetUTF8.this.isCESU8 && bytesSoFar2 == 1 && char322 == 13 && UTF8.isTrail(ch2))) {
                                    --sourceIndex2;
                                    this.toULength = bytesSoFar2;
                                    cr2 = CoderResult.malformedForLength(bytesSoFar2);
                                    break block31;
                                }
                                char322 = char322 << 6 | ch2 & 0x3F;
                                ++bytesSoFar2;
                                continue;
                            }
                            if (bytesSoFar2 != bytesExpected2 || CharsetUTF8.this.isCESU8 && bytesSoFar2 > 3) break;
                            if (char322 <= 65535) {
                                targetArray[targetIndex2++] = (char)char322;
                            } else {
                                targetArray[targetIndex2++] = (char)(((char322 -= 65536) >>> 10) + 55296);
                                if (targetIndex2 >= targetLimit) {
                                    this.charErrorBufferArray[this.charErrorBufferLength++] = (char)((char322 & 0x3FF) + 56320);
                                    cr2 = CoderResult.OVERFLOW;
                                    break block31;
                                }
                                targetArray[targetIndex2++] = (char)((char322 & 0x3FF) + 56320);
                            }
                            if (sourceIndex2 >= sourceLimit) {
                                cr2 = CoderResult.UNDERFLOW;
                                break block31;
                            }
                            if (targetIndex2 >= targetLimit) {
                                cr2 = CoderResult.OVERFLOW;
                                break block31;
                            }
                            while (UTF8.isSingle(ch2 = sourceArray[sourceIndex2++])) {
                                targetArray[targetIndex2++] = (char)ch2;
                                if (sourceIndex2 >= sourceLimit) {
                                    cr2 = CoderResult.UNDERFLOW;
                                } else {
                                    if (targetIndex2 < targetLimit) continue;
                                    cr2 = CoderResult.OVERFLOW;
                                }
                                break block31;
                            }
                            this.toUBytesArray[0] = ch2;
                            bytesExpected2 = UTF8.countBytes(ch2);
                            char322 = ch2 & BITMASK_FROM_UTF8[bytesExpected2];
                            bytesSoFar2 = 1;
                        }
                        this.toULength = bytesSoFar2;
                        cr2 = CoderResult.malformedForLength(bytesSoFar2);
                    }
                    source.position(sourceIndex2 - source.arrayOffset());
                    target.position(targetIndex2 - target.arrayOffset());
                    return cr2;
                }
                sourceIndex = source.position();
                int sourceLimit = source.limit();
                targetIndex = target.position();
                int targetLimit = target.limit();
                if (this.mode == 0) {
                    this.toUBytesArray[0] = ch = source.get(sourceIndex++);
                    bytesExpected = UTF8.countBytes(ch);
                    char32 = ch & BITMASK_FROM_UTF8[bytesExpected];
                    bytesSoFar = 1;
                } else {
                    char32 = this.toUnicodeStatus;
                    bytesExpected = this.mode;
                    bytesSoFar = this.toULength;
                    this.toUnicodeStatus = 0;
                    this.mode = 0;
                    this.toULength = 0;
                }
                while (true) {
                    if (bytesSoFar < bytesExpected) {
                        if (sourceIndex >= sourceLimit) {
                            this.toUnicodeStatus = char32;
                            this.mode = bytesExpected;
                            this.toULength = bytesSoFar;
                            cr = CoderResult.UNDERFLOW;
                            break block32;
                        }
                        this.toUBytesArray[bytesSoFar] = ch = source.get(sourceIndex++);
                        if (!(UTF8.isValidTrail(char32, ch, bytesSoFar, bytesExpected) || CharsetUTF8.this.isCESU8 && bytesSoFar == 1 && char32 == 13 && UTF8.isTrail(ch))) {
                            --sourceIndex;
                            this.toULength = bytesSoFar;
                            cr = CoderResult.malformedForLength(bytesSoFar);
                            break block32;
                        }
                        char32 = char32 << 6 | ch & 0x3F;
                        ++bytesSoFar;
                        continue;
                    }
                    if (bytesSoFar != bytesExpected || CharsetUTF8.this.isCESU8 && bytesSoFar > 3) break;
                    if (char32 <= 65535) {
                        target.put(targetIndex++, (char)char32);
                    } else {
                        target.put(targetIndex++, (char)(((char32 -= 65536) >>> 10) + 55296));
                        if (targetIndex >= targetLimit) {
                            this.charErrorBufferArray[this.charErrorBufferLength++] = (char)((char32 & 0x3FF) + 56320);
                            cr = CoderResult.OVERFLOW;
                            break block32;
                        }
                        target.put(targetIndex++, (char)((char32 & 0x3FF) + 56320));
                    }
                    if (sourceIndex >= sourceLimit) {
                        cr = CoderResult.UNDERFLOW;
                        break block32;
                    }
                    if (targetIndex >= targetLimit) {
                        cr = CoderResult.OVERFLOW;
                        break block32;
                    }
                    while (UTF8.isSingle(ch = source.get(sourceIndex++))) {
                        target.put(targetIndex++, (char)ch);
                        if (sourceIndex >= sourceLimit) {
                            cr = CoderResult.UNDERFLOW;
                        } else {
                            if (targetIndex < targetLimit) continue;
                            cr = CoderResult.OVERFLOW;
                        }
                        break block32;
                    }
                    this.toUBytesArray[0] = ch;
                    bytesExpected = UTF8.countBytes(ch);
                    char32 = ch & BITMASK_FROM_UTF8[bytesExpected];
                    bytesSoFar = 1;
                }
                this.toULength = bytesSoFar;
                cr = CoderResult.malformedForLength(bytesSoFar);
            }
            source.position(sourceIndex);
            target.position(targetIndex);
            return cr;
        }
    }
}

