/*
 * Decompiled with CFR 0.152.
 */
package cryptokit.jni;

public class JNISDF {
    private long m_lSDFLibModule = 0L;
    public int ENCRYPTION_KEY = 1;
    public int SIGNATURE_KEY = 2;

    static {
        System.loadLibrary("SDFJNI");
    }

    private native long JNIloadSDFLib(String var1) throws Exception;

    private native void JNIunloadSDFLib(long var1) throws Exception;

    private native long JNIopenDevice(long var1) throws Exception;

    private native int JNIcloseDevice(long var1, long var3) throws Exception;

    private native long JNIopenSession(long var1, long var3) throws Exception;

    private native int JNIcloseSession(long var1, long var3) throws Exception;

    private native int JNIgetLoginStatus(long var1, long var3, byte[] var5) throws Exception;

    private native int JNIgenerateKeyPairRSA(long var1, long var3, int var5, byte[] var6, byte[] var7) throws Exception;

    private native int JNIexportPublicKeyRSA(long var1, long var3, int var5, int var6, byte[] var7) throws Exception;

    private native int JNIexternalPublicKeyOperationRSA(long var1, long var3, byte[] var5, byte[] var6, byte[] var7, int[] var8) throws Exception;

    private native int JNIinternalPublicKeyOperationRSA(long var1, long var3, int var5, byte[] var6, byte[] var7, int[] var8) throws Exception;

    private native int JNIinternalPrivateKeyOperationRSA(long var1, long var3, int var5, byte[] var6, byte[] var7, int[] var8) throws Exception;

    private native int JNIexternalPrivateKeyOperationRSA(long var1, long var3, byte[] var5, byte[] var6, byte[] var7, int[] var8) throws Exception;

    public void loadSDFLib(String SDFLib) throws Exception {
        this.m_lSDFLibModule = this.JNIloadSDFLib(SDFLib);
        if (0L == this.m_lSDFLibModule) {
            throw new Exception("load SDF lib failed!");
        }
    }

    public void unloadLib() throws Exception {
        this.JNIunloadSDFLib(this.m_lSDFLibModule);
    }

    public long openDevice() throws Exception {
        return this.JNIopenDevice(this.m_lSDFLibModule);
    }

    public int closeDevice(long deviceHandle) throws Exception {
        return this.JNIcloseDevice(this.m_lSDFLibModule, deviceHandle);
    }

    public long openSession(long deviceHandle) throws Exception {
        return this.JNIopenSession(this.m_lSDFLibModule, deviceHandle);
    }

    public int closeSession(long sessionHandle) throws Exception {
        return this.JNIcloseSession(this.m_lSDFLibModule, sessionHandle);
    }

    public int getLoginStatus(long sessionHandle, byte[] pucStatus) throws Exception {
        return this.JNIgetLoginStatus(this.m_lSDFLibModule, sessionHandle, pucStatus);
    }

    public int generateKeyPairRSA(long sessionHandle, int keyBits, byte[] publicKeyData, byte[] privateKeyData) throws Exception {
        return this.JNIgenerateKeyPairRSA(this.m_lSDFLibModule, sessionHandle, keyBits, publicKeyData, privateKeyData);
    }

    public int exportPublicKeyRSA(long sessionHandle, int keyIndex, int algType, byte[] publicKeyData) throws Exception {
        return this.JNIexportPublicKeyRSA(this.m_lSDFLibModule, sessionHandle, keyIndex, algType, publicKeyData);
    }

    public int externalPublicKeyOperationRSA(long sessionHandle, byte[] publicKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws Exception {
        return this.JNIexternalPublicKeyOperationRSA(this.m_lSDFLibModule, sessionHandle, publicKeyData, dataInput, dataOutput, dataOutputSize);
    }

    public int internalPublicKeyOperationRSA(long sessionHandle, int keyIndex, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws Exception {
        return this.JNIinternalPublicKeyOperationRSA(this.m_lSDFLibModule, sessionHandle, keyIndex, dataInput, dataOutput, dataOutputSize);
    }

    public int internalPrivateKeyOperationRSA(long sessionHandle, int keyIndex, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws Exception {
        return this.JNIinternalPrivateKeyOperationRSA(this.m_lSDFLibModule, sessionHandle, keyIndex, dataInput, dataOutput, dataOutputSize);
    }

    public int externalPrivateKeyOperationRSA(long sessionHandle, byte[] privateKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws Exception {
        return this.JNIexternalPrivateKeyOperationRSA(this.m_lSDFLibModule, sessionHandle, privateKeyData, dataInput, dataOutput, dataOutputSize);
    }
}

