/*
 * Decompiled with CFR 0.152.
 */
package com.zzhl.buyer.util;

import com.alibaba.fastjson.JSON;
import com.zzhl.buyer.constant.BaseConfigConstant;
import com.zzhl.buyer.dto.BuyerSealImageDto;
import com.zzhl.buyer.dto.SetCloudCertHashListSignInfoDto;
import com.zzhl.buyer.dto.SetCloudCertInfoDto;
import com.zzhl.buyer.dto.SignHashListDto;
import com.zzhl.buyer.exception.MessageException;
import com.zzhl.buyer.util.GetPlatformConfigUtil;
import com.zzhl.buyer.util.HttpSendUtil;
import com.zzhl.buyer.util.UuidUtil;
import com.zzhl.buyer.vo.AppResultVo;
import com.zzhl.buyer.vo.CloudSignCertVo;
import com.zzhl.buyer.vo.CloudSignValueListVo;
import com.zzhl.buyer.vo.SealImageVo;
import com.zzhl.buyer.vo.UserOrgVo;
import com.zzhl.buyer.vo.WithdrawSealVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallBuyerServerUtil {
    private static final Logger log = LoggerFactory.getLogger(CallBuyerServerUtil.class);

    public static List<SealImageVo> getSealImageList(BuyerSealImageDto buyerSealImageDto) throws Exception {
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("personalTransactionCode", buyerSealImageDto.getPersonalTransactionCode());
        paramters.put("unifiedTransactionCode", buyerSealImageDto.getUnifiedTransactionCode());
        paramters.put("loginUserType", buyerSealImageDto.getLoginUserType());
        if (StringUtils.isEmpty((String)buyerSealImageDto.getPlatformCode())) {
            paramters.put("platformCode", BaseConfigConstant.platformCode);
        } else {
            paramters.put("platformCode", buyerSealImageDto.getPlatformCode());
        }
        paramters.put("isSealTimestamp", buyerSealImageDto.getIsSealTimestamp());
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/getSealImageList", paramters, buyerSealImageDto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return JSON.parseArray((String)result.getData().toString(), SealImageVo.class);
    }

    public static List<UserOrgVo> getUserOrgList(String allowUserType, String accessToken) throws Exception {
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("allowUserType", allowUserType);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/getUserOrgList", paramters, accessToken);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return JSON.parseArray((String)result.getData().toString(), UserOrgVo.class);
    }

    public static WithdrawSealVo getWithdrawSealSignature(String signCertSn, String accessToken) throws Exception {
        String signOriVal = UuidUtil.getUUID();
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("signCertSn", signCertSn);
        paramters.put("signOriVal", signOriVal);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/getWithdrawSealInfo", paramters, accessToken);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return (WithdrawSealVo)JSON.parseObject((String)result.getData().toString(), WithdrawSealVo.class);
    }

    public static WithdrawSealVo getWithdrawSealSignatureByH5(String signCertSn, String idNumber) throws Exception {
        String signOriVal = UuidUtil.getUUID();
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("idNumber", idNumber);
        paramters.put("signCertSn", signCertSn);
        paramters.put("signOriVal", signOriVal);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/getWithdrawSealInfoByH5", paramters, null);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return (WithdrawSealVo)JSON.parseObject((String)result.getData().toString(), WithdrawSealVo.class);
    }

    public static String setSignHashList(SignHashListDto dto) throws Exception {
        String TId = UuidUtil.getUUID();
        Map paramters = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), HashMap.class);
        paramters.put("TId", TId);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setSignHashList", paramters, dto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return TId;
    }

    public static String platformSetCloudCertInfo(SetCloudCertInfoDto dto) throws Exception {
        String platformCode = GetPlatformConfigUtil.getPlatformCode(dto.getPlatformCode());
        if (StringUtils.isEmpty((String)dto.getTId())) {
            dto.setTId(platformCode + UuidUtil.getUUID());
        }
        Map paramters = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), HashMap.class);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        paramters.put("platformCode", platformCode);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/cloudSign/platformSetCloudCertInfo", paramters, dto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return dto.getTId();
    }

    public static CloudSignCertVo platformSetCloudCertInfoSync(SetCloudCertInfoDto dto) throws Exception {
        String platformCode = GetPlatformConfigUtil.getPlatformCode(dto.getPlatformCode());
        if (StringUtils.isEmpty((String)dto.getTId())) {
            dto.setTId(platformCode + UuidUtil.getUUID());
        }
        Map paramters = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), HashMap.class);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        paramters.put("platformCode", platformCode);
        log.info("\u5e73\u53f0\u540c\u6b65\u8bbe\u7f6e\u4e91\u8bc1\u4e66\u516c\u94a5\u4fe1\u606f\uff08\u6309\u6b21\u6263\u8d39\uff09\u5165\u53c2\uff1a{},token:{}", (Object)paramters, (Object)dto.getAccessToken());
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setCertInfoSync", paramters, dto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        CloudSignCertVo cloudSignCertVo = (CloudSignCertVo)JSON.parseObject((String)JSON.toJSONString((Object)result.getData()), CloudSignCertVo.class);
        cloudSignCertVo.setTId(dto.getTId());
        return cloudSignCertVo;
    }

    public static CloudSignCertVo getCloudCertSealInfo(SetCloudCertInfoDto dto) throws Exception {
        String platformCode = GetPlatformConfigUtil.getPlatformCode(dto.getPlatformCode());
        if (StringUtils.isEmpty((String)dto.getTId())) {
            dto.setTId(platformCode + UuidUtil.getUUID());
        }
        Map paramters = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), HashMap.class);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        paramters.put("platformCode", platformCode);
        log.info("\u5e73\u53f0\u540c\u6b65\u8bbe\u7f6e\u4e91\u8bc1\u4e66\u516c\u94a5\u4fe1\u606f\uff08\u6309\u5e74\u6263\u8d39\uff09\u5165\u53c2\uff1a{},token:{}", (Object)paramters, (Object)dto.getAccessToken());
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/cloudSign/platformSetCloudCertInfoSync", paramters, dto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        CloudSignCertVo cloudSignCertVo = (CloudSignCertVo)JSON.parseObject((String)JSON.toJSONString((Object)result.getData()), CloudSignCertVo.class);
        cloudSignCertVo.setTId(dto.getTId());
        return cloudSignCertVo;
    }

    public static void platformSetCloudSignHashList(SetCloudCertHashListSignInfoDto dto) throws Exception {
        Map paramters = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), HashMap.class);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        if (StringUtils.isEmpty((String)dto.getPlatformCode())) {
            paramters.put("platformCode", BaseConfigConstant.platformCode);
        } else {
            paramters.put("platformCode", dto.getPlatformCode());
        }
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/cloudSign/platformSetCloudSignHashList", paramters, dto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
    }

    public static CloudSignValueListVo platformSetCloudSignHashListSync(SetCloudCertHashListSignInfoDto dto) throws Exception {
        Map paramters = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), HashMap.class);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        if (StringUtils.isEmpty((String)dto.getPlatformCode())) {
            paramters.put("platformCode", BaseConfigConstant.platformCode);
        } else {
            paramters.put("platformCode", dto.getPlatformCode());
        }
        log.info("\u7b7e\u7ae0Hash\u4fe1\u606f\u5165\u53c2\uff1a{},token:{}", (Object)paramters, (Object)dto.getAccessToken());
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setSignHashListSync", paramters, dto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return (CloudSignValueListVo)JSON.parseObject((String)JSON.toJSONString((Object)result.getData()), CloudSignValueListVo.class);
    }

    public static CloudSignValueListVo setCloudSignHashListSync(SetCloudCertHashListSignInfoDto dto) throws Exception {
        Map paramters = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), HashMap.class);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        if (StringUtils.isEmpty((String)dto.getPlatformCode())) {
            paramters.put("platformCode", BaseConfigConstant.platformCode);
        } else {
            paramters.put("platformCode", dto.getPlatformCode());
        }
        log.info("\u7b7e\u7ae0Hash\u4fe1\u606f\u5165\u53c2\uff1a{},token:{}", (Object)paramters, (Object)dto.getAccessToken());
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/cloudSign/platformSetCloudSignHashListSync", paramters, dto.getAccessToken());
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        return (CloudSignValueListVo)JSON.parseObject((String)JSON.toJSONString((Object)result.getData()), CloudSignValueListVo.class);
    }

    public static void setExitNotice(String PId, String TId, String exitReason, String token) throws Exception {
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("PId", PId);
        paramters.put("TId", TId);
        paramters.put("exitReason", exitReason);
        paramters.put("source", "01");
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setExitNoticeToBuyerService", paramters, token);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
    }
}

