/*
 * Decompiled with CFR 0.152.
 */
package com.zzhl.buyer.util;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.seal.base.bean.appearance.AbstractAppearance;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.sign.SealResultInfo;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.AsynCFCASigner;
import cfca.sadk.seal.util.AsyncSignatureUtil;
import cfca.sadk.seal.util.VerifyUtil;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Base64;
import com.zzhl.buyer.dto.CombineSignDto;
import com.zzhl.buyer.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;

public class CombineSignUtil {
    private static final BouncyCastleProvider provider = new BouncyCastleProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean synthesisSignature(CombineSignDto dto) throws Exception {
        byte[] stamperSrc = Base64.decode((String)dto.getSealImage());
        Integer len = dto.getSrc().lastIndexOf(".");
        String filePath = dto.getSrc().substring(0, len > 0 ? len.intValue() : dto.getSrc().length()) + "min.pdf";
        String FilePathExternal = dto.getSrc();
        String signFieldName = dto.getSignFieldName();
        int coordinatePage = dto.getCoordinatePage();
        String signatureReason = dto.getReason();
        float coordinateTransverse = dto.getCoordinateTransverse().floatValue();
        float coordinateLongitudinal = dto.getCoordinateLongitudinal().floatValue();
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setPageNum(coordinatePage);
        appearance.setReason(signatureReason);
        appearance.setSignFieldName(signFieldName);
        appearance.setRectangle(new Rectangle(coordinateTransverse, coordinateLongitudinal, 200.0f, 200.0f));
        appearance.setLocation("Ghent");
        appearance.setStamperSr(stamperSrc);
        appearance.setTransparency(1.0f);
        appearance.setCenterCoordinate();
        String p7Sig = dto.getSignatureValue();
        AsynCFCASigner p7Signer = null;
        if ("01".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SM3_SM2);
        }
        FileInputStream fileInputStream = new FileInputStream(filePath);
        FileOutputStream fileOutputStream = new FileOutputStream(FilePathExternal);
        try {
            AsyncSignatureUtil.combineExternalP7Signature((InputStream)fileInputStream, (OutputStream)fileOutputStream, (AbstractAppearance)appearance, (AbstractExternalP7Signer)p7Signer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            FileUtil.delete(filePath);
        }
        SealVerifyResult verifyResult = VerifyUtil.verify((byte[])FileHelper.read((String)FilePathExternal));
        return verifyResult.getVerifyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean batchSynthesisSignature(CombineSignDto dto) throws Exception {
        Security.addProvider((Provider)provider);
        byte[] stamperSrc = new org.apache.commons.codec.binary.Base64().decode(dto.getSealImage());
        String src = dto.getSrc();
        String filePath = src.substring(0, src.lastIndexOf(".")) + "min.pdf";
        String filePath_external = dto.getSrc();
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setSignFieldName(dto.getSignFieldName());
        appearance.setPageNum(0);
        appearance.setReason(dto.getReason());
        appearance.setGSBlendMode(0);
        appearance.setLocation(dto.getLocation());
        appearance.setTransparency(0.8f);
        appearance.setStamperSr(stamperSrc);
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        String p7Sig = dto.getSignatureValue();
        AsynCFCASigner p7Signer = null;
        if ("01".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SM3_SM2);
        }
        FileInputStream fileInputStream = new FileInputStream(filePath);
        FileOutputStream fileOutputStream = new FileOutputStream(filePath_external);
        try {
            SealResultInfo result = AsyncSignatureUtil.combineExternalP7Signature((InputStream)fileInputStream, (OutputStream)fileOutputStream, (AbstractAppearance)appearance, (AbstractExternalP7Signer)p7Signer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        SealVerifyResult verifyResult = VerifyUtil.verify((byte[])FileHelper.read((String)filePath_external));
        File file = new File(filePath);
        file.delete();
        return verifyResult.getVerifyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean synthesisSignatureKeyword(CombineSignDto dto) throws Exception {
        byte[] stamperSrc = Base64.decode((String)dto.getSealImage());
        Integer len = dto.getSrc().lastIndexOf(".");
        String filePath = dto.getSrc().substring(0, len > 0 ? len.intValue() : dto.getSrc().length()) + "min.pdf";
        String filePath_external = dto.getSrc();
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setSignFieldName(dto.getSignFieldName());
        appearance.setPageNum(0);
        appearance.setReason(dto.getReason());
        appearance.setGSBlendMode(0);
        appearance.setLocation(dto.getLocation());
        appearance.setTransparency(0.8f);
        appearance.setStamperSr(stamperSrc);
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        String p7Sig = dto.getSignatureValue();
        AsynCFCASigner p7Signer = null;
        if ("01".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SM3_SM2);
        }
        FileInputStream fileInputStream = new FileInputStream(filePath);
        FileOutputStream fileOutputStream = new FileOutputStream(filePath_external);
        try {
            AsyncSignatureUtil.combineExternalP7Signature((InputStream)fileInputStream, (OutputStream)fileOutputStream, (AbstractAppearance)appearance, (AbstractExternalP7Signer)p7Signer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            FileUtil.delete(filePath);
        }
        SealVerifyResult verifyResult = VerifyUtil.verify((byte[])FileHelper.read((String)filePath_external));
        return verifyResult.getVerifyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean gapSynthesisSignature(CombineSignDto dto) throws Exception {
        byte[] stamperSrc = Base64.decode((String)dto.getSealImage());
        String src = dto.getSrc();
        String filePath = src.substring(0, src.lastIndexOf(".")) + "min.pdf";
        String filePath_external = dto.getSrc();
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setSignFieldName(dto.getSignFieldName());
        appearance.setStartPageNum(-1);
        appearance.setEndPageNum(-1);
        appearance.setReason("\u540c\u610f\u7b7e\u7ae0");
        appearance.setFirstPagePercent(dto.getFirstPagePercent());
        appearance.setLastPagePercent(dto.getLastPagePercent());
        appearance.setRectangle(new Rectangle(dto.getCoordinateLongitudinal().floatValue(), dto.getCoordinateTransverse().floatValue(), 100.0f, 100.0f));
        appearance.setMoveCrossPosition(true);
        appearance.setCrossPageStyle(6);
        appearance.setGSBlendMode(0);
        appearance.setStamperSr(stamperSrc);
        appearance.setTransparency(0.7f);
        appearance.setLocation("\u5317\u4eac");
        appearance.setImageFormat("png");
        appearance.setCrossPageRangeOption(0);
        appearance.setDpi(115);
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        String p7Sig = dto.getSignatureValue();
        AsynCFCASigner p7Signer = null;
        if ("01".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            p7Signer = new AsynCFCASigner(Base64.decode((String)p7Sig), Mechanisms.M_SM3_SM2);
        }
        FileInputStream fileInputStream = new FileInputStream(filePath);
        FileOutputStream fileOutputStream = new FileOutputStream(filePath_external);
        try {
            AsyncSignatureUtil.combineExternalP7Signature((InputStream)fileInputStream, (OutputStream)fileOutputStream, (AbstractAppearance)appearance, (AbstractExternalP7Signer)p7Signer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            FileUtil.delete(filePath);
        }
        SealVerifyResult verifyResult = VerifyUtil.verify((byte[])FileHelper.read((String)filePath_external));
        return verifyResult.getVerifyResult();
    }

    static {
        Security.addProvider((Provider)provider);
    }
}

